# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AppMonitorAppMonitorConfigurationArgs',
    'AppMonitorAppMonitorConfigurationArgsDict',
    'AppMonitorCustomEventsArgs',
    'AppMonitorCustomEventsArgsDict',
]

MYPY = False

if not MYPY:
    class AppMonitorAppMonitorConfigurationArgsDict(TypedDict):
        allow_cookies: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If you set this to `true`, RUM web client sets two cookies, a session cookie and a user cookie. The cookies allow the RUM web client to collect data relating to the number of users an application has and the behavior of the application across a sequence of events. Cookies are stored in the top-level domain of the current page.
        """
        enable_xray: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If you set this to `true`, RUM enables X-Ray tracing for the user sessions that RUM samples. RUM adds an X-Ray trace header to allowed HTTP requests. It also records an X-Ray segment for allowed HTTP requests.
        """
        excluded_pages: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of URLs in your website or application to exclude from RUM data collection.
        """
        favorite_pages: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of pages in the CloudWatch RUM console that are to be displayed with a "favorite" icon.
        """
        guest_role_arn: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ARN of the guest IAM role that is attached to the Amazon Cognito identity pool that is used to authorize the sending of data to RUM.
        """
        identity_pool_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the Amazon Cognito identity pool that is used to authorize the sending of data to RUM.
        """
        included_pages: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        If this app monitor is to collect data from only certain pages in your application, this structure lists those pages.
        """
        session_sample_rate: NotRequired[pulumi.Input[_builtins.float]]
        """
        Specifies the percentage of user sessions to use for RUM data collection. Choosing a higher percentage gives you more data but also incurs more costs. The number you specify is the percentage of user sessions that will be used. Default value is `0.1`.
        """
        telemetries: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        An array that lists the types of telemetry data that this app monitor is to collect. Valid values are `errors`, `performance`, and `http`.
        """
elif False:
    AppMonitorAppMonitorConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppMonitorAppMonitorConfigurationArgs:
    def __init__(__self__, *,
                 allow_cookies: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_xray: Optional[pulumi.Input[_builtins.bool]] = None,
                 excluded_pages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 favorite_pages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 guest_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 included_pages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 session_sample_rate: Optional[pulumi.Input[_builtins.float]] = None,
                 telemetries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.bool] allow_cookies: If you set this to `true`, RUM web client sets two cookies, a session cookie and a user cookie. The cookies allow the RUM web client to collect data relating to the number of users an application has and the behavior of the application across a sequence of events. Cookies are stored in the top-level domain of the current page.
        :param pulumi.Input[_builtins.bool] enable_xray: If you set this to `true`, RUM enables X-Ray tracing for the user sessions that RUM samples. RUM adds an X-Ray trace header to allowed HTTP requests. It also records an X-Ray segment for allowed HTTP requests.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excluded_pages: A list of URLs in your website or application to exclude from RUM data collection.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] favorite_pages: A list of pages in the CloudWatch RUM console that are to be displayed with a "favorite" icon.
        :param pulumi.Input[_builtins.str] guest_role_arn: The ARN of the guest IAM role that is attached to the Amazon Cognito identity pool that is used to authorize the sending of data to RUM.
        :param pulumi.Input[_builtins.str] identity_pool_id: The ID of the Amazon Cognito identity pool that is used to authorize the sending of data to RUM.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] included_pages: If this app monitor is to collect data from only certain pages in your application, this structure lists those pages.
        :param pulumi.Input[_builtins.float] session_sample_rate: Specifies the percentage of user sessions to use for RUM data collection. Choosing a higher percentage gives you more data but also incurs more costs. The number you specify is the percentage of user sessions that will be used. Default value is `0.1`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] telemetries: An array that lists the types of telemetry data that this app monitor is to collect. Valid values are `errors`, `performance`, and `http`.
        """
        if allow_cookies is not None:
            pulumi.set(__self__, "allow_cookies", allow_cookies)
        if enable_xray is not None:
            pulumi.set(__self__, "enable_xray", enable_xray)
        if excluded_pages is not None:
            pulumi.set(__self__, "excluded_pages", excluded_pages)
        if favorite_pages is not None:
            pulumi.set(__self__, "favorite_pages", favorite_pages)
        if guest_role_arn is not None:
            pulumi.set(__self__, "guest_role_arn", guest_role_arn)
        if identity_pool_id is not None:
            pulumi.set(__self__, "identity_pool_id", identity_pool_id)
        if included_pages is not None:
            pulumi.set(__self__, "included_pages", included_pages)
        if session_sample_rate is not None:
            pulumi.set(__self__, "session_sample_rate", session_sample_rate)
        if telemetries is not None:
            pulumi.set(__self__, "telemetries", telemetries)

    @_builtins.property
    @pulumi.getter(name="allowCookies")
    def allow_cookies(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If you set this to `true`, RUM web client sets two cookies, a session cookie and a user cookie. The cookies allow the RUM web client to collect data relating to the number of users an application has and the behavior of the application across a sequence of events. Cookies are stored in the top-level domain of the current page.
        """
        return pulumi.get(self, "allow_cookies")

    @allow_cookies.setter
    def allow_cookies(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_cookies", value)

    @_builtins.property
    @pulumi.getter(name="enableXray")
    def enable_xray(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If you set this to `true`, RUM enables X-Ray tracing for the user sessions that RUM samples. RUM adds an X-Ray trace header to allowed HTTP requests. It also records an X-Ray segment for allowed HTTP requests.
        """
        return pulumi.get(self, "enable_xray")

    @enable_xray.setter
    def enable_xray(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_xray", value)

    @_builtins.property
    @pulumi.getter(name="excludedPages")
    def excluded_pages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of URLs in your website or application to exclude from RUM data collection.
        """
        return pulumi.get(self, "excluded_pages")

    @excluded_pages.setter
    def excluded_pages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "excluded_pages", value)

    @_builtins.property
    @pulumi.getter(name="favoritePages")
    def favorite_pages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of pages in the CloudWatch RUM console that are to be displayed with a "favorite" icon.
        """
        return pulumi.get(self, "favorite_pages")

    @favorite_pages.setter
    def favorite_pages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "favorite_pages", value)

    @_builtins.property
    @pulumi.getter(name="guestRoleArn")
    def guest_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the guest IAM role that is attached to the Amazon Cognito identity pool that is used to authorize the sending of data to RUM.
        """
        return pulumi.get(self, "guest_role_arn")

    @guest_role_arn.setter
    def guest_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "guest_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="identityPoolId")
    def identity_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Amazon Cognito identity pool that is used to authorize the sending of data to RUM.
        """
        return pulumi.get(self, "identity_pool_id")

    @identity_pool_id.setter
    def identity_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="includedPages")
    def included_pages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        If this app monitor is to collect data from only certain pages in your application, this structure lists those pages.
        """
        return pulumi.get(self, "included_pages")

    @included_pages.setter
    def included_pages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "included_pages", value)

    @_builtins.property
    @pulumi.getter(name="sessionSampleRate")
    def session_sample_rate(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Specifies the percentage of user sessions to use for RUM data collection. Choosing a higher percentage gives you more data but also incurs more costs. The number you specify is the percentage of user sessions that will be used. Default value is `0.1`.
        """
        return pulumi.get(self, "session_sample_rate")

    @session_sample_rate.setter
    def session_sample_rate(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "session_sample_rate", value)

    @_builtins.property
    @pulumi.getter
    def telemetries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An array that lists the types of telemetry data that this app monitor is to collect. Valid values are `errors`, `performance`, and `http`.
        """
        return pulumi.get(self, "telemetries")

    @telemetries.setter
    def telemetries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "telemetries", value)


if not MYPY:
    class AppMonitorCustomEventsArgsDict(TypedDict):
        status: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies whether this app monitor allows the web client to define and send custom events. The default is for custom events to be `DISABLED`. Valid values are `DISABLED` and `ENABLED`.
        """
elif False:
    AppMonitorCustomEventsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppMonitorCustomEventsArgs:
    def __init__(__self__, *,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] status: Specifies whether this app monitor allows the web client to define and send custom events. The default is for custom events to be `DISABLED`. Valid values are `DISABLED` and `ENABLED`.
        """
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether this app monitor allows the web client to define and send custom events. The default is for custom events to be `DISABLED`. Valid values are `DISABLED` and `ENABLED`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


