# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BucketAclArgs', 'BucketAcl']

@pulumi.input_type
class BucketAclArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[_builtins.str],
                 access_control_policy: Optional[pulumi.Input['BucketAclAccessControlPolicyArgs']] = None,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 expected_bucket_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BucketAcl resource.
        :param pulumi.Input[_builtins.str] bucket: Bucket to which to apply the ACL.
        :param pulumi.Input['BucketAclAccessControlPolicyArgs'] access_control_policy: Configuration block that sets the ACL permissions for an object per grantee. See below.
        :param pulumi.Input[_builtins.str] acl: Specifies the Canned ACL to apply to the bucket. Valid values: `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, `bucket-owner-full-control`, `log-delivery-write`. Full details are available on the [AWS documentation](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl).
        :param pulumi.Input[_builtins.str] expected_bucket_owner: Account ID of the expected bucket owner.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "bucket", bucket)
        if access_control_policy is not None:
            pulumi.set(__self__, "access_control_policy", access_control_policy)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if expected_bucket_owner is not None:
            pulumi.set(__self__, "expected_bucket_owner", expected_bucket_owner)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[_builtins.str]:
        """
        Bucket to which to apply the ACL.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="accessControlPolicy")
    def access_control_policy(self) -> Optional[pulumi.Input['BucketAclAccessControlPolicyArgs']]:
        """
        Configuration block that sets the ACL permissions for an object per grantee. See below.
        """
        return pulumi.get(self, "access_control_policy")

    @access_control_policy.setter
    def access_control_policy(self, value: Optional[pulumi.Input['BucketAclAccessControlPolicyArgs']]):
        pulumi.set(self, "access_control_policy", value)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Canned ACL to apply to the bucket. Valid values: `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, `bucket-owner-full-control`, `log-delivery-write`. Full details are available on the [AWS documentation](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl).
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl", value)

    @_builtins.property
    @pulumi.getter(name="expectedBucketOwner")
    def expected_bucket_owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account ID of the expected bucket owner.
        """
        return pulumi.get(self, "expected_bucket_owner")

    @expected_bucket_owner.setter
    def expected_bucket_owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expected_bucket_owner", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _BucketAclState:
    def __init__(__self__, *,
                 access_control_policy: Optional[pulumi.Input['BucketAclAccessControlPolicyArgs']] = None,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 expected_bucket_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BucketAcl resources.
        :param pulumi.Input['BucketAclAccessControlPolicyArgs'] access_control_policy: Configuration block that sets the ACL permissions for an object per grantee. See below.
        :param pulumi.Input[_builtins.str] acl: Specifies the Canned ACL to apply to the bucket. Valid values: `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, `bucket-owner-full-control`, `log-delivery-write`. Full details are available on the [AWS documentation](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl).
        :param pulumi.Input[_builtins.str] bucket: Bucket to which to apply the ACL.
        :param pulumi.Input[_builtins.str] expected_bucket_owner: Account ID of the expected bucket owner.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if access_control_policy is not None:
            pulumi.set(__self__, "access_control_policy", access_control_policy)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if expected_bucket_owner is not None:
            pulumi.set(__self__, "expected_bucket_owner", expected_bucket_owner)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="accessControlPolicy")
    def access_control_policy(self) -> Optional[pulumi.Input['BucketAclAccessControlPolicyArgs']]:
        """
        Configuration block that sets the ACL permissions for an object per grantee. See below.
        """
        return pulumi.get(self, "access_control_policy")

    @access_control_policy.setter
    def access_control_policy(self, value: Optional[pulumi.Input['BucketAclAccessControlPolicyArgs']]):
        pulumi.set(self, "access_control_policy", value)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Canned ACL to apply to the bucket. Valid values: `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, `bucket-owner-full-control`, `log-delivery-write`. Full details are available on the [AWS documentation](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl).
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl", value)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Bucket to which to apply the ACL.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="expectedBucketOwner")
    def expected_bucket_owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account ID of the expected bucket owner.
        """
        return pulumi.get(self, "expected_bucket_owner")

    @expected_bucket_owner.setter
    def expected_bucket_owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expected_bucket_owner", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:s3/bucketAcl:BucketAcl")
class BucketAcl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_control_policy: Optional[pulumi.Input[Union['BucketAclAccessControlPolicyArgs', 'BucketAclAccessControlPolicyArgsDict']]] = None,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 expected_bucket_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an S3 bucket ACL resource.

        > **Note:** destroy does not delete the S3 Bucket ACL but does remove the resource from state.

        > This resource cannot be used with S3 directory buckets.

        ## Example Usage

        ### With `private` ACL

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.Bucket("example", bucket="my-tf-example-bucket")
        example_bucket_ownership_controls = aws.s3.BucketOwnershipControls("example",
            bucket=example.id,
            rule={
                "object_ownership": "BucketOwnerPreferred",
            })
        example_bucket_acl = aws.s3.BucketAcl("example",
            bucket=example.id,
            acl="private",
            opts = pulumi.ResourceOptions(depends_on=[example_bucket_ownership_controls]))
        ```

        ### With `public-read` ACL

        > This example explicitly disables the default S3 bucket security settings. This
        should be done with caution, as all bucket objects become publicly exposed.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.Bucket("example", bucket="my-tf-example-bucket")
        example_bucket_ownership_controls = aws.s3.BucketOwnershipControls("example",
            bucket=example.id,
            rule={
                "object_ownership": "BucketOwnerPreferred",
            })
        example_bucket_public_access_block = aws.s3.BucketPublicAccessBlock("example",
            bucket=example.id,
            block_public_acls=False,
            block_public_policy=False,
            ignore_public_acls=False,
            restrict_public_buckets=False)
        example_bucket_acl = aws.s3.BucketAcl("example",
            bucket=example.id,
            acl="public-read",
            opts = pulumi.ResourceOptions(depends_on=[
                    example_bucket_ownership_controls,
                    example_bucket_public_access_block,
                ]))
        ```

        ### With Grants

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.s3.get_canonical_user_id()
        example = aws.s3.Bucket("example", bucket="my-tf-example-bucket")
        example_bucket_ownership_controls = aws.s3.BucketOwnershipControls("example",
            bucket=example.id,
            rule={
                "object_ownership": "BucketOwnerPreferred",
            })
        example_bucket_acl = aws.s3.BucketAcl("example",
            bucket=example.id,
            access_control_policy={
                "grants": [
                    {
                        "grantee": {
                            "id": current.id,
                            "type": "CanonicalUser",
                        },
                        "permission": "READ",
                    },
                    {
                        "grantee": {
                            "type": "Group",
                            "uri": "http://acs.amazonaws.com/groups/s3/LogDelivery",
                        },
                        "permission": "READ_ACP",
                    },
                ],
                "owner": {
                    "id": current.id,
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[example_bucket_ownership_controls]))
        ```

        ## Import

        ### Identity Schema

        #### Required

        * `bucket` (String) S3 bucket name.

        #### Optional

        * `account_id` (String) AWS Account where this resource is managed.

        * `acl` (String) Canned ACL to apply to the bucket.

        * `expected_bucket_owner` (String) Account ID of the expected bucket owner.

        * `region` (String) Region where this resource is managed.

        If the owner (account ID) of the source bucket is the _same_ account used to configure the AWS Provider, and the source bucket is **configured** with a

        [canned ACL][1] (i.e. predefined grant), import using the `bucket` and `acl` separated by a comma (`,`):

        terraform

        import {

          to = aws_s3_bucket_acl.example

          id = "bucket-name,private"

        }

        If the owner (account ID) of the source bucket _differs_ from the account used to configure the AWS Provider, and the source bucket is **not configured** with a [canned ACL][1] (i.e. predefined grant), imported using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):

        terraform

        import {

          to = aws_s3_bucket_acl.example

          id = "bucket-name,123456789012"

        }

        If the owner (account ID) of the source bucket _differs_ from the account used to configure the AWS Provider, and the source bucket is **configured** with a

        [canned ACL][1] (i.e. predefined grant), imported using the `bucket`, `expected_bucket_owner`, and `acl` separated by commas (`,`):

        terraform

        import {

          to = aws_s3_bucket_acl.example

          id = "bucket-name,123456789012,private"

        }

        **Using `pulumi import` to import** using `bucket`, `expected_bucket_owner`, and/or `acl`, depending on your situation. For example:

        If the owner (account ID) of the source bucket is the _same_ account used to configure the AWS Provider, and the source bucket is **not configured** with a

        [canned ACL][1] (i.e. predefined grant), import using the `bucket`:

        console

        % pulumi import aws_s3_bucket_acl.example bucket-name

        If the owner (account ID) of the source bucket is the _same_ account used to configure the AWS Provider, and the source bucket is **configured** with a [canned ACL][1] (i.e. predefined grant), import using the `bucket` and `acl` separated by a comma (`,`):

        console

        % pulumi import aws_s3_bucket_acl.example bucket-name,private

        If the owner (account ID) of the source bucket _differs_ from the account used to configure the AWS Provider, and the source bucket is **not configured** with a [canned ACL][1] (i.e. predefined grant), imported using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):

        console

        % pulumi import aws_s3_bucket_acl.example bucket-name,123456789012

        If the owner (account ID) of the source bucket _differs_ from the account used to configure the AWS Provider, and the source bucket is **configured** with a [canned ACL][1] (i.e. predefined grant), imported using the `bucket`, `expected_bucket_owner`, and `acl` separated by commas (`,`):

        console

        % pulumi import aws_s3_bucket_acl.example bucket-name,123456789012,private

        [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['BucketAclAccessControlPolicyArgs', 'BucketAclAccessControlPolicyArgsDict']] access_control_policy: Configuration block that sets the ACL permissions for an object per grantee. See below.
        :param pulumi.Input[_builtins.str] acl: Specifies the Canned ACL to apply to the bucket. Valid values: `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, `bucket-owner-full-control`, `log-delivery-write`. Full details are available on the [AWS documentation](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl).
        :param pulumi.Input[_builtins.str] bucket: Bucket to which to apply the ACL.
        :param pulumi.Input[_builtins.str] expected_bucket_owner: Account ID of the expected bucket owner.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BucketAclArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an S3 bucket ACL resource.

        > **Note:** destroy does not delete the S3 Bucket ACL but does remove the resource from state.

        > This resource cannot be used with S3 directory buckets.

        ## Example Usage

        ### With `private` ACL

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.Bucket("example", bucket="my-tf-example-bucket")
        example_bucket_ownership_controls = aws.s3.BucketOwnershipControls("example",
            bucket=example.id,
            rule={
                "object_ownership": "BucketOwnerPreferred",
            })
        example_bucket_acl = aws.s3.BucketAcl("example",
            bucket=example.id,
            acl="private",
            opts = pulumi.ResourceOptions(depends_on=[example_bucket_ownership_controls]))
        ```

        ### With `public-read` ACL

        > This example explicitly disables the default S3 bucket security settings. This
        should be done with caution, as all bucket objects become publicly exposed.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.Bucket("example", bucket="my-tf-example-bucket")
        example_bucket_ownership_controls = aws.s3.BucketOwnershipControls("example",
            bucket=example.id,
            rule={
                "object_ownership": "BucketOwnerPreferred",
            })
        example_bucket_public_access_block = aws.s3.BucketPublicAccessBlock("example",
            bucket=example.id,
            block_public_acls=False,
            block_public_policy=False,
            ignore_public_acls=False,
            restrict_public_buckets=False)
        example_bucket_acl = aws.s3.BucketAcl("example",
            bucket=example.id,
            acl="public-read",
            opts = pulumi.ResourceOptions(depends_on=[
                    example_bucket_ownership_controls,
                    example_bucket_public_access_block,
                ]))
        ```

        ### With Grants

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.s3.get_canonical_user_id()
        example = aws.s3.Bucket("example", bucket="my-tf-example-bucket")
        example_bucket_ownership_controls = aws.s3.BucketOwnershipControls("example",
            bucket=example.id,
            rule={
                "object_ownership": "BucketOwnerPreferred",
            })
        example_bucket_acl = aws.s3.BucketAcl("example",
            bucket=example.id,
            access_control_policy={
                "grants": [
                    {
                        "grantee": {
                            "id": current.id,
                            "type": "CanonicalUser",
                        },
                        "permission": "READ",
                    },
                    {
                        "grantee": {
                            "type": "Group",
                            "uri": "http://acs.amazonaws.com/groups/s3/LogDelivery",
                        },
                        "permission": "READ_ACP",
                    },
                ],
                "owner": {
                    "id": current.id,
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[example_bucket_ownership_controls]))
        ```

        ## Import

        ### Identity Schema

        #### Required

        * `bucket` (String) S3 bucket name.

        #### Optional

        * `account_id` (String) AWS Account where this resource is managed.

        * `acl` (String) Canned ACL to apply to the bucket.

        * `expected_bucket_owner` (String) Account ID of the expected bucket owner.

        * `region` (String) Region where this resource is managed.

        If the owner (account ID) of the source bucket is the _same_ account used to configure the AWS Provider, and the source bucket is **configured** with a

        [canned ACL][1] (i.e. predefined grant), import using the `bucket` and `acl` separated by a comma (`,`):

        terraform

        import {

          to = aws_s3_bucket_acl.example

          id = "bucket-name,private"

        }

        If the owner (account ID) of the source bucket _differs_ from the account used to configure the AWS Provider, and the source bucket is **not configured** with a [canned ACL][1] (i.e. predefined grant), imported using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):

        terraform

        import {

          to = aws_s3_bucket_acl.example

          id = "bucket-name,123456789012"

        }

        If the owner (account ID) of the source bucket _differs_ from the account used to configure the AWS Provider, and the source bucket is **configured** with a

        [canned ACL][1] (i.e. predefined grant), imported using the `bucket`, `expected_bucket_owner`, and `acl` separated by commas (`,`):

        terraform

        import {

          to = aws_s3_bucket_acl.example

          id = "bucket-name,123456789012,private"

        }

        **Using `pulumi import` to import** using `bucket`, `expected_bucket_owner`, and/or `acl`, depending on your situation. For example:

        If the owner (account ID) of the source bucket is the _same_ account used to configure the AWS Provider, and the source bucket is **not configured** with a

        [canned ACL][1] (i.e. predefined grant), import using the `bucket`:

        console

        % pulumi import aws_s3_bucket_acl.example bucket-name

        If the owner (account ID) of the source bucket is the _same_ account used to configure the AWS Provider, and the source bucket is **configured** with a [canned ACL][1] (i.e. predefined grant), import using the `bucket` and `acl` separated by a comma (`,`):

        console

        % pulumi import aws_s3_bucket_acl.example bucket-name,private

        If the owner (account ID) of the source bucket _differs_ from the account used to configure the AWS Provider, and the source bucket is **not configured** with a [canned ACL][1] (i.e. predefined grant), imported using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):

        console

        % pulumi import aws_s3_bucket_acl.example bucket-name,123456789012

        If the owner (account ID) of the source bucket _differs_ from the account used to configure the AWS Provider, and the source bucket is **configured** with a [canned ACL][1] (i.e. predefined grant), imported using the `bucket`, `expected_bucket_owner`, and `acl` separated by commas (`,`):

        console

        % pulumi import aws_s3_bucket_acl.example bucket-name,123456789012,private

        [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl

        :param str resource_name: The name of the resource.
        :param BucketAclArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BucketAclArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_control_policy: Optional[pulumi.Input[Union['BucketAclAccessControlPolicyArgs', 'BucketAclAccessControlPolicyArgsDict']]] = None,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 expected_bucket_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BucketAclArgs.__new__(BucketAclArgs)

            __props__.__dict__["access_control_policy"] = access_control_policy
            __props__.__dict__["acl"] = acl
            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["expected_bucket_owner"] = expected_bucket_owner
            __props__.__dict__["region"] = region
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="aws:s3/bucketAclV2:BucketAclV2")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(BucketAcl, __self__).__init__(
            'aws:s3/bucketAcl:BucketAcl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_control_policy: Optional[pulumi.Input[Union['BucketAclAccessControlPolicyArgs', 'BucketAclAccessControlPolicyArgsDict']]] = None,
            acl: Optional[pulumi.Input[_builtins.str]] = None,
            bucket: Optional[pulumi.Input[_builtins.str]] = None,
            expected_bucket_owner: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'BucketAcl':
        """
        Get an existing BucketAcl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['BucketAclAccessControlPolicyArgs', 'BucketAclAccessControlPolicyArgsDict']] access_control_policy: Configuration block that sets the ACL permissions for an object per grantee. See below.
        :param pulumi.Input[_builtins.str] acl: Specifies the Canned ACL to apply to the bucket. Valid values: `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, `bucket-owner-full-control`, `log-delivery-write`. Full details are available on the [AWS documentation](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl).
        :param pulumi.Input[_builtins.str] bucket: Bucket to which to apply the ACL.
        :param pulumi.Input[_builtins.str] expected_bucket_owner: Account ID of the expected bucket owner.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BucketAclState.__new__(_BucketAclState)

        __props__.__dict__["access_control_policy"] = access_control_policy
        __props__.__dict__["acl"] = acl
        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["expected_bucket_owner"] = expected_bucket_owner
        __props__.__dict__["region"] = region
        return BucketAcl(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessControlPolicy")
    def access_control_policy(self) -> pulumi.Output['outputs.BucketAclAccessControlPolicy']:
        """
        Configuration block that sets the ACL permissions for an object per grantee. See below.
        """
        return pulumi.get(self, "access_control_policy")

    @_builtins.property
    @pulumi.getter
    def acl(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the Canned ACL to apply to the bucket. Valid values: `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, `bucket-owner-full-control`, `log-delivery-write`. Full details are available on the [AWS documentation](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl).
        """
        return pulumi.get(self, "acl")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[_builtins.str]:
        """
        Bucket to which to apply the ACL.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="expectedBucketOwner")
    def expected_bucket_owner(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Account ID of the expected bucket owner.
        """
        return pulumi.get(self, "expected_bucket_owner")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

