# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'TableBucketEncryptionConfiguration',
    'TableBucketMaintenanceConfiguration',
    'TableBucketMaintenanceConfigurationIcebergUnreferencedFileRemoval',
    'TableBucketMaintenanceConfigurationIcebergUnreferencedFileRemovalSettings',
    'TableEncryptionConfiguration',
    'TableMaintenanceConfiguration',
    'TableMaintenanceConfigurationIcebergCompaction',
    'TableMaintenanceConfigurationIcebergCompactionSettings',
    'TableMaintenanceConfigurationIcebergSnapshotManagement',
    'TableMaintenanceConfigurationIcebergSnapshotManagementSettings',
    'TableMetadata',
    'TableMetadataIceberg',
    'TableMetadataIcebergSchema',
    'TableMetadataIcebergSchemaField',
]

@pulumi.output_type
class TableBucketEncryptionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyArn":
            suggest = "kms_key_arn"
        elif key == "sseAlgorithm":
            suggest = "sse_algorithm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableBucketEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableBucketEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableBucketEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_arn: _builtins.str,
                 sse_algorithm: _builtins.str):
        """
        :param _builtins.str kms_key_arn: The ARN of a KMS Key to be used with `aws:kms` `sse_algorithm`
        :param _builtins.str sse_algorithm: One of `aws:kms` or `AES256`
        """
        pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        pulumi.set(__self__, "sse_algorithm", sse_algorithm)

    @_builtins.property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> _builtins.str:
        """
        The ARN of a KMS Key to be used with `aws:kms` `sse_algorithm`
        """
        return pulumi.get(self, "kms_key_arn")

    @_builtins.property
    @pulumi.getter(name="sseAlgorithm")
    def sse_algorithm(self) -> _builtins.str:
        """
        One of `aws:kms` or `AES256`
        """
        return pulumi.get(self, "sse_algorithm")


@pulumi.output_type
class TableBucketMaintenanceConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "icebergUnreferencedFileRemoval":
            suggest = "iceberg_unreferenced_file_removal"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableBucketMaintenanceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableBucketMaintenanceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableBucketMaintenanceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 iceberg_unreferenced_file_removal: 'outputs.TableBucketMaintenanceConfigurationIcebergUnreferencedFileRemoval'):
        """
        :param 'TableBucketMaintenanceConfigurationIcebergUnreferencedFileRemovalArgs' iceberg_unreferenced_file_removal: A single Iceberg unreferenced file removal settings object.
               See `iceberg_unreferenced_file_removal` below.
        """
        pulumi.set(__self__, "iceberg_unreferenced_file_removal", iceberg_unreferenced_file_removal)

    @_builtins.property
    @pulumi.getter(name="icebergUnreferencedFileRemoval")
    def iceberg_unreferenced_file_removal(self) -> 'outputs.TableBucketMaintenanceConfigurationIcebergUnreferencedFileRemoval':
        """
        A single Iceberg unreferenced file removal settings object.
        See `iceberg_unreferenced_file_removal` below.
        """
        return pulumi.get(self, "iceberg_unreferenced_file_removal")


@pulumi.output_type
class TableBucketMaintenanceConfigurationIcebergUnreferencedFileRemoval(dict):
    def __init__(__self__, *,
                 settings: 'outputs.TableBucketMaintenanceConfigurationIcebergUnreferencedFileRemovalSettings',
                 status: _builtins.str):
        """
        :param 'TableBucketMaintenanceConfigurationIcebergUnreferencedFileRemovalSettingsArgs' settings: Settings object for unreferenced file removal.
               See `iceberg_unreferenced_file_removal.settings` below.
        :param _builtins.str status: Whether the configuration is enabled.
               Valid values are `enabled` and `disabled`.
        """
        pulumi.set(__self__, "settings", settings)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def settings(self) -> 'outputs.TableBucketMaintenanceConfigurationIcebergUnreferencedFileRemovalSettings':
        """
        Settings object for unreferenced file removal.
        See `iceberg_unreferenced_file_removal.settings` below.
        """
        return pulumi.get(self, "settings")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Whether the configuration is enabled.
        Valid values are `enabled` and `disabled`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class TableBucketMaintenanceConfigurationIcebergUnreferencedFileRemovalSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nonCurrentDays":
            suggest = "non_current_days"
        elif key == "unreferencedDays":
            suggest = "unreferenced_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableBucketMaintenanceConfigurationIcebergUnreferencedFileRemovalSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableBucketMaintenanceConfigurationIcebergUnreferencedFileRemovalSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableBucketMaintenanceConfigurationIcebergUnreferencedFileRemovalSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 non_current_days: _builtins.int,
                 unreferenced_days: _builtins.int):
        """
        :param _builtins.int non_current_days: Data objects marked for deletion are deleted after this many days.
               Must be at least `1`.
        :param _builtins.int unreferenced_days: Unreferenced data objects are marked for deletion after this many days.
               Must be at least `1`.
        """
        pulumi.set(__self__, "non_current_days", non_current_days)
        pulumi.set(__self__, "unreferenced_days", unreferenced_days)

    @_builtins.property
    @pulumi.getter(name="nonCurrentDays")
    def non_current_days(self) -> _builtins.int:
        """
        Data objects marked for deletion are deleted after this many days.
        Must be at least `1`.
        """
        return pulumi.get(self, "non_current_days")

    @_builtins.property
    @pulumi.getter(name="unreferencedDays")
    def unreferenced_days(self) -> _builtins.int:
        """
        Unreferenced data objects are marked for deletion after this many days.
        Must be at least `1`.
        """
        return pulumi.get(self, "unreferenced_days")


@pulumi.output_type
class TableEncryptionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyArn":
            suggest = "kms_key_arn"
        elif key == "sseAlgorithm":
            suggest = "sse_algorithm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_arn: _builtins.str,
                 sse_algorithm: _builtins.str):
        """
        :param _builtins.str kms_key_arn: The ARN of a KMS Key to be used with `aws:kms` `sse_algorithm`
        :param _builtins.str sse_algorithm: One of `aws:kms` or `AES256`
        """
        pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        pulumi.set(__self__, "sse_algorithm", sse_algorithm)

    @_builtins.property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> _builtins.str:
        """
        The ARN of a KMS Key to be used with `aws:kms` `sse_algorithm`
        """
        return pulumi.get(self, "kms_key_arn")

    @_builtins.property
    @pulumi.getter(name="sseAlgorithm")
    def sse_algorithm(self) -> _builtins.str:
        """
        One of `aws:kms` or `AES256`
        """
        return pulumi.get(self, "sse_algorithm")


@pulumi.output_type
class TableMaintenanceConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "icebergCompaction":
            suggest = "iceberg_compaction"
        elif key == "icebergSnapshotManagement":
            suggest = "iceberg_snapshot_management"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableMaintenanceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableMaintenanceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableMaintenanceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 iceberg_compaction: 'outputs.TableMaintenanceConfigurationIcebergCompaction',
                 iceberg_snapshot_management: 'outputs.TableMaintenanceConfigurationIcebergSnapshotManagement'):
        """
        :param 'TableMaintenanceConfigurationIcebergCompactionArgs' iceberg_compaction: A single Iceberg compaction settings object.
               See `iceberg_compaction` below.
        :param 'TableMaintenanceConfigurationIcebergSnapshotManagementArgs' iceberg_snapshot_management: A single Iceberg snapshot management settings object.
               See `iceberg_snapshot_management` below.
        """
        pulumi.set(__self__, "iceberg_compaction", iceberg_compaction)
        pulumi.set(__self__, "iceberg_snapshot_management", iceberg_snapshot_management)

    @_builtins.property
    @pulumi.getter(name="icebergCompaction")
    def iceberg_compaction(self) -> 'outputs.TableMaintenanceConfigurationIcebergCompaction':
        """
        A single Iceberg compaction settings object.
        See `iceberg_compaction` below.
        """
        return pulumi.get(self, "iceberg_compaction")

    @_builtins.property
    @pulumi.getter(name="icebergSnapshotManagement")
    def iceberg_snapshot_management(self) -> 'outputs.TableMaintenanceConfigurationIcebergSnapshotManagement':
        """
        A single Iceberg snapshot management settings object.
        See `iceberg_snapshot_management` below.
        """
        return pulumi.get(self, "iceberg_snapshot_management")


@pulumi.output_type
class TableMaintenanceConfigurationIcebergCompaction(dict):
    def __init__(__self__, *,
                 settings: 'outputs.TableMaintenanceConfigurationIcebergCompactionSettings',
                 status: _builtins.str):
        """
        :param 'TableMaintenanceConfigurationIcebergCompactionSettingsArgs' settings: Settings object for compaction.
               See `iceberg_compaction.settings` below.
        :param _builtins.str status: Whether the configuration is enabled.
               Valid values are `enabled` and `disabled`.
        """
        pulumi.set(__self__, "settings", settings)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def settings(self) -> 'outputs.TableMaintenanceConfigurationIcebergCompactionSettings':
        """
        Settings object for compaction.
        See `iceberg_compaction.settings` below.
        """
        return pulumi.get(self, "settings")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Whether the configuration is enabled.
        Valid values are `enabled` and `disabled`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class TableMaintenanceConfigurationIcebergCompactionSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetFileSizeMb":
            suggest = "target_file_size_mb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableMaintenanceConfigurationIcebergCompactionSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableMaintenanceConfigurationIcebergCompactionSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableMaintenanceConfigurationIcebergCompactionSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_file_size_mb: _builtins.int):
        """
        :param _builtins.int target_file_size_mb: Data objects smaller than this size may be combined with others to improve query performance.
               Must be between `64` and `512`.
        """
        pulumi.set(__self__, "target_file_size_mb", target_file_size_mb)

    @_builtins.property
    @pulumi.getter(name="targetFileSizeMb")
    def target_file_size_mb(self) -> _builtins.int:
        """
        Data objects smaller than this size may be combined with others to improve query performance.
        Must be between `64` and `512`.
        """
        return pulumi.get(self, "target_file_size_mb")


@pulumi.output_type
class TableMaintenanceConfigurationIcebergSnapshotManagement(dict):
    def __init__(__self__, *,
                 settings: 'outputs.TableMaintenanceConfigurationIcebergSnapshotManagementSettings',
                 status: _builtins.str):
        """
        :param 'TableMaintenanceConfigurationIcebergSnapshotManagementSettingsArgs' settings: Settings object for snapshot management.
               See `iceberg_snapshot_management.settings` below.
        :param _builtins.str status: Whether the configuration is enabled.
               Valid values are `enabled` and `disabled`.
        """
        pulumi.set(__self__, "settings", settings)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def settings(self) -> 'outputs.TableMaintenanceConfigurationIcebergSnapshotManagementSettings':
        """
        Settings object for snapshot management.
        See `iceberg_snapshot_management.settings` below.
        """
        return pulumi.get(self, "settings")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Whether the configuration is enabled.
        Valid values are `enabled` and `disabled`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class TableMaintenanceConfigurationIcebergSnapshotManagementSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxSnapshotAgeHours":
            suggest = "max_snapshot_age_hours"
        elif key == "minSnapshotsToKeep":
            suggest = "min_snapshots_to_keep"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableMaintenanceConfigurationIcebergSnapshotManagementSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableMaintenanceConfigurationIcebergSnapshotManagementSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableMaintenanceConfigurationIcebergSnapshotManagementSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_snapshot_age_hours: _builtins.int,
                 min_snapshots_to_keep: _builtins.int):
        """
        :param _builtins.int max_snapshot_age_hours: Snapshots older than this will be marked for deletiion.
               Must be at least `1`.
        :param _builtins.int min_snapshots_to_keep: Minimum number of snapshots to keep.
               Must be at least `1`.
        """
        pulumi.set(__self__, "max_snapshot_age_hours", max_snapshot_age_hours)
        pulumi.set(__self__, "min_snapshots_to_keep", min_snapshots_to_keep)

    @_builtins.property
    @pulumi.getter(name="maxSnapshotAgeHours")
    def max_snapshot_age_hours(self) -> _builtins.int:
        """
        Snapshots older than this will be marked for deletiion.
        Must be at least `1`.
        """
        return pulumi.get(self, "max_snapshot_age_hours")

    @_builtins.property
    @pulumi.getter(name="minSnapshotsToKeep")
    def min_snapshots_to_keep(self) -> _builtins.int:
        """
        Minimum number of snapshots to keep.
        Must be at least `1`.
        """
        return pulumi.get(self, "min_snapshots_to_keep")


@pulumi.output_type
class TableMetadata(dict):
    def __init__(__self__, *,
                 iceberg: 'outputs.TableMetadataIceberg'):
        """
        :param 'TableMetadataIcebergArgs' iceberg: Contains details about the metadata for an Iceberg table. This block defines the schema structure for the Apache Iceberg table format.
               See `iceberg` below.
        """
        pulumi.set(__self__, "iceberg", iceberg)

    @_builtins.property
    @pulumi.getter
    def iceberg(self) -> 'outputs.TableMetadataIceberg':
        """
        Contains details about the metadata for an Iceberg table. This block defines the schema structure for the Apache Iceberg table format.
        See `iceberg` below.
        """
        return pulumi.get(self, "iceberg")


@pulumi.output_type
class TableMetadataIceberg(dict):
    def __init__(__self__, *,
                 schema: 'outputs.TableMetadataIcebergSchema'):
        """
        :param 'TableMetadataIcebergSchemaArgs' schema: Schema configuration for the Iceberg table.
               See `schema` below.
        """
        pulumi.set(__self__, "schema", schema)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> 'outputs.TableMetadataIcebergSchema':
        """
        Schema configuration for the Iceberg table.
        See `schema` below.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class TableMetadataIcebergSchema(dict):
    def __init__(__self__, *,
                 fields: Optional[Sequence['outputs.TableMetadataIcebergSchemaField']] = None):
        """
        :param Sequence['TableMetadataIcebergSchemaFieldArgs'] fields: List of schema fields for the Iceberg table. Each field defines a column in the table schema.
               See `field` below.
        """
        if fields is not None:
            pulumi.set(__self__, "fields", fields)

    @_builtins.property
    @pulumi.getter
    def fields(self) -> Optional[Sequence['outputs.TableMetadataIcebergSchemaField']]:
        """
        List of schema fields for the Iceberg table. Each field defines a column in the table schema.
        See `field` below.
        """
        return pulumi.get(self, "fields")


@pulumi.output_type
class TableMetadataIcebergSchemaField(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 type: _builtins.str,
                 required: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The name of the field.
        :param _builtins.str type: The field type. S3 Tables supports all Apache Iceberg primitive types including: `boolean`, `int`, `long`, `float`, `double`, `decimal(precision,scale)`, `date`, `time`, `timestamp`, `timestamptz`, `string`, `uuid`, `fixed(length)`, `binary`.
        :param _builtins.bool required: A Boolean value that specifies whether values are required for each row in this field. Defaults to `false`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if required is not None:
            pulumi.set(__self__, "required", required)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the field.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The field type. S3 Tables supports all Apache Iceberg primitive types including: `boolean`, `int`, `long`, `float`, `double`, `decimal(precision,scale)`, `date`, `time`, `timestamp`, `timestamptz`, `string`, `uuid`, `fixed(length)`, `binary`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def required(self) -> Optional[_builtins.bool]:
        """
        A Boolean value that specifies whether values are required for each row in this field. Defaults to `false`.
        """
        return pulumi.get(self, "required")


