# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SpaceArgs', 'Space']

@pulumi.input_type
class SpaceArgs:
    def __init__(__self__, *,
                 domain_id: pulumi.Input[_builtins.str],
                 space_name: pulumi.Input[_builtins.str],
                 ownership_settings: Optional[pulumi.Input['SpaceOwnershipSettingsArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 space_display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 space_settings: Optional[pulumi.Input['SpaceSpaceSettingsArgs']] = None,
                 space_sharing_settings: Optional[pulumi.Input['SpaceSpaceSharingSettingsArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Space resource.
        :param pulumi.Input[_builtins.str] domain_id: The ID of the associated Domain.
        :param pulumi.Input[_builtins.str] space_name: The name of the space.
        :param pulumi.Input['SpaceOwnershipSettingsArgs'] ownership_settings: A collection of ownership settings. Required if `space_sharing_settings` is set. See `ownership_settings` Block below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] space_display_name: The name of the space that appears in the SageMaker AI Studio UI.
        :param pulumi.Input['SpaceSpaceSettingsArgs'] space_settings: A collection of space settings. See `space_settings` Block below.
        :param pulumi.Input['SpaceSpaceSharingSettingsArgs'] space_sharing_settings: A collection of space sharing settings. Required if `ownership_settings` is set. See `space_sharing_settings` Block below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "domain_id", domain_id)
        pulumi.set(__self__, "space_name", space_name)
        if ownership_settings is not None:
            pulumi.set(__self__, "ownership_settings", ownership_settings)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if space_display_name is not None:
            pulumi.set(__self__, "space_display_name", space_display_name)
        if space_settings is not None:
            pulumi.set(__self__, "space_settings", space_settings)
        if space_sharing_settings is not None:
            pulumi.set(__self__, "space_sharing_settings", space_sharing_settings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the associated Domain.
        """
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain_id", value)

    @_builtins.property
    @pulumi.getter(name="spaceName")
    def space_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the space.
        """
        return pulumi.get(self, "space_name")

    @space_name.setter
    def space_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "space_name", value)

    @_builtins.property
    @pulumi.getter(name="ownershipSettings")
    def ownership_settings(self) -> Optional[pulumi.Input['SpaceOwnershipSettingsArgs']]:
        """
        A collection of ownership settings. Required if `space_sharing_settings` is set. See `ownership_settings` Block below.
        """
        return pulumi.get(self, "ownership_settings")

    @ownership_settings.setter
    def ownership_settings(self, value: Optional[pulumi.Input['SpaceOwnershipSettingsArgs']]):
        pulumi.set(self, "ownership_settings", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="spaceDisplayName")
    def space_display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the space that appears in the SageMaker AI Studio UI.
        """
        return pulumi.get(self, "space_display_name")

    @space_display_name.setter
    def space_display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "space_display_name", value)

    @_builtins.property
    @pulumi.getter(name="spaceSettings")
    def space_settings(self) -> Optional[pulumi.Input['SpaceSpaceSettingsArgs']]:
        """
        A collection of space settings. See `space_settings` Block below.
        """
        return pulumi.get(self, "space_settings")

    @space_settings.setter
    def space_settings(self, value: Optional[pulumi.Input['SpaceSpaceSettingsArgs']]):
        pulumi.set(self, "space_settings", value)

    @_builtins.property
    @pulumi.getter(name="spaceSharingSettings")
    def space_sharing_settings(self) -> Optional[pulumi.Input['SpaceSpaceSharingSettingsArgs']]:
        """
        A collection of space sharing settings. Required if `ownership_settings` is set. See `space_sharing_settings` Block below.
        """
        return pulumi.get(self, "space_sharing_settings")

    @space_sharing_settings.setter
    def space_sharing_settings(self, value: Optional[pulumi.Input['SpaceSpaceSharingSettingsArgs']]):
        pulumi.set(self, "space_sharing_settings", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _SpaceState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 home_efs_file_system_uid: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_settings: Optional[pulumi.Input['SpaceOwnershipSettingsArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 space_display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 space_name: Optional[pulumi.Input[_builtins.str]] = None,
                 space_settings: Optional[pulumi.Input['SpaceSpaceSettingsArgs']] = None,
                 space_sharing_settings: Optional[pulumi.Input['SpaceSpaceSharingSettingsArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Space resources.
        :param pulumi.Input[_builtins.str] arn: The space's Amazon Resource Name (ARN).
        :param pulumi.Input[_builtins.str] domain_id: The ID of the associated Domain.
        :param pulumi.Input[_builtins.str] home_efs_file_system_uid: The ID of the space's profile in the Amazon Elastic File System volume.
        :param pulumi.Input['SpaceOwnershipSettingsArgs'] ownership_settings: A collection of ownership settings. Required if `space_sharing_settings` is set. See `ownership_settings` Block below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] space_display_name: The name of the space that appears in the SageMaker AI Studio UI.
        :param pulumi.Input[_builtins.str] space_name: The name of the space.
        :param pulumi.Input['SpaceSpaceSettingsArgs'] space_settings: A collection of space settings. See `space_settings` Block below.
        :param pulumi.Input['SpaceSpaceSharingSettingsArgs'] space_sharing_settings: A collection of space sharing settings. Required if `ownership_settings` is set. See `space_sharing_settings` Block below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] url: Returns the URL of the space. If the space is created with Amazon Web Services IAM Identity Center (Successor to Amazon Web Services Single Sign-On) authentication, users can navigate to the URL after appending the respective redirect parameter for the application type to be federated through Amazon Web Services IAM Identity Center.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if domain_id is not None:
            pulumi.set(__self__, "domain_id", domain_id)
        if home_efs_file_system_uid is not None:
            pulumi.set(__self__, "home_efs_file_system_uid", home_efs_file_system_uid)
        if ownership_settings is not None:
            pulumi.set(__self__, "ownership_settings", ownership_settings)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if space_display_name is not None:
            pulumi.set(__self__, "space_display_name", space_display_name)
        if space_name is not None:
            pulumi.set(__self__, "space_name", space_name)
        if space_settings is not None:
            pulumi.set(__self__, "space_settings", space_settings)
        if space_sharing_settings is not None:
            pulumi.set(__self__, "space_sharing_settings", space_sharing_settings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The space's Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the associated Domain.
        """
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_id", value)

    @_builtins.property
    @pulumi.getter(name="homeEfsFileSystemUid")
    def home_efs_file_system_uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the space's profile in the Amazon Elastic File System volume.
        """
        return pulumi.get(self, "home_efs_file_system_uid")

    @home_efs_file_system_uid.setter
    def home_efs_file_system_uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "home_efs_file_system_uid", value)

    @_builtins.property
    @pulumi.getter(name="ownershipSettings")
    def ownership_settings(self) -> Optional[pulumi.Input['SpaceOwnershipSettingsArgs']]:
        """
        A collection of ownership settings. Required if `space_sharing_settings` is set. See `ownership_settings` Block below.
        """
        return pulumi.get(self, "ownership_settings")

    @ownership_settings.setter
    def ownership_settings(self, value: Optional[pulumi.Input['SpaceOwnershipSettingsArgs']]):
        pulumi.set(self, "ownership_settings", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="spaceDisplayName")
    def space_display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the space that appears in the SageMaker AI Studio UI.
        """
        return pulumi.get(self, "space_display_name")

    @space_display_name.setter
    def space_display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "space_display_name", value)

    @_builtins.property
    @pulumi.getter(name="spaceName")
    def space_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the space.
        """
        return pulumi.get(self, "space_name")

    @space_name.setter
    def space_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "space_name", value)

    @_builtins.property
    @pulumi.getter(name="spaceSettings")
    def space_settings(self) -> Optional[pulumi.Input['SpaceSpaceSettingsArgs']]:
        """
        A collection of space settings. See `space_settings` Block below.
        """
        return pulumi.get(self, "space_settings")

    @space_settings.setter
    def space_settings(self, value: Optional[pulumi.Input['SpaceSpaceSettingsArgs']]):
        pulumi.set(self, "space_settings", value)

    @_builtins.property
    @pulumi.getter(name="spaceSharingSettings")
    def space_sharing_settings(self) -> Optional[pulumi.Input['SpaceSpaceSharingSettingsArgs']]:
        """
        A collection of space sharing settings. Required if `ownership_settings` is set. See `space_sharing_settings` Block below.
        """
        return pulumi.get(self, "space_sharing_settings")

    @space_sharing_settings.setter
    def space_sharing_settings(self, value: Optional[pulumi.Input['SpaceSpaceSharingSettingsArgs']]):
        pulumi.set(self, "space_sharing_settings", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Returns the URL of the space. If the space is created with Amazon Web Services IAM Identity Center (Successor to Amazon Web Services Single Sign-On) authentication, users can navigate to the URL after appending the respective redirect parameter for the application type to be federated through Amazon Web Services IAM Identity Center.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("aws:sagemaker/space:Space")
class Space(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_settings: Optional[pulumi.Input[Union['SpaceOwnershipSettingsArgs', 'SpaceOwnershipSettingsArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 space_display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 space_name: Optional[pulumi.Input[_builtins.str]] = None,
                 space_settings: Optional[pulumi.Input[Union['SpaceSpaceSettingsArgs', 'SpaceSpaceSettingsArgsDict']]] = None,
                 space_sharing_settings: Optional[pulumi.Input[Union['SpaceSpaceSharingSettingsArgs', 'SpaceSpaceSharingSettingsArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a SageMaker AI Space resource.

        ## Example Usage

        ### Basic usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.sagemaker.Space("example",
            domain_id=test["id"],
            space_name="example")
        ```

        ## Import

        Using `pulumi import`, import SageMaker AI Spaces using the `id`. For example:

        ```sh
        $ pulumi import aws:sagemaker/space:Space test_space arn:aws:sagemaker:us-west-2:123456789012:space/domain-id/space-name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain_id: The ID of the associated Domain.
        :param pulumi.Input[Union['SpaceOwnershipSettingsArgs', 'SpaceOwnershipSettingsArgsDict']] ownership_settings: A collection of ownership settings. Required if `space_sharing_settings` is set. See `ownership_settings` Block below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] space_display_name: The name of the space that appears in the SageMaker AI Studio UI.
        :param pulumi.Input[_builtins.str] space_name: The name of the space.
        :param pulumi.Input[Union['SpaceSpaceSettingsArgs', 'SpaceSpaceSettingsArgsDict']] space_settings: A collection of space settings. See `space_settings` Block below.
        :param pulumi.Input[Union['SpaceSpaceSharingSettingsArgs', 'SpaceSpaceSharingSettingsArgsDict']] space_sharing_settings: A collection of space sharing settings. Required if `ownership_settings` is set. See `space_sharing_settings` Block below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SpaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a SageMaker AI Space resource.

        ## Example Usage

        ### Basic usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.sagemaker.Space("example",
            domain_id=test["id"],
            space_name="example")
        ```

        ## Import

        Using `pulumi import`, import SageMaker AI Spaces using the `id`. For example:

        ```sh
        $ pulumi import aws:sagemaker/space:Space test_space arn:aws:sagemaker:us-west-2:123456789012:space/domain-id/space-name
        ```

        :param str resource_name: The name of the resource.
        :param SpaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_settings: Optional[pulumi.Input[Union['SpaceOwnershipSettingsArgs', 'SpaceOwnershipSettingsArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 space_display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 space_name: Optional[pulumi.Input[_builtins.str]] = None,
                 space_settings: Optional[pulumi.Input[Union['SpaceSpaceSettingsArgs', 'SpaceSpaceSettingsArgsDict']]] = None,
                 space_sharing_settings: Optional[pulumi.Input[Union['SpaceSpaceSharingSettingsArgs', 'SpaceSpaceSharingSettingsArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpaceArgs.__new__(SpaceArgs)

            if domain_id is None and not opts.urn:
                raise TypeError("Missing required property 'domain_id'")
            __props__.__dict__["domain_id"] = domain_id
            __props__.__dict__["ownership_settings"] = ownership_settings
            __props__.__dict__["region"] = region
            __props__.__dict__["space_display_name"] = space_display_name
            if space_name is None and not opts.urn:
                raise TypeError("Missing required property 'space_name'")
            __props__.__dict__["space_name"] = space_name
            __props__.__dict__["space_settings"] = space_settings
            __props__.__dict__["space_sharing_settings"] = space_sharing_settings
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["home_efs_file_system_uid"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["url"] = None
        super(Space, __self__).__init__(
            'aws:sagemaker/space:Space',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            domain_id: Optional[pulumi.Input[_builtins.str]] = None,
            home_efs_file_system_uid: Optional[pulumi.Input[_builtins.str]] = None,
            ownership_settings: Optional[pulumi.Input[Union['SpaceOwnershipSettingsArgs', 'SpaceOwnershipSettingsArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            space_display_name: Optional[pulumi.Input[_builtins.str]] = None,
            space_name: Optional[pulumi.Input[_builtins.str]] = None,
            space_settings: Optional[pulumi.Input[Union['SpaceSpaceSettingsArgs', 'SpaceSpaceSettingsArgsDict']]] = None,
            space_sharing_settings: Optional[pulumi.Input[Union['SpaceSpaceSharingSettingsArgs', 'SpaceSpaceSharingSettingsArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None) -> 'Space':
        """
        Get an existing Space resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: The space's Amazon Resource Name (ARN).
        :param pulumi.Input[_builtins.str] domain_id: The ID of the associated Domain.
        :param pulumi.Input[_builtins.str] home_efs_file_system_uid: The ID of the space's profile in the Amazon Elastic File System volume.
        :param pulumi.Input[Union['SpaceOwnershipSettingsArgs', 'SpaceOwnershipSettingsArgsDict']] ownership_settings: A collection of ownership settings. Required if `space_sharing_settings` is set. See `ownership_settings` Block below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] space_display_name: The name of the space that appears in the SageMaker AI Studio UI.
        :param pulumi.Input[_builtins.str] space_name: The name of the space.
        :param pulumi.Input[Union['SpaceSpaceSettingsArgs', 'SpaceSpaceSettingsArgsDict']] space_settings: A collection of space settings. See `space_settings` Block below.
        :param pulumi.Input[Union['SpaceSpaceSharingSettingsArgs', 'SpaceSpaceSharingSettingsArgsDict']] space_sharing_settings: A collection of space sharing settings. Required if `ownership_settings` is set. See `space_sharing_settings` Block below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] url: Returns the URL of the space. If the space is created with Amazon Web Services IAM Identity Center (Successor to Amazon Web Services Single Sign-On) authentication, users can navigate to the URL after appending the respective redirect parameter for the application type to be federated through Amazon Web Services IAM Identity Center.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SpaceState.__new__(_SpaceState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["domain_id"] = domain_id
        __props__.__dict__["home_efs_file_system_uid"] = home_efs_file_system_uid
        __props__.__dict__["ownership_settings"] = ownership_settings
        __props__.__dict__["region"] = region
        __props__.__dict__["space_display_name"] = space_display_name
        __props__.__dict__["space_name"] = space_name
        __props__.__dict__["space_settings"] = space_settings
        __props__.__dict__["space_sharing_settings"] = space_sharing_settings
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["url"] = url
        return Space(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The space's Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the associated Domain.
        """
        return pulumi.get(self, "domain_id")

    @_builtins.property
    @pulumi.getter(name="homeEfsFileSystemUid")
    def home_efs_file_system_uid(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the space's profile in the Amazon Elastic File System volume.
        """
        return pulumi.get(self, "home_efs_file_system_uid")

    @_builtins.property
    @pulumi.getter(name="ownershipSettings")
    def ownership_settings(self) -> pulumi.Output[Optional['outputs.SpaceOwnershipSettings']]:
        """
        A collection of ownership settings. Required if `space_sharing_settings` is set. See `ownership_settings` Block below.
        """
        return pulumi.get(self, "ownership_settings")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="spaceDisplayName")
    def space_display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the space that appears in the SageMaker AI Studio UI.
        """
        return pulumi.get(self, "space_display_name")

    @_builtins.property
    @pulumi.getter(name="spaceName")
    def space_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the space.
        """
        return pulumi.get(self, "space_name")

    @_builtins.property
    @pulumi.getter(name="spaceSettings")
    def space_settings(self) -> pulumi.Output[Optional['outputs.SpaceSpaceSettings']]:
        """
        A collection of space settings. See `space_settings` Block below.
        """
        return pulumi.get(self, "space_settings")

    @_builtins.property
    @pulumi.getter(name="spaceSharingSettings")
    def space_sharing_settings(self) -> pulumi.Output[Optional['outputs.SpaceSpaceSharingSettings']]:
        """
        A collection of space sharing settings. Required if `ownership_settings` is set. See `space_sharing_settings` Block below.
        """
        return pulumi.get(self, "space_sharing_settings")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        Returns the URL of the space. If the space is created with Amazon Web Services IAM Identity Center (Successor to Amazon Web Services Single Sign-On) authentication, users can navigate to the URL after appending the respective redirect parameter for the application type to be federated through Amazon Web Services IAM Identity Center.
        """
        return pulumi.get(self, "url")

