# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSecretVersionsResult',
    'AwaitableGetSecretVersionsResult',
    'get_secret_versions',
    'get_secret_versions_output',
]

@pulumi.output_type
class GetSecretVersionsResult:
    """
    A collection of values returned by getSecretVersions.
    """
    def __init__(__self__, arn=None, id=None, include_deprecated=None, name=None, region=None, secret_id=None, versions=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if include_deprecated and not isinstance(include_deprecated, bool):
            raise TypeError("Expected argument 'include_deprecated' to be a bool")
        pulumi.set(__self__, "include_deprecated", include_deprecated)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if secret_id and not isinstance(secret_id, str):
            raise TypeError("Expected argument 'secret_id' to be a str")
        pulumi.set(__self__, "secret_id", secret_id)
        if versions and not isinstance(versions, list):
            raise TypeError("Expected argument 'versions' to be a list")
        pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN of the secret.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="includeDeprecated")
    def include_deprecated(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "include_deprecated")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> _builtins.str:
        return pulumi.get(self, "secret_id")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Sequence['outputs.GetSecretVersionsVersionResult']:
        """
        List of the versions of the secret. Attributes are specified below.
        """
        return pulumi.get(self, "versions")


class AwaitableGetSecretVersionsResult(GetSecretVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecretVersionsResult(
            arn=self.arn,
            id=self.id,
            include_deprecated=self.include_deprecated,
            name=self.name,
            region=self.region,
            secret_id=self.secret_id,
            versions=self.versions)


def get_secret_versions(include_deprecated: Optional[_builtins.bool] = None,
                        region: Optional[_builtins.str] = None,
                        secret_id: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecretVersionsResult:
    """
    Use this data source to access information about an existing resource.

    :param _builtins.bool include_deprecated: If true, all deprecated secret versions are included in the response.
           If false, no deprecated secret versions are included in the response. If no value is specified, the default value is `false`.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str secret_id: Specifies the secret containing the version that you want to retrieve. You can specify either the ARN or the friendly name of the secret.
    """
    __args__ = dict()
    __args__['includeDeprecated'] = include_deprecated
    __args__['region'] = region
    __args__['secretId'] = secret_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:secretsmanager/getSecretVersions:getSecretVersions', __args__, opts=opts, typ=GetSecretVersionsResult).value

    return AwaitableGetSecretVersionsResult(
        arn=pulumi.get(__ret__, 'arn'),
        id=pulumi.get(__ret__, 'id'),
        include_deprecated=pulumi.get(__ret__, 'include_deprecated'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        secret_id=pulumi.get(__ret__, 'secret_id'),
        versions=pulumi.get(__ret__, 'versions'))
def get_secret_versions_output(include_deprecated: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                               region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecretVersionsResult]:
    """
    Use this data source to access information about an existing resource.

    :param _builtins.bool include_deprecated: If true, all deprecated secret versions are included in the response.
           If false, no deprecated secret versions are included in the response. If no value is specified, the default value is `false`.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str secret_id: Specifies the secret containing the version that you want to retrieve. You can specify either the ARN or the friendly name of the secret.
    """
    __args__ = dict()
    __args__['includeDeprecated'] = include_deprecated
    __args__['region'] = region
    __args__['secretId'] = secret_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:secretsmanager/getSecretVersions:getSecretVersions', __args__, opts=opts, typ=GetSecretVersionsResult)
    return __ret__.apply(lambda __response__: GetSecretVersionsResult(
        arn=pulumi.get(__response__, 'arn'),
        id=pulumi.get(__response__, 'id'),
        include_deprecated=pulumi.get(__response__, 'include_deprecated'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        secret_id=pulumi.get(__response__, 'secret_id'),
        versions=pulumi.get(__response__, 'versions')))
