# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SubscriberArgs', 'Subscriber']

@pulumi.input_type
class SubscriberArgs:
    def __init__(__self__, *,
                 access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriberSourceArgs']]]] = None,
                 subscriber_description: Optional[pulumi.Input[_builtins.str]] = None,
                 subscriber_identity: Optional[pulumi.Input['SubscriberSubscriberIdentityArgs']] = None,
                 subscriber_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['SubscriberTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a Subscriber resource.
        :param pulumi.Input[_builtins.str] access_type: The Amazon S3 or Lake Formation access type.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input['SubscriberSourceArgs']]] sources: The supported AWS services from which logs and events are collected. Security Lake supports log and event collection for natively supported AWS services. See `source` Blocks below.
        :param pulumi.Input[_builtins.str] subscriber_description: The description for your subscriber account in Security Lake.
        :param pulumi.Input['SubscriberSubscriberIdentityArgs'] subscriber_identity: The AWS identity used to access your data. See `subscriber_identity` Block below.
        :param pulumi.Input[_builtins.str] subscriber_name: The name of your Security Lake subscriber account.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        if access_type is not None:
            pulumi.set(__self__, "access_type", access_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if subscriber_description is not None:
            pulumi.set(__self__, "subscriber_description", subscriber_description)
        if subscriber_identity is not None:
            pulumi.set(__self__, "subscriber_identity", subscriber_identity)
        if subscriber_name is not None:
            pulumi.set(__self__, "subscriber_name", subscriber_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon S3 or Lake Formation access type.
        """
        return pulumi.get(self, "access_type")

    @access_type.setter
    def access_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_type", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubscriberSourceArgs']]]]:
        """
        The supported AWS services from which logs and events are collected. Security Lake supports log and event collection for natively supported AWS services. See `source` Blocks below.
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriberSourceArgs']]]]):
        pulumi.set(self, "sources", value)

    @_builtins.property
    @pulumi.getter(name="subscriberDescription")
    def subscriber_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for your subscriber account in Security Lake.
        """
        return pulumi.get(self, "subscriber_description")

    @subscriber_description.setter
    def subscriber_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscriber_description", value)

    @_builtins.property
    @pulumi.getter(name="subscriberIdentity")
    def subscriber_identity(self) -> Optional[pulumi.Input['SubscriberSubscriberIdentityArgs']]:
        """
        The AWS identity used to access your data. See `subscriber_identity` Block below.
        """
        return pulumi.get(self, "subscriber_identity")

    @subscriber_identity.setter
    def subscriber_identity(self, value: Optional[pulumi.Input['SubscriberSubscriberIdentityArgs']]):
        pulumi.set(self, "subscriber_identity", value)

    @_builtins.property
    @pulumi.getter(name="subscriberName")
    def subscriber_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of your Security Lake subscriber account.
        """
        return pulumi.get(self, "subscriber_name")

    @subscriber_name.setter
    def subscriber_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscriber_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['SubscriberTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['SubscriberTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _SubscriberState:
    def __init__(__self__, *,
                 access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_share_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_share_name: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_bucket_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriberSourceArgs']]]] = None,
                 subscriber_description: Optional[pulumi.Input[_builtins.str]] = None,
                 subscriber_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 subscriber_identity: Optional[pulumi.Input['SubscriberSubscriberIdentityArgs']] = None,
                 subscriber_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subscriber_status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['SubscriberTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering Subscriber resources.
        :param pulumi.Input[_builtins.str] access_type: The Amazon S3 or Lake Formation access type.
        :param pulumi.Input[_builtins.str] arn: ARN of the Data Lake.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] resource_share_arn: The Amazon Resource Name (ARN) which uniquely defines the AWS RAM resource share. Before accepting the RAM resource share invitation, you can view details related to the RAM resource share.
        :param pulumi.Input[_builtins.str] resource_share_name: The name of the resource share.
        :param pulumi.Input[_builtins.str] role_arn: The ARN of the IAM role to be used by the entity putting logs into your custom source partition.
        :param pulumi.Input[_builtins.str] s3_bucket_arn: The ARN for the Amazon Security Lake Amazon S3 bucket.
        :param pulumi.Input[Sequence[pulumi.Input['SubscriberSourceArgs']]] sources: The supported AWS services from which logs and events are collected. Security Lake supports log and event collection for natively supported AWS services. See `source` Blocks below.
        :param pulumi.Input[_builtins.str] subscriber_description: The description for your subscriber account in Security Lake.
        :param pulumi.Input[_builtins.str] subscriber_endpoint: The subscriber endpoint to which exception messages are posted.
        :param pulumi.Input['SubscriberSubscriberIdentityArgs'] subscriber_identity: The AWS identity used to access your data. See `subscriber_identity` Block below.
        :param pulumi.Input[_builtins.str] subscriber_name: The name of your Security Lake subscriber account.
        :param pulumi.Input[_builtins.str] subscriber_status: The subscriber status of the Amazon Security Lake subscriber account.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if access_type is not None:
            pulumi.set(__self__, "access_type", access_type)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_share_arn is not None:
            pulumi.set(__self__, "resource_share_arn", resource_share_arn)
        if resource_share_name is not None:
            pulumi.set(__self__, "resource_share_name", resource_share_name)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if s3_bucket_arn is not None:
            pulumi.set(__self__, "s3_bucket_arn", s3_bucket_arn)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if subscriber_description is not None:
            pulumi.set(__self__, "subscriber_description", subscriber_description)
        if subscriber_endpoint is not None:
            pulumi.set(__self__, "subscriber_endpoint", subscriber_endpoint)
        if subscriber_identity is not None:
            pulumi.set(__self__, "subscriber_identity", subscriber_identity)
        if subscriber_name is not None:
            pulumi.set(__self__, "subscriber_name", subscriber_name)
        if subscriber_status is not None:
            pulumi.set(__self__, "subscriber_status", subscriber_status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon S3 or Lake Formation access type.
        """
        return pulumi.get(self, "access_type")

    @access_type.setter
    def access_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_type", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the Data Lake.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourceShareArn")
    def resource_share_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) which uniquely defines the AWS RAM resource share. Before accepting the RAM resource share invitation, you can view details related to the RAM resource share.
        """
        return pulumi.get(self, "resource_share_arn")

    @resource_share_arn.setter
    def resource_share_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_share_arn", value)

    @_builtins.property
    @pulumi.getter(name="resourceShareName")
    def resource_share_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource share.
        """
        return pulumi.get(self, "resource_share_name")

    @resource_share_name.setter
    def resource_share_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_share_name", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the IAM role to be used by the entity putting logs into your custom source partition.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter(name="s3BucketArn")
    def s3_bucket_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN for the Amazon Security Lake Amazon S3 bucket.
        """
        return pulumi.get(self, "s3_bucket_arn")

    @s3_bucket_arn.setter
    def s3_bucket_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "s3_bucket_arn", value)

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubscriberSourceArgs']]]]:
        """
        The supported AWS services from which logs and events are collected. Security Lake supports log and event collection for natively supported AWS services. See `source` Blocks below.
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriberSourceArgs']]]]):
        pulumi.set(self, "sources", value)

    @_builtins.property
    @pulumi.getter(name="subscriberDescription")
    def subscriber_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for your subscriber account in Security Lake.
        """
        return pulumi.get(self, "subscriber_description")

    @subscriber_description.setter
    def subscriber_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscriber_description", value)

    @_builtins.property
    @pulumi.getter(name="subscriberEndpoint")
    def subscriber_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subscriber endpoint to which exception messages are posted.
        """
        return pulumi.get(self, "subscriber_endpoint")

    @subscriber_endpoint.setter
    def subscriber_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscriber_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="subscriberIdentity")
    def subscriber_identity(self) -> Optional[pulumi.Input['SubscriberSubscriberIdentityArgs']]:
        """
        The AWS identity used to access your data. See `subscriber_identity` Block below.
        """
        return pulumi.get(self, "subscriber_identity")

    @subscriber_identity.setter
    def subscriber_identity(self, value: Optional[pulumi.Input['SubscriberSubscriberIdentityArgs']]):
        pulumi.set(self, "subscriber_identity", value)

    @_builtins.property
    @pulumi.getter(name="subscriberName")
    def subscriber_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of your Security Lake subscriber account.
        """
        return pulumi.get(self, "subscriber_name")

    @subscriber_name.setter
    def subscriber_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscriber_name", value)

    @_builtins.property
    @pulumi.getter(name="subscriberStatus")
    def subscriber_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subscriber status of the Amazon Security Lake subscriber account.
        """
        return pulumi.get(self, "subscriber_status")

    @subscriber_status.setter
    def subscriber_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscriber_status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['SubscriberTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['SubscriberTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:securitylake/subscriber:Subscriber")
class Subscriber(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SubscriberSourceArgs', 'SubscriberSourceArgsDict']]]]] = None,
                 subscriber_description: Optional[pulumi.Input[_builtins.str]] = None,
                 subscriber_identity: Optional[pulumi.Input[Union['SubscriberSubscriberIdentityArgs', 'SubscriberSubscriberIdentityArgsDict']]] = None,
                 subscriber_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['SubscriberTimeoutsArgs', 'SubscriberTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Security Lake Subscriber.

        > **NOTE:** The underlying `securitylake.DataLake` must be configured before creating the `securitylake.Subscriber`. Use a `depends_on` statement.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.securitylake.Subscriber("example",
            subscriber_name="example-name",
            access_type="S3",
            sources=[{
                "aws_log_source_resource": {
                    "source_name": "ROUTE53",
                    "source_version": "1.0",
                },
            }],
            subscriber_identity={
                "external_id": "example",
                "principal": "1234567890",
            },
            opts = pulumi.ResourceOptions(depends_on=[example_aws_securitylake_data_lake]))
        ```

        ### Multiple Log Sources

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.securitylake.Subscriber("example",
            subscriber_name="example-name",
            access_type="S3",
            sources=[
                {
                    "aws_log_source_resource": {
                        "source_name": "SH_FINDINGS",
                        "source_version": "2.0",
                    },
                },
                {
                    "aws_log_source_resource": {
                        "source_name": "ROUTE53",
                        "source_version": "2.0",
                    },
                },
            ],
            subscriber_identity={
                "external_id": "example",
                "principal": "1234567890",
            },
            opts = pulumi.ResourceOptions(depends_on=[example_aws_securitylake_data_lake]))
        ```

        ## Import

        Using `pulumi import`, import Security Lake subscriber using the subscriber ID. For example:

        ```sh
        $ pulumi import aws:securitylake/subscriber:Subscriber example 9f3bfe79-d543-474d-a93c-f3846805d208
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_type: The Amazon S3 or Lake Formation access type.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SubscriberSourceArgs', 'SubscriberSourceArgsDict']]]] sources: The supported AWS services from which logs and events are collected. Security Lake supports log and event collection for natively supported AWS services. See `source` Blocks below.
        :param pulumi.Input[_builtins.str] subscriber_description: The description for your subscriber account in Security Lake.
        :param pulumi.Input[Union['SubscriberSubscriberIdentityArgs', 'SubscriberSubscriberIdentityArgsDict']] subscriber_identity: The AWS identity used to access your data. See `subscriber_identity` Block below.
        :param pulumi.Input[_builtins.str] subscriber_name: The name of your Security Lake subscriber account.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SubscriberArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Security Lake Subscriber.

        > **NOTE:** The underlying `securitylake.DataLake` must be configured before creating the `securitylake.Subscriber`. Use a `depends_on` statement.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.securitylake.Subscriber("example",
            subscriber_name="example-name",
            access_type="S3",
            sources=[{
                "aws_log_source_resource": {
                    "source_name": "ROUTE53",
                    "source_version": "1.0",
                },
            }],
            subscriber_identity={
                "external_id": "example",
                "principal": "1234567890",
            },
            opts = pulumi.ResourceOptions(depends_on=[example_aws_securitylake_data_lake]))
        ```

        ### Multiple Log Sources

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.securitylake.Subscriber("example",
            subscriber_name="example-name",
            access_type="S3",
            sources=[
                {
                    "aws_log_source_resource": {
                        "source_name": "SH_FINDINGS",
                        "source_version": "2.0",
                    },
                },
                {
                    "aws_log_source_resource": {
                        "source_name": "ROUTE53",
                        "source_version": "2.0",
                    },
                },
            ],
            subscriber_identity={
                "external_id": "example",
                "principal": "1234567890",
            },
            opts = pulumi.ResourceOptions(depends_on=[example_aws_securitylake_data_lake]))
        ```

        ## Import

        Using `pulumi import`, import Security Lake subscriber using the subscriber ID. For example:

        ```sh
        $ pulumi import aws:securitylake/subscriber:Subscriber example 9f3bfe79-d543-474d-a93c-f3846805d208
        ```

        :param str resource_name: The name of the resource.
        :param SubscriberArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SubscriberArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SubscriberSourceArgs', 'SubscriberSourceArgsDict']]]]] = None,
                 subscriber_description: Optional[pulumi.Input[_builtins.str]] = None,
                 subscriber_identity: Optional[pulumi.Input[Union['SubscriberSubscriberIdentityArgs', 'SubscriberSubscriberIdentityArgsDict']]] = None,
                 subscriber_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['SubscriberTimeoutsArgs', 'SubscriberTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SubscriberArgs.__new__(SubscriberArgs)

            __props__.__dict__["access_type"] = access_type
            __props__.__dict__["region"] = region
            __props__.__dict__["sources"] = sources
            __props__.__dict__["subscriber_description"] = subscriber_description
            __props__.__dict__["subscriber_identity"] = subscriber_identity
            __props__.__dict__["subscriber_name"] = subscriber_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["arn"] = None
            __props__.__dict__["resource_share_arn"] = None
            __props__.__dict__["resource_share_name"] = None
            __props__.__dict__["role_arn"] = None
            __props__.__dict__["s3_bucket_arn"] = None
            __props__.__dict__["subscriber_endpoint"] = None
            __props__.__dict__["subscriber_status"] = None
            __props__.__dict__["tags_all"] = None
        super(Subscriber, __self__).__init__(
            'aws:securitylake/subscriber:Subscriber',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_type: Optional[pulumi.Input[_builtins.str]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            resource_share_arn: Optional[pulumi.Input[_builtins.str]] = None,
            resource_share_name: Optional[pulumi.Input[_builtins.str]] = None,
            role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            s3_bucket_arn: Optional[pulumi.Input[_builtins.str]] = None,
            sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SubscriberSourceArgs', 'SubscriberSourceArgsDict']]]]] = None,
            subscriber_description: Optional[pulumi.Input[_builtins.str]] = None,
            subscriber_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            subscriber_identity: Optional[pulumi.Input[Union['SubscriberSubscriberIdentityArgs', 'SubscriberSubscriberIdentityArgsDict']]] = None,
            subscriber_name: Optional[pulumi.Input[_builtins.str]] = None,
            subscriber_status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['SubscriberTimeoutsArgs', 'SubscriberTimeoutsArgsDict']]] = None) -> 'Subscriber':
        """
        Get an existing Subscriber resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_type: The Amazon S3 or Lake Formation access type.
        :param pulumi.Input[_builtins.str] arn: ARN of the Data Lake.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] resource_share_arn: The Amazon Resource Name (ARN) which uniquely defines the AWS RAM resource share. Before accepting the RAM resource share invitation, you can view details related to the RAM resource share.
        :param pulumi.Input[_builtins.str] resource_share_name: The name of the resource share.
        :param pulumi.Input[_builtins.str] role_arn: The ARN of the IAM role to be used by the entity putting logs into your custom source partition.
        :param pulumi.Input[_builtins.str] s3_bucket_arn: The ARN for the Amazon Security Lake Amazon S3 bucket.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SubscriberSourceArgs', 'SubscriberSourceArgsDict']]]] sources: The supported AWS services from which logs and events are collected. Security Lake supports log and event collection for natively supported AWS services. See `source` Blocks below.
        :param pulumi.Input[_builtins.str] subscriber_description: The description for your subscriber account in Security Lake.
        :param pulumi.Input[_builtins.str] subscriber_endpoint: The subscriber endpoint to which exception messages are posted.
        :param pulumi.Input[Union['SubscriberSubscriberIdentityArgs', 'SubscriberSubscriberIdentityArgsDict']] subscriber_identity: The AWS identity used to access your data. See `subscriber_identity` Block below.
        :param pulumi.Input[_builtins.str] subscriber_name: The name of your Security Lake subscriber account.
        :param pulumi.Input[_builtins.str] subscriber_status: The subscriber status of the Amazon Security Lake subscriber account.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SubscriberState.__new__(_SubscriberState)

        __props__.__dict__["access_type"] = access_type
        __props__.__dict__["arn"] = arn
        __props__.__dict__["region"] = region
        __props__.__dict__["resource_share_arn"] = resource_share_arn
        __props__.__dict__["resource_share_name"] = resource_share_name
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["s3_bucket_arn"] = s3_bucket_arn
        __props__.__dict__["sources"] = sources
        __props__.__dict__["subscriber_description"] = subscriber_description
        __props__.__dict__["subscriber_endpoint"] = subscriber_endpoint
        __props__.__dict__["subscriber_identity"] = subscriber_identity
        __props__.__dict__["subscriber_name"] = subscriber_name
        __props__.__dict__["subscriber_status"] = subscriber_status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        return Subscriber(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon S3 or Lake Formation access type.
        """
        return pulumi.get(self, "access_type")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the Data Lake.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourceShareArn")
    def resource_share_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon Resource Name (ARN) which uniquely defines the AWS RAM resource share. Before accepting the RAM resource share invitation, you can view details related to the RAM resource share.
        """
        return pulumi.get(self, "resource_share_arn")

    @_builtins.property
    @pulumi.getter(name="resourceShareName")
    def resource_share_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource share.
        """
        return pulumi.get(self, "resource_share_name")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the IAM role to be used by the entity putting logs into your custom source partition.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter(name="s3BucketArn")
    def s3_bucket_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN for the Amazon Security Lake Amazon S3 bucket.
        """
        return pulumi.get(self, "s3_bucket_arn")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> pulumi.Output[Optional[Sequence['outputs.SubscriberSource']]]:
        """
        The supported AWS services from which logs and events are collected. Security Lake supports log and event collection for natively supported AWS services. See `source` Blocks below.
        """
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter(name="subscriberDescription")
    def subscriber_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description for your subscriber account in Security Lake.
        """
        return pulumi.get(self, "subscriber_description")

    @_builtins.property
    @pulumi.getter(name="subscriberEndpoint")
    def subscriber_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The subscriber endpoint to which exception messages are posted.
        """
        return pulumi.get(self, "subscriber_endpoint")

    @_builtins.property
    @pulumi.getter(name="subscriberIdentity")
    def subscriber_identity(self) -> pulumi.Output[Optional['outputs.SubscriberSubscriberIdentity']]:
        """
        The AWS identity used to access your data. See `subscriber_identity` Block below.
        """
        return pulumi.get(self, "subscriber_identity")

    @_builtins.property
    @pulumi.getter(name="subscriberName")
    def subscriber_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of your Security Lake subscriber account.
        """
        return pulumi.get(self, "subscriber_name")

    @_builtins.property
    @pulumi.getter(name="subscriberStatus")
    def subscriber_status(self) -> pulumi.Output[_builtins.str]:
        """
        The subscriber status of the Amazon Security Lake subscriber account.
        """
        return pulumi.get(self, "subscriber_status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.SubscriberTimeouts']]:
        return pulumi.get(self, "timeouts")

