# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PortfolioShareArgs', 'PortfolioShare']

@pulumi.input_type
class PortfolioShareArgs:
    def __init__(__self__, *,
                 portfolio_id: pulumi.Input[_builtins.str],
                 principal_id: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 accept_language: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 share_principals: Optional[pulumi.Input[_builtins.bool]] = None,
                 share_tag_options: Optional[pulumi.Input[_builtins.bool]] = None,
                 wait_for_acceptance: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a PortfolioShare resource.
        :param pulumi.Input[_builtins.str] portfolio_id: Portfolio identifier.
        :param pulumi.Input[_builtins.str] principal_id: Identifier of the principal with whom you will share the portfolio. Valid values AWS account IDs and ARNs of AWS Organizations and organizational units.
        :param pulumi.Input[_builtins.str] type: Type of portfolio share. Valid values are `ACCOUNT` (an external account), `ORGANIZATION` (a share to every account in an organization), `ORGANIZATIONAL_UNIT`, `ORGANIZATION_MEMBER_ACCOUNT` (a share to an account in an organization).
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] accept_language: Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] share_principals: Enables or disables Principal sharing when creating the portfolio share. If this flag is not provided, principal sharing is disabled.
        :param pulumi.Input[_builtins.bool] share_tag_options: Whether to enable sharing of `servicecatalog.TagOption` resources when creating the portfolio share.
        :param pulumi.Input[_builtins.bool] wait_for_acceptance: Whether to wait (up to the timeout) for the share to be accepted. Organizational shares are automatically accepted.
        """
        pulumi.set(__self__, "portfolio_id", portfolio_id)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "type", type)
        if accept_language is not None:
            pulumi.set(__self__, "accept_language", accept_language)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if share_principals is not None:
            pulumi.set(__self__, "share_principals", share_principals)
        if share_tag_options is not None:
            pulumi.set(__self__, "share_tag_options", share_tag_options)
        if wait_for_acceptance is not None:
            pulumi.set(__self__, "wait_for_acceptance", wait_for_acceptance)

    @_builtins.property
    @pulumi.getter(name="portfolioId")
    def portfolio_id(self) -> pulumi.Input[_builtins.str]:
        """
        Portfolio identifier.
        """
        return pulumi.get(self, "portfolio_id")

    @portfolio_id.setter
    def portfolio_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "portfolio_id", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier of the principal with whom you will share the portfolio. Valid values AWS account IDs and ARNs of AWS Organizations and organizational units.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of portfolio share. Valid values are `ACCOUNT` (an external account), `ORGANIZATION` (a share to every account in an organization), `ORGANIZATIONAL_UNIT`, `ORGANIZATION_MEMBER_ACCOUNT` (a share to an account in an organization).

        The following arguments are optional:
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="acceptLanguage")
    def accept_language(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
        """
        return pulumi.get(self, "accept_language")

    @accept_language.setter
    def accept_language(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accept_language", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sharePrincipals")
    def share_principals(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables or disables Principal sharing when creating the portfolio share. If this flag is not provided, principal sharing is disabled.
        """
        return pulumi.get(self, "share_principals")

    @share_principals.setter
    def share_principals(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "share_principals", value)

    @_builtins.property
    @pulumi.getter(name="shareTagOptions")
    def share_tag_options(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable sharing of `servicecatalog.TagOption` resources when creating the portfolio share.
        """
        return pulumi.get(self, "share_tag_options")

    @share_tag_options.setter
    def share_tag_options(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "share_tag_options", value)

    @_builtins.property
    @pulumi.getter(name="waitForAcceptance")
    def wait_for_acceptance(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to wait (up to the timeout) for the share to be accepted. Organizational shares are automatically accepted.
        """
        return pulumi.get(self, "wait_for_acceptance")

    @wait_for_acceptance.setter
    def wait_for_acceptance(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wait_for_acceptance", value)


@pulumi.input_type
class _PortfolioShareState:
    def __init__(__self__, *,
                 accept_language: Optional[pulumi.Input[_builtins.str]] = None,
                 accepted: Optional[pulumi.Input[_builtins.bool]] = None,
                 portfolio_id: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 share_principals: Optional[pulumi.Input[_builtins.bool]] = None,
                 share_tag_options: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 wait_for_acceptance: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering PortfolioShare resources.
        :param pulumi.Input[_builtins.str] accept_language: Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
        :param pulumi.Input[_builtins.bool] accepted: Whether the shared portfolio is imported by the recipient account. If the recipient is organizational, the share is automatically imported, and the field is always set to true.
        :param pulumi.Input[_builtins.str] portfolio_id: Portfolio identifier.
        :param pulumi.Input[_builtins.str] principal_id: Identifier of the principal with whom you will share the portfolio. Valid values AWS account IDs and ARNs of AWS Organizations and organizational units.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] share_principals: Enables or disables Principal sharing when creating the portfolio share. If this flag is not provided, principal sharing is disabled.
        :param pulumi.Input[_builtins.bool] share_tag_options: Whether to enable sharing of `servicecatalog.TagOption` resources when creating the portfolio share.
        :param pulumi.Input[_builtins.str] type: Type of portfolio share. Valid values are `ACCOUNT` (an external account), `ORGANIZATION` (a share to every account in an organization), `ORGANIZATIONAL_UNIT`, `ORGANIZATION_MEMBER_ACCOUNT` (a share to an account in an organization).
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.bool] wait_for_acceptance: Whether to wait (up to the timeout) for the share to be accepted. Organizational shares are automatically accepted.
        """
        if accept_language is not None:
            pulumi.set(__self__, "accept_language", accept_language)
        if accepted is not None:
            pulumi.set(__self__, "accepted", accepted)
        if portfolio_id is not None:
            pulumi.set(__self__, "portfolio_id", portfolio_id)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if share_principals is not None:
            pulumi.set(__self__, "share_principals", share_principals)
        if share_tag_options is not None:
            pulumi.set(__self__, "share_tag_options", share_tag_options)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if wait_for_acceptance is not None:
            pulumi.set(__self__, "wait_for_acceptance", wait_for_acceptance)

    @_builtins.property
    @pulumi.getter(name="acceptLanguage")
    def accept_language(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
        """
        return pulumi.get(self, "accept_language")

    @accept_language.setter
    def accept_language(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accept_language", value)

    @_builtins.property
    @pulumi.getter
    def accepted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the shared portfolio is imported by the recipient account. If the recipient is organizational, the share is automatically imported, and the field is always set to true.
        """
        return pulumi.get(self, "accepted")

    @accepted.setter
    def accepted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "accepted", value)

    @_builtins.property
    @pulumi.getter(name="portfolioId")
    def portfolio_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Portfolio identifier.
        """
        return pulumi.get(self, "portfolio_id")

    @portfolio_id.setter
    def portfolio_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "portfolio_id", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the principal with whom you will share the portfolio. Valid values AWS account IDs and ARNs of AWS Organizations and organizational units.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sharePrincipals")
    def share_principals(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables or disables Principal sharing when creating the portfolio share. If this flag is not provided, principal sharing is disabled.
        """
        return pulumi.get(self, "share_principals")

    @share_principals.setter
    def share_principals(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "share_principals", value)

    @_builtins.property
    @pulumi.getter(name="shareTagOptions")
    def share_tag_options(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable sharing of `servicecatalog.TagOption` resources when creating the portfolio share.
        """
        return pulumi.get(self, "share_tag_options")

    @share_tag_options.setter
    def share_tag_options(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "share_tag_options", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of portfolio share. Valid values are `ACCOUNT` (an external account), `ORGANIZATION` (a share to every account in an organization), `ORGANIZATIONAL_UNIT`, `ORGANIZATION_MEMBER_ACCOUNT` (a share to an account in an organization).

        The following arguments are optional:
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="waitForAcceptance")
    def wait_for_acceptance(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to wait (up to the timeout) for the share to be accepted. Organizational shares are automatically accepted.
        """
        return pulumi.get(self, "wait_for_acceptance")

    @wait_for_acceptance.setter
    def wait_for_acceptance(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wait_for_acceptance", value)


@pulumi.type_token("aws:servicecatalog/portfolioShare:PortfolioShare")
class PortfolioShare(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accept_language: Optional[pulumi.Input[_builtins.str]] = None,
                 portfolio_id: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 share_principals: Optional[pulumi.Input[_builtins.bool]] = None,
                 share_tag_options: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 wait_for_acceptance: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages a Service Catalog Portfolio Share. Shares the specified portfolio with the specified account or organization node. You can share portfolios to an organization, an organizational unit, or a specific account.

        If the portfolio share with the specified account or organization node already exists, using this resource to re-create the share will have no effect and will not return an error. You can then use this resource to update the share.

        > **NOTE:** Shares to an organization node can only be created by the management account of an organization or by a delegated administrator. If a delegated admin is de-registered, they can no longer create portfolio shares.

        > **NOTE:** AWSOrganizationsAccess must be enabled in order to create a portfolio share to an organization node.

        > **NOTE:** You can't share a shared resource, including portfolios that contain a shared product.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.servicecatalog.PortfolioShare("example",
            principal_id="012128675309",
            portfolio_id=example_aws_servicecatalog_portfolio["id"],
            type="ACCOUNT")
        ```

        ## Import

        Using `pulumi import`, import `aws_servicecatalog_portfolio_share` using the portfolio share ID. For example:

        ```sh
        $ pulumi import aws:servicecatalog/portfolioShare:PortfolioShare example port-12344321:ACCOUNT:123456789012
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accept_language: Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
        :param pulumi.Input[_builtins.str] portfolio_id: Portfolio identifier.
        :param pulumi.Input[_builtins.str] principal_id: Identifier of the principal with whom you will share the portfolio. Valid values AWS account IDs and ARNs of AWS Organizations and organizational units.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] share_principals: Enables or disables Principal sharing when creating the portfolio share. If this flag is not provided, principal sharing is disabled.
        :param pulumi.Input[_builtins.bool] share_tag_options: Whether to enable sharing of `servicecatalog.TagOption` resources when creating the portfolio share.
        :param pulumi.Input[_builtins.str] type: Type of portfolio share. Valid values are `ACCOUNT` (an external account), `ORGANIZATION` (a share to every account in an organization), `ORGANIZATIONAL_UNIT`, `ORGANIZATION_MEMBER_ACCOUNT` (a share to an account in an organization).
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.bool] wait_for_acceptance: Whether to wait (up to the timeout) for the share to be accepted. Organizational shares are automatically accepted.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PortfolioShareArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Service Catalog Portfolio Share. Shares the specified portfolio with the specified account or organization node. You can share portfolios to an organization, an organizational unit, or a specific account.

        If the portfolio share with the specified account or organization node already exists, using this resource to re-create the share will have no effect and will not return an error. You can then use this resource to update the share.

        > **NOTE:** Shares to an organization node can only be created by the management account of an organization or by a delegated administrator. If a delegated admin is de-registered, they can no longer create portfolio shares.

        > **NOTE:** AWSOrganizationsAccess must be enabled in order to create a portfolio share to an organization node.

        > **NOTE:** You can't share a shared resource, including portfolios that contain a shared product.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.servicecatalog.PortfolioShare("example",
            principal_id="012128675309",
            portfolio_id=example_aws_servicecatalog_portfolio["id"],
            type="ACCOUNT")
        ```

        ## Import

        Using `pulumi import`, import `aws_servicecatalog_portfolio_share` using the portfolio share ID. For example:

        ```sh
        $ pulumi import aws:servicecatalog/portfolioShare:PortfolioShare example port-12344321:ACCOUNT:123456789012
        ```

        :param str resource_name: The name of the resource.
        :param PortfolioShareArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PortfolioShareArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accept_language: Optional[pulumi.Input[_builtins.str]] = None,
                 portfolio_id: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 share_principals: Optional[pulumi.Input[_builtins.bool]] = None,
                 share_tag_options: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 wait_for_acceptance: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PortfolioShareArgs.__new__(PortfolioShareArgs)

            __props__.__dict__["accept_language"] = accept_language
            if portfolio_id is None and not opts.urn:
                raise TypeError("Missing required property 'portfolio_id'")
            __props__.__dict__["portfolio_id"] = portfolio_id
            if principal_id is None and not opts.urn:
                raise TypeError("Missing required property 'principal_id'")
            __props__.__dict__["principal_id"] = principal_id
            __props__.__dict__["region"] = region
            __props__.__dict__["share_principals"] = share_principals
            __props__.__dict__["share_tag_options"] = share_tag_options
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["wait_for_acceptance"] = wait_for_acceptance
            __props__.__dict__["accepted"] = None
        super(PortfolioShare, __self__).__init__(
            'aws:servicecatalog/portfolioShare:PortfolioShare',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accept_language: Optional[pulumi.Input[_builtins.str]] = None,
            accepted: Optional[pulumi.Input[_builtins.bool]] = None,
            portfolio_id: Optional[pulumi.Input[_builtins.str]] = None,
            principal_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            share_principals: Optional[pulumi.Input[_builtins.bool]] = None,
            share_tag_options: Optional[pulumi.Input[_builtins.bool]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            wait_for_acceptance: Optional[pulumi.Input[_builtins.bool]] = None) -> 'PortfolioShare':
        """
        Get an existing PortfolioShare resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accept_language: Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
        :param pulumi.Input[_builtins.bool] accepted: Whether the shared portfolio is imported by the recipient account. If the recipient is organizational, the share is automatically imported, and the field is always set to true.
        :param pulumi.Input[_builtins.str] portfolio_id: Portfolio identifier.
        :param pulumi.Input[_builtins.str] principal_id: Identifier of the principal with whom you will share the portfolio. Valid values AWS account IDs and ARNs of AWS Organizations and organizational units.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] share_principals: Enables or disables Principal sharing when creating the portfolio share. If this flag is not provided, principal sharing is disabled.
        :param pulumi.Input[_builtins.bool] share_tag_options: Whether to enable sharing of `servicecatalog.TagOption` resources when creating the portfolio share.
        :param pulumi.Input[_builtins.str] type: Type of portfolio share. Valid values are `ACCOUNT` (an external account), `ORGANIZATION` (a share to every account in an organization), `ORGANIZATIONAL_UNIT`, `ORGANIZATION_MEMBER_ACCOUNT` (a share to an account in an organization).
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.bool] wait_for_acceptance: Whether to wait (up to the timeout) for the share to be accepted. Organizational shares are automatically accepted.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PortfolioShareState.__new__(_PortfolioShareState)

        __props__.__dict__["accept_language"] = accept_language
        __props__.__dict__["accepted"] = accepted
        __props__.__dict__["portfolio_id"] = portfolio_id
        __props__.__dict__["principal_id"] = principal_id
        __props__.__dict__["region"] = region
        __props__.__dict__["share_principals"] = share_principals
        __props__.__dict__["share_tag_options"] = share_tag_options
        __props__.__dict__["type"] = type
        __props__.__dict__["wait_for_acceptance"] = wait_for_acceptance
        return PortfolioShare(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="acceptLanguage")
    def accept_language(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
        """
        return pulumi.get(self, "accept_language")

    @_builtins.property
    @pulumi.getter
    def accepted(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the shared portfolio is imported by the recipient account. If the recipient is organizational, the share is automatically imported, and the field is always set to true.
        """
        return pulumi.get(self, "accepted")

    @_builtins.property
    @pulumi.getter(name="portfolioId")
    def portfolio_id(self) -> pulumi.Output[_builtins.str]:
        """
        Portfolio identifier.
        """
        return pulumi.get(self, "portfolio_id")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier of the principal with whom you will share the portfolio. Valid values AWS account IDs and ARNs of AWS Organizations and organizational units.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="sharePrincipals")
    def share_principals(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enables or disables Principal sharing when creating the portfolio share. If this flag is not provided, principal sharing is disabled.
        """
        return pulumi.get(self, "share_principals")

    @_builtins.property
    @pulumi.getter(name="shareTagOptions")
    def share_tag_options(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable sharing of `servicecatalog.TagOption` resources when creating the portfolio share.
        """
        return pulumi.get(self, "share_tag_options")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of portfolio share. Valid values are `ACCOUNT` (an external account), `ORGANIZATION` (a share to every account in an organization), `ORGANIZATIONAL_UNIT`, `ORGANIZATION_MEMBER_ACCOUNT` (a share to an account in an organization).

        The following arguments are optional:
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="waitForAcceptance")
    def wait_for_acceptance(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to wait (up to the timeout) for the share to be accepted. Organizational shares are automatically accepted.
        """
        return pulumi.get(self, "wait_for_acceptance")

