# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApplicationLayerAutomaticResponseArgs', 'ApplicationLayerAutomaticResponse']

@pulumi.input_type
class ApplicationLayerAutomaticResponseArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.str],
                 resource_arn: pulumi.Input[_builtins.str],
                 timeouts: Optional[pulumi.Input['ApplicationLayerAutomaticResponseTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a ApplicationLayerAutomaticResponse resource.
        :param pulumi.Input[_builtins.str] action: One of `COUNT` or `BLOCK`
        :param pulumi.Input[_builtins.str] resource_arn: ARN of the resource to protect (Cloudfront Distributions and ALBs only at this time).
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "resource_arn", resource_arn)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.str]:
        """
        One of `COUNT` or `BLOCK`
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> pulumi.Input[_builtins.str]:
        """
        ARN of the resource to protect (Cloudfront Distributions and ALBs only at this time).
        """
        return pulumi.get(self, "resource_arn")

    @resource_arn.setter
    def resource_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_arn", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ApplicationLayerAutomaticResponseTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ApplicationLayerAutomaticResponseTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _ApplicationLayerAutomaticResponseState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['ApplicationLayerAutomaticResponseTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering ApplicationLayerAutomaticResponse resources.
        :param pulumi.Input[_builtins.str] action: One of `COUNT` or `BLOCK`
        :param pulumi.Input[_builtins.str] resource_arn: ARN of the resource to protect (Cloudfront Distributions and ALBs only at this time).
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if resource_arn is not None:
            pulumi.set(__self__, "resource_arn", resource_arn)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        One of `COUNT` or `BLOCK`
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the resource to protect (Cloudfront Distributions and ALBs only at this time).
        """
        return pulumi.get(self, "resource_arn")

    @resource_arn.setter
    def resource_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_arn", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ApplicationLayerAutomaticResponseTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ApplicationLayerAutomaticResponseTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:shield/applicationLayerAutomaticResponse:ApplicationLayerAutomaticResponse")
class ApplicationLayerAutomaticResponse(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['ApplicationLayerAutomaticResponseTimeoutsArgs', 'ApplicationLayerAutomaticResponseTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Shield Application Layer Automatic Response for automatic DDoS mitigation.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_region()
        current_get_caller_identity = aws.get_caller_identity()
        current_get_partition = aws.get_partition()
        config = pulumi.Config()
        # The Cloudfront Distribution on which to enable the Application Layer Automatic Response.
        distribution_id = config.require("distributionId")
        example = aws.shield.ApplicationLayerAutomaticResponse("example",
            resource_arn=f"arn:{current_get_partition.partition}:cloudfront:{current_get_caller_identity.account_id}:distribution/{distribution_id}",
            action="COUNT")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: One of `COUNT` or `BLOCK`
        :param pulumi.Input[_builtins.str] resource_arn: ARN of the resource to protect (Cloudfront Distributions and ALBs only at this time).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplicationLayerAutomaticResponseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Shield Application Layer Automatic Response for automatic DDoS mitigation.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_region()
        current_get_caller_identity = aws.get_caller_identity()
        current_get_partition = aws.get_partition()
        config = pulumi.Config()
        # The Cloudfront Distribution on which to enable the Application Layer Automatic Response.
        distribution_id = config.require("distributionId")
        example = aws.shield.ApplicationLayerAutomaticResponse("example",
            resource_arn=f"arn:{current_get_partition.partition}:cloudfront:{current_get_caller_identity.account_id}:distribution/{distribution_id}",
            action="COUNT")
        ```

        :param str resource_name: The name of the resource.
        :param ApplicationLayerAutomaticResponseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationLayerAutomaticResponseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['ApplicationLayerAutomaticResponseTimeoutsArgs', 'ApplicationLayerAutomaticResponseTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationLayerAutomaticResponseArgs.__new__(ApplicationLayerAutomaticResponseArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            if resource_arn is None and not opts.urn:
                raise TypeError("Missing required property 'resource_arn'")
            __props__.__dict__["resource_arn"] = resource_arn
            __props__.__dict__["timeouts"] = timeouts
        super(ApplicationLayerAutomaticResponse, __self__).__init__(
            'aws:shield/applicationLayerAutomaticResponse:ApplicationLayerAutomaticResponse',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[_builtins.str]] = None,
            resource_arn: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['ApplicationLayerAutomaticResponseTimeoutsArgs', 'ApplicationLayerAutomaticResponseTimeoutsArgsDict']]] = None) -> 'ApplicationLayerAutomaticResponse':
        """
        Get an existing ApplicationLayerAutomaticResponse resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: One of `COUNT` or `BLOCK`
        :param pulumi.Input[_builtins.str] resource_arn: ARN of the resource to protect (Cloudfront Distributions and ALBs only at this time).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplicationLayerAutomaticResponseState.__new__(_ApplicationLayerAutomaticResponseState)

        __props__.__dict__["action"] = action
        __props__.__dict__["resource_arn"] = resource_arn
        __props__.__dict__["timeouts"] = timeouts
        return ApplicationLayerAutomaticResponse(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output[_builtins.str]:
        """
        One of `COUNT` or `BLOCK`
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the resource to protect (Cloudfront Distributions and ALBs only at this time).
        """
        return pulumi.get(self, "resource_arn")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.ApplicationLayerAutomaticResponseTimeouts']]:
        return pulumi.get(self, "timeouts")

