# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetProtectionResult',
    'AwaitableGetProtectionResult',
    'get_protection',
    'get_protection_output',
]

@pulumi.output_type
class GetProtectionResult:
    """
    A collection of values returned by getProtection.
    """
    def __init__(__self__, id=None, name=None, protection_arn=None, protection_id=None, resource_arn=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if protection_arn and not isinstance(protection_arn, str):
            raise TypeError("Expected argument 'protection_arn' to be a str")
        pulumi.set(__self__, "protection_arn", protection_arn)
        if protection_id and not isinstance(protection_id, str):
            raise TypeError("Expected argument 'protection_id' to be a str")
        pulumi.set(__self__, "protection_id", protection_id)
        if resource_arn and not isinstance(resource_arn, str):
            raise TypeError("Expected argument 'resource_arn' to be a str")
        pulumi.set(__self__, "resource_arn", resource_arn)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the protection.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="protectionArn")
    def protection_arn(self) -> _builtins.str:
        """
        ARN of the protection.
        """
        return pulumi.get(self, "protection_arn")

    @_builtins.property
    @pulumi.getter(name="protectionId")
    def protection_id(self) -> _builtins.str:
        return pulumi.get(self, "protection_id")

    @_builtins.property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> _builtins.str:
        return pulumi.get(self, "resource_arn")


class AwaitableGetProtectionResult(GetProtectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProtectionResult(
            id=self.id,
            name=self.name,
            protection_arn=self.protection_arn,
            protection_id=self.protection_id,
            resource_arn=self.resource_arn)


def get_protection(protection_id: Optional[_builtins.str] = None,
                   resource_arn: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProtectionResult:
    """
    Data source for managing an AWS Shield Protection.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.shield.get_protection(protection_id="abc123")
    ```

    ### By Resource ARN

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.shield.get_protection(resource_arn="arn:aws:globalaccelerator::123456789012:accelerator/1234abcd-abcd-1234-abcd-1234abcdefgh")
    ```


    :param _builtins.str protection_id: Unique identifier for the protection.
    :param _builtins.str resource_arn: ARN (Amazon Resource Name) of the resource being protected.
           
           > Exactly one of `protection_id` or `resource_arn` is required.
    """
    __args__ = dict()
    __args__['protectionId'] = protection_id
    __args__['resourceArn'] = resource_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:shield/getProtection:getProtection', __args__, opts=opts, typ=GetProtectionResult).value

    return AwaitableGetProtectionResult(
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        protection_arn=pulumi.get(__ret__, 'protection_arn'),
        protection_id=pulumi.get(__ret__, 'protection_id'),
        resource_arn=pulumi.get(__ret__, 'resource_arn'))
def get_protection_output(protection_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          resource_arn: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProtectionResult]:
    """
    Data source for managing an AWS Shield Protection.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.shield.get_protection(protection_id="abc123")
    ```

    ### By Resource ARN

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.shield.get_protection(resource_arn="arn:aws:globalaccelerator::123456789012:accelerator/1234abcd-abcd-1234-abcd-1234abcdefgh")
    ```


    :param _builtins.str protection_id: Unique identifier for the protection.
    :param _builtins.str resource_arn: ARN (Amazon Resource Name) of the resource being protected.
           
           > Exactly one of `protection_id` or `resource_arn` is required.
    """
    __args__ = dict()
    __args__['protectionId'] = protection_id
    __args__['resourceArn'] = resource_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:shield/getProtection:getProtection', __args__, opts=opts, typ=GetProtectionResult)
    return __ret__.apply(lambda __response__: GetProtectionResult(
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        protection_arn=pulumi.get(__response__, 'protection_arn'),
        protection_id=pulumi.get(__response__, 'protection_id'),
        resource_arn=pulumi.get(__response__, 'resource_arn')))
