# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PatchGroupArgs', 'PatchGroup']

@pulumi.input_type
class PatchGroupArgs:
    def __init__(__self__, *,
                 baseline_id: pulumi.Input[_builtins.str],
                 patch_group: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PatchGroup resource.
        :param pulumi.Input[_builtins.str] baseline_id: The ID of the patch baseline to register the patch group with.
        :param pulumi.Input[_builtins.str] patch_group: The name of the patch group that should be registered with the patch baseline.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "baseline_id", baseline_id)
        pulumi.set(__self__, "patch_group", patch_group)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="baselineId")
    def baseline_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the patch baseline to register the patch group with.
        """
        return pulumi.get(self, "baseline_id")

    @baseline_id.setter
    def baseline_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "baseline_id", value)

    @_builtins.property
    @pulumi.getter(name="patchGroup")
    def patch_group(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the patch group that should be registered with the patch baseline.
        """
        return pulumi.get(self, "patch_group")

    @patch_group.setter
    def patch_group(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "patch_group", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _PatchGroupState:
    def __init__(__self__, *,
                 baseline_id: Optional[pulumi.Input[_builtins.str]] = None,
                 patch_group: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PatchGroup resources.
        :param pulumi.Input[_builtins.str] baseline_id: The ID of the patch baseline to register the patch group with.
        :param pulumi.Input[_builtins.str] patch_group: The name of the patch group that should be registered with the patch baseline.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if baseline_id is not None:
            pulumi.set(__self__, "baseline_id", baseline_id)
        if patch_group is not None:
            pulumi.set(__self__, "patch_group", patch_group)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="baselineId")
    def baseline_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the patch baseline to register the patch group with.
        """
        return pulumi.get(self, "baseline_id")

    @baseline_id.setter
    def baseline_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "baseline_id", value)

    @_builtins.property
    @pulumi.getter(name="patchGroup")
    def patch_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the patch group that should be registered with the patch baseline.
        """
        return pulumi.get(self, "patch_group")

    @patch_group.setter
    def patch_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "patch_group", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:ssm/patchGroup:PatchGroup")
class PatchGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 baseline_id: Optional[pulumi.Input[_builtins.str]] = None,
                 patch_group: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an SSM Patch Group resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        production = aws.ssm.PatchBaseline("production",
            name="patch-baseline",
            approved_patches=["KB123456"])
        patchgroup = aws.ssm.PatchGroup("patchgroup",
            baseline_id=production.id,
            patch_group="patch-group-name")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] baseline_id: The ID of the patch baseline to register the patch group with.
        :param pulumi.Input[_builtins.str] patch_group: The name of the patch group that should be registered with the patch baseline.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PatchGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an SSM Patch Group resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        production = aws.ssm.PatchBaseline("production",
            name="patch-baseline",
            approved_patches=["KB123456"])
        patchgroup = aws.ssm.PatchGroup("patchgroup",
            baseline_id=production.id,
            patch_group="patch-group-name")
        ```

        :param str resource_name: The name of the resource.
        :param PatchGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PatchGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 baseline_id: Optional[pulumi.Input[_builtins.str]] = None,
                 patch_group: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PatchGroupArgs.__new__(PatchGroupArgs)

            if baseline_id is None and not opts.urn:
                raise TypeError("Missing required property 'baseline_id'")
            __props__.__dict__["baseline_id"] = baseline_id
            if patch_group is None and not opts.urn:
                raise TypeError("Missing required property 'patch_group'")
            __props__.__dict__["patch_group"] = patch_group
            __props__.__dict__["region"] = region
        super(PatchGroup, __self__).__init__(
            'aws:ssm/patchGroup:PatchGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            baseline_id: Optional[pulumi.Input[_builtins.str]] = None,
            patch_group: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'PatchGroup':
        """
        Get an existing PatchGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] baseline_id: The ID of the patch baseline to register the patch group with.
        :param pulumi.Input[_builtins.str] patch_group: The name of the patch group that should be registered with the patch baseline.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PatchGroupState.__new__(_PatchGroupState)

        __props__.__dict__["baseline_id"] = baseline_id
        __props__.__dict__["patch_group"] = patch_group
        __props__.__dict__["region"] = region
        return PatchGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="baselineId")
    def baseline_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the patch baseline to register the patch group with.
        """
        return pulumi.get(self, "baseline_id")

    @_builtins.property
    @pulumi.getter(name="patchGroup")
    def patch_group(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the patch group that should be registered with the patch baseline.
        """
        return pulumi.get(self, "patch_group")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

