# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ApplicationAssignmentConfigurationArgs', 'ApplicationAssignmentConfiguration']

@pulumi.input_type
class ApplicationAssignmentConfigurationArgs:
    def __init__(__self__, *,
                 application_arn: pulumi.Input[_builtins.str],
                 assignment_required: pulumi.Input[_builtins.bool],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ApplicationAssignmentConfiguration resource.
        :param pulumi.Input[_builtins.str] application_arn: ARN of the application.
        :param pulumi.Input[_builtins.bool] assignment_required: Indicates whether users must have an explicit assignment to access the application. If `false`, all users have access to the application.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "application_arn", application_arn)
        pulumi.set(__self__, "assignment_required", assignment_required)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> pulumi.Input[_builtins.str]:
        """
        ARN of the application.
        """
        return pulumi.get(self, "application_arn")

    @application_arn.setter
    def application_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "application_arn", value)

    @_builtins.property
    @pulumi.getter(name="assignmentRequired")
    def assignment_required(self) -> pulumi.Input[_builtins.bool]:
        """
        Indicates whether users must have an explicit assignment to access the application. If `false`, all users have access to the application.
        """
        return pulumi.get(self, "assignment_required")

    @assignment_required.setter
    def assignment_required(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "assignment_required", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ApplicationAssignmentConfigurationState:
    def __init__(__self__, *,
                 application_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 assignment_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ApplicationAssignmentConfiguration resources.
        :param pulumi.Input[_builtins.str] application_arn: ARN of the application.
        :param pulumi.Input[_builtins.bool] assignment_required: Indicates whether users must have an explicit assignment to access the application. If `false`, all users have access to the application.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if application_arn is not None:
            pulumi.set(__self__, "application_arn", application_arn)
        if assignment_required is not None:
            pulumi.set(__self__, "assignment_required", assignment_required)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the application.
        """
        return pulumi.get(self, "application_arn")

    @application_arn.setter
    def application_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_arn", value)

    @_builtins.property
    @pulumi.getter(name="assignmentRequired")
    def assignment_required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether users must have an explicit assignment to access the application. If `false`, all users have access to the application.
        """
        return pulumi.get(self, "assignment_required")

    @assignment_required.setter
    def assignment_required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "assignment_required", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:ssoadmin/applicationAssignmentConfiguration:ApplicationAssignmentConfiguration")
class ApplicationAssignmentConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 assignment_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS SSO Admin Application Assignment Configuration.

        By default, applications will require users to have an explicit assignment in order to access an application.
        This resource can be used to adjust this default behavior if necessary.

        > Deleting this resource will return the assignment configuration for the application to the default AWS behavior (ie. `assignment_required = true`).

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssoadmin.ApplicationAssignmentConfiguration("example",
            application_arn=example_aws_ssoadmin_application["arn"],
            assignment_required=True)
        ```

        ## Import

        ### Identity Schema

        #### Required

        - `arn` (String) Amazon Resource Name (ARN) of the SSO application.

        Using `pulumi import`, import SSO Admin Application Assignment Configuration using the `id`. For example:

        console

        % pulumi import aws_ssoadmin_application_assignment_configuration.example arn:aws:sso::123456789012:application/id-12345678

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_arn: ARN of the application.
        :param pulumi.Input[_builtins.bool] assignment_required: Indicates whether users must have an explicit assignment to access the application. If `false`, all users have access to the application.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplicationAssignmentConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS SSO Admin Application Assignment Configuration.

        By default, applications will require users to have an explicit assignment in order to access an application.
        This resource can be used to adjust this default behavior if necessary.

        > Deleting this resource will return the assignment configuration for the application to the default AWS behavior (ie. `assignment_required = true`).

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssoadmin.ApplicationAssignmentConfiguration("example",
            application_arn=example_aws_ssoadmin_application["arn"],
            assignment_required=True)
        ```

        ## Import

        ### Identity Schema

        #### Required

        - `arn` (String) Amazon Resource Name (ARN) of the SSO application.

        Using `pulumi import`, import SSO Admin Application Assignment Configuration using the `id`. For example:

        console

        % pulumi import aws_ssoadmin_application_assignment_configuration.example arn:aws:sso::123456789012:application/id-12345678

        :param str resource_name: The name of the resource.
        :param ApplicationAssignmentConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationAssignmentConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 assignment_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationAssignmentConfigurationArgs.__new__(ApplicationAssignmentConfigurationArgs)

            if application_arn is None and not opts.urn:
                raise TypeError("Missing required property 'application_arn'")
            __props__.__dict__["application_arn"] = application_arn
            if assignment_required is None and not opts.urn:
                raise TypeError("Missing required property 'assignment_required'")
            __props__.__dict__["assignment_required"] = assignment_required
            __props__.__dict__["region"] = region
        super(ApplicationAssignmentConfiguration, __self__).__init__(
            'aws:ssoadmin/applicationAssignmentConfiguration:ApplicationAssignmentConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_arn: Optional[pulumi.Input[_builtins.str]] = None,
            assignment_required: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'ApplicationAssignmentConfiguration':
        """
        Get an existing ApplicationAssignmentConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_arn: ARN of the application.
        :param pulumi.Input[_builtins.bool] assignment_required: Indicates whether users must have an explicit assignment to access the application. If `false`, all users have access to the application.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplicationAssignmentConfigurationState.__new__(_ApplicationAssignmentConfigurationState)

        __props__.__dict__["application_arn"] = application_arn
        __props__.__dict__["assignment_required"] = assignment_required
        __props__.__dict__["region"] = region
        return ApplicationAssignmentConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the application.
        """
        return pulumi.get(self, "application_arn")

    @_builtins.property
    @pulumi.getter(name="assignmentRequired")
    def assignment_required(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether users must have an explicit assignment to access the application. If `false`, all users have access to the application.
        """
        return pulumi.get(self, "assignment_required")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

