# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPermissionSetResult',
    'AwaitableGetPermissionSetResult',
    'get_permission_set',
    'get_permission_set_output',
]

@pulumi.output_type
class GetPermissionSetResult:
    """
    A collection of values returned by getPermissionSet.
    """
    def __init__(__self__, arn=None, created_date=None, description=None, id=None, instance_arn=None, name=None, region=None, relay_state=None, session_duration=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if created_date and not isinstance(created_date, str):
            raise TypeError("Expected argument 'created_date' to be a str")
        pulumi.set(__self__, "created_date", created_date)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_arn and not isinstance(instance_arn, str):
            raise TypeError("Expected argument 'instance_arn' to be a str")
        pulumi.set(__self__, "instance_arn", instance_arn)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if relay_state and not isinstance(relay_state, str):
            raise TypeError("Expected argument 'relay_state' to be a str")
        pulumi.set(__self__, "relay_state", relay_state)
        if session_duration and not isinstance(session_duration, str):
            raise TypeError("Expected argument 'session_duration' to be a str")
        pulumi.set(__self__, "session_duration", session_duration)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> _builtins.str:
        return pulumi.get(self, "created_date")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the Permission Set.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> _builtins.str:
        return pulumi.get(self, "instance_arn")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="relayState")
    def relay_state(self) -> _builtins.str:
        """
        Relay state URL used to redirect users within the application during the federation authentication process.
        """
        return pulumi.get(self, "relay_state")

    @_builtins.property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> _builtins.str:
        """
        Length of time that the application user sessions are valid in the ISO-8601 standard.
        """
        return pulumi.get(self, "session_duration")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")


class AwaitableGetPermissionSetResult(GetPermissionSetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPermissionSetResult(
            arn=self.arn,
            created_date=self.created_date,
            description=self.description,
            id=self.id,
            instance_arn=self.instance_arn,
            name=self.name,
            region=self.region,
            relay_state=self.relay_state,
            session_duration=self.session_duration,
            tags=self.tags)


def get_permission_set(arn: Optional[_builtins.str] = None,
                       instance_arn: Optional[_builtins.str] = None,
                       name: Optional[_builtins.str] = None,
                       region: Optional[_builtins.str] = None,
                       tags: Optional[Mapping[str, _builtins.str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPermissionSetResult:
    """
    Use this data source to get a Single Sign-On (SSO) Permission Set.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ssoadmin.get_instances()
    example_get_permission_set = aws.ssoadmin.get_permission_set(instance_arn=example.arns[0],
        name="Example")
    pulumi.export("arn", example_get_permission_set.arn)
    ```


    :param _builtins.str arn: ARN of the permission set.
    :param _builtins.str instance_arn: ARN of the SSO Instance associated with the permission set.
    :param _builtins.str name: Name of the SSO Permission Set.
           
           > **NOTE:** Either `arn` or `name` must be configured.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Key-value map of resource tags.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['instanceArn'] = instance_arn
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ssoadmin/getPermissionSet:getPermissionSet', __args__, opts=opts, typ=GetPermissionSetResult).value

    return AwaitableGetPermissionSetResult(
        arn=pulumi.get(__ret__, 'arn'),
        created_date=pulumi.get(__ret__, 'created_date'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        instance_arn=pulumi.get(__ret__, 'instance_arn'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        relay_state=pulumi.get(__ret__, 'relay_state'),
        session_duration=pulumi.get(__ret__, 'session_duration'),
        tags=pulumi.get(__ret__, 'tags'))
def get_permission_set_output(arn: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              instance_arn: Optional[pulumi.Input[_builtins.str]] = None,
                              name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPermissionSetResult]:
    """
    Use this data source to get a Single Sign-On (SSO) Permission Set.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ssoadmin.get_instances()
    example_get_permission_set = aws.ssoadmin.get_permission_set(instance_arn=example.arns[0],
        name="Example")
    pulumi.export("arn", example_get_permission_set.arn)
    ```


    :param _builtins.str arn: ARN of the permission set.
    :param _builtins.str instance_arn: ARN of the SSO Instance associated with the permission set.
    :param _builtins.str name: Name of the SSO Permission Set.
           
           > **NOTE:** Either `arn` or `name` must be configured.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Key-value map of resource tags.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['instanceArn'] = instance_arn
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ssoadmin/getPermissionSet:getPermissionSet', __args__, opts=opts, typ=GetPermissionSetResult)
    return __ret__.apply(lambda __response__: GetPermissionSetResult(
        arn=pulumi.get(__response__, 'arn'),
        created_date=pulumi.get(__response__, 'created_date'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        instance_arn=pulumi.get(__response__, 'instance_arn'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        relay_state=pulumi.get(__response__, 'relay_state'),
        session_duration=pulumi.get(__response__, 'session_duration'),
        tags=pulumi.get(__response__, 'tags')))
