# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetLocalDiskResult',
    'AwaitableGetLocalDiskResult',
    'get_local_disk',
    'get_local_disk_output',
]

@pulumi.output_type
class GetLocalDiskResult:
    """
    A collection of values returned by getLocalDisk.
    """
    def __init__(__self__, disk_id=None, disk_node=None, disk_path=None, gateway_arn=None, id=None, region=None):
        if disk_id and not isinstance(disk_id, str):
            raise TypeError("Expected argument 'disk_id' to be a str")
        pulumi.set(__self__, "disk_id", disk_id)
        if disk_node and not isinstance(disk_node, str):
            raise TypeError("Expected argument 'disk_node' to be a str")
        pulumi.set(__self__, "disk_node", disk_node)
        if disk_path and not isinstance(disk_path, str):
            raise TypeError("Expected argument 'disk_path' to be a str")
        pulumi.set(__self__, "disk_path", disk_path)
        if gateway_arn and not isinstance(gateway_arn, str):
            raise TypeError("Expected argument 'gateway_arn' to be a str")
        pulumi.set(__self__, "gateway_arn", gateway_arn)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> _builtins.str:
        """
        Disk identifierE.g., `pci-0000:03:00.0-scsi-0:0:0:0`
        """
        return pulumi.get(self, "disk_id")

    @_builtins.property
    @pulumi.getter(name="diskNode")
    def disk_node(self) -> _builtins.str:
        return pulumi.get(self, "disk_node")

    @_builtins.property
    @pulumi.getter(name="diskPath")
    def disk_path(self) -> _builtins.str:
        return pulumi.get(self, "disk_path")

    @_builtins.property
    @pulumi.getter(name="gatewayArn")
    def gateway_arn(self) -> _builtins.str:
        return pulumi.get(self, "gateway_arn")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetLocalDiskResult(GetLocalDiskResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLocalDiskResult(
            disk_id=self.disk_id,
            disk_node=self.disk_node,
            disk_path=self.disk_path,
            gateway_arn=self.gateway_arn,
            id=self.id,
            region=self.region)


def get_local_disk(disk_node: Optional[_builtins.str] = None,
                   disk_path: Optional[_builtins.str] = None,
                   gateway_arn: Optional[_builtins.str] = None,
                   region: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLocalDiskResult:
    """
    Retrieve information about a Storage Gateway local disk. The disk identifier is useful for adding the disk as a cache or upload buffer to a gateway.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.storagegateway.get_local_disk(disk_path=test_aws_volume_attachment["deviceName"],
        gateway_arn=test_aws_storagegateway_gateway["arn"])
    ```


    :param _builtins.str disk_node: Device node of the local disk to retrieve. For example, `/dev/sdb`.
    :param _builtins.str disk_path: Device path of the local disk to retrieve. For example, `/dev/xvdb` or `/dev/nvme1n1`.
    :param _builtins.str gateway_arn: ARN of the gateway.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['diskNode'] = disk_node
    __args__['diskPath'] = disk_path
    __args__['gatewayArn'] = gateway_arn
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:storagegateway/getLocalDisk:getLocalDisk', __args__, opts=opts, typ=GetLocalDiskResult).value

    return AwaitableGetLocalDiskResult(
        disk_id=pulumi.get(__ret__, 'disk_id'),
        disk_node=pulumi.get(__ret__, 'disk_node'),
        disk_path=pulumi.get(__ret__, 'disk_path'),
        gateway_arn=pulumi.get(__ret__, 'gateway_arn'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'))
def get_local_disk_output(disk_node: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          disk_path: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          gateway_arn: Optional[pulumi.Input[_builtins.str]] = None,
                          region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLocalDiskResult]:
    """
    Retrieve information about a Storage Gateway local disk. The disk identifier is useful for adding the disk as a cache or upload buffer to a gateway.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.storagegateway.get_local_disk(disk_path=test_aws_volume_attachment["deviceName"],
        gateway_arn=test_aws_storagegateway_gateway["arn"])
    ```


    :param _builtins.str disk_node: Device node of the local disk to retrieve. For example, `/dev/sdb`.
    :param _builtins.str disk_path: Device path of the local disk to retrieve. For example, `/dev/xvdb` or `/dev/nvme1n1`.
    :param _builtins.str gateway_arn: ARN of the gateway.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['diskNode'] = disk_node
    __args__['diskPath'] = disk_path
    __args__['gatewayArn'] = gateway_arn
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:storagegateway/getLocalDisk:getLocalDisk', __args__, opts=opts, typ=GetLocalDiskResult)
    return __ret__.apply(lambda __response__: GetLocalDiskResult(
        disk_id=pulumi.get(__response__, 'disk_id'),
        disk_node=pulumi.get(__response__, 'disk_node'),
        disk_path=pulumi.get(__response__, 'disk_path'),
        gateway_arn=pulumi.get(__response__, 'gateway_arn'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region')))
