# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['StoredIscsiVolumeArgs', 'StoredIscsiVolume']

@pulumi.input_type
class StoredIscsiVolumeArgs:
    def __init__(__self__, *,
                 disk_id: pulumi.Input[_builtins.str],
                 gateway_arn: pulumi.Input[_builtins.str],
                 network_interface_id: pulumi.Input[_builtins.str],
                 preserve_existing_data: pulumi.Input[_builtins.bool],
                 target_name: pulumi.Input[_builtins.str],
                 kms_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 kms_key: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a StoredIscsiVolume resource.
        :param pulumi.Input[_builtins.str] disk_id: The unique identifier for the gateway local disk that is configured as a stored volume.
        :param pulumi.Input[_builtins.str] gateway_arn: The Amazon Resource Name (ARN) of the gateway.
        :param pulumi.Input[_builtins.str] network_interface_id: The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted.
        :param pulumi.Input[_builtins.bool] preserve_existing_data: Specify this field as `true` if you want to preserve the data on the local disk. Otherwise, specifying this field as false creates an empty volume.
        :param pulumi.Input[_builtins.str] target_name: The name of the iSCSI target used by initiators to connect to the target and as a suffix for the target ARN. The target name must be unique across all volumes of a gateway.
        :param pulumi.Input[_builtins.bool] kms_encrypted: `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Optional.
        :param pulumi.Input[_builtins.str] kms_key: The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is `true`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] snapshot_id: The snapshot ID of the snapshot to restore as the new stored volumeE.g., `snap-1122aabb`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "disk_id", disk_id)
        pulumi.set(__self__, "gateway_arn", gateway_arn)
        pulumi.set(__self__, "network_interface_id", network_interface_id)
        pulumi.set(__self__, "preserve_existing_data", preserve_existing_data)
        pulumi.set(__self__, "target_name", target_name)
        if kms_encrypted is not None:
            pulumi.set(__self__, "kms_encrypted", kms_encrypted)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> pulumi.Input[_builtins.str]:
        """
        The unique identifier for the gateway local disk that is configured as a stored volume.
        """
        return pulumi.get(self, "disk_id")

    @disk_id.setter
    def disk_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "disk_id", value)

    @_builtins.property
    @pulumi.getter(name="gatewayArn")
    def gateway_arn(self) -> pulumi.Input[_builtins.str]:
        """
        The Amazon Resource Name (ARN) of the gateway.
        """
        return pulumi.get(self, "gateway_arn")

    @gateway_arn.setter
    def gateway_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "gateway_arn", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> pulumi.Input[_builtins.str]:
        """
        The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted.
        """
        return pulumi.get(self, "network_interface_id")

    @network_interface_id.setter
    def network_interface_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_interface_id", value)

    @_builtins.property
    @pulumi.getter(name="preserveExistingData")
    def preserve_existing_data(self) -> pulumi.Input[_builtins.bool]:
        """
        Specify this field as `true` if you want to preserve the data on the local disk. Otherwise, specifying this field as false creates an empty volume.
        """
        return pulumi.get(self, "preserve_existing_data")

    @preserve_existing_data.setter
    def preserve_existing_data(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "preserve_existing_data", value)

    @_builtins.property
    @pulumi.getter(name="targetName")
    def target_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the iSCSI target used by initiators to connect to the target and as a suffix for the target ARN. The target name must be unique across all volumes of a gateway.
        """
        return pulumi.get(self, "target_name")

    @target_name.setter
    def target_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_name", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncrypted")
    def kms_encrypted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Optional.
        """
        return pulumi.get(self, "kms_encrypted")

    @kms_encrypted.setter
    def kms_encrypted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "kms_encrypted", value)

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is `true`.
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snapshot ID of the snapshot to restore as the new stored volumeE.g., `snap-1122aabb`.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value mapping of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _StoredIscsiVolumeState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 chap_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 disk_id: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 kms_key: Optional[pulumi.Input[_builtins.str]] = None,
                 lun_number: Optional[pulumi.Input[_builtins.int]] = None,
                 network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interface_port: Optional[pulumi.Input[_builtins.int]] = None,
                 preserve_existing_data: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 target_name: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_attachment_status: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_id: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_size_in_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 volume_status: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering StoredIscsiVolume resources.
        :param pulumi.Input[_builtins.str] arn: Volume Amazon Resource Name (ARN), e.g., `arn:aws:storagegateway:us-east-1:123456789012:gateway/sgw-12345678/volume/vol-12345678`.
        :param pulumi.Input[_builtins.bool] chap_enabled: Whether mutual CHAP is enabled for the iSCSI target.
        :param pulumi.Input[_builtins.str] disk_id: The unique identifier for the gateway local disk that is configured as a stored volume.
        :param pulumi.Input[_builtins.str] gateway_arn: The Amazon Resource Name (ARN) of the gateway.
        :param pulumi.Input[_builtins.bool] kms_encrypted: `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Optional.
        :param pulumi.Input[_builtins.str] kms_key: The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is `true`.
        :param pulumi.Input[_builtins.int] lun_number: Logical disk number.
        :param pulumi.Input[_builtins.str] network_interface_id: The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted.
        :param pulumi.Input[_builtins.int] network_interface_port: The port used to communicate with iSCSI targets.
        :param pulumi.Input[_builtins.bool] preserve_existing_data: Specify this field as `true` if you want to preserve the data on the local disk. Otherwise, specifying this field as false creates an empty volume.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] snapshot_id: The snapshot ID of the snapshot to restore as the new stored volumeE.g., `snap-1122aabb`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] target_arn: Target Amazon Resource Name (ARN), e.g., `arn:aws:storagegateway:us-east-1:123456789012:gateway/sgw-12345678/target/iqn.1997-05.com.amazon:TargetName`.
        :param pulumi.Input[_builtins.str] target_name: The name of the iSCSI target used by initiators to connect to the target and as a suffix for the target ARN. The target name must be unique across all volumes of a gateway.
        :param pulumi.Input[_builtins.str] volume_attachment_status: A value that indicates whether a storage volume is attached to, detached from, or is in the process of detaching from a gateway.
        :param pulumi.Input[_builtins.str] volume_id: Volume ID, e.g., `vol-12345678`.
        :param pulumi.Input[_builtins.int] volume_size_in_bytes: The size of the data stored on the volume in bytes.
        :param pulumi.Input[_builtins.str] volume_status: indicates the state of the storage volume.
        :param pulumi.Input[_builtins.str] volume_type: indicates the type of the volume.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if chap_enabled is not None:
            pulumi.set(__self__, "chap_enabled", chap_enabled)
        if disk_id is not None:
            pulumi.set(__self__, "disk_id", disk_id)
        if gateway_arn is not None:
            pulumi.set(__self__, "gateway_arn", gateway_arn)
        if kms_encrypted is not None:
            pulumi.set(__self__, "kms_encrypted", kms_encrypted)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if lun_number is not None:
            pulumi.set(__self__, "lun_number", lun_number)
        if network_interface_id is not None:
            pulumi.set(__self__, "network_interface_id", network_interface_id)
        if network_interface_port is not None:
            pulumi.set(__self__, "network_interface_port", network_interface_port)
        if preserve_existing_data is not None:
            pulumi.set(__self__, "preserve_existing_data", preserve_existing_data)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if target_arn is not None:
            pulumi.set(__self__, "target_arn", target_arn)
        if target_name is not None:
            pulumi.set(__self__, "target_name", target_name)
        if volume_attachment_status is not None:
            pulumi.set(__self__, "volume_attachment_status", volume_attachment_status)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)
        if volume_size_in_bytes is not None:
            pulumi.set(__self__, "volume_size_in_bytes", volume_size_in_bytes)
        if volume_status is not None:
            pulumi.set(__self__, "volume_status", volume_status)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Volume Amazon Resource Name (ARN), e.g., `arn:aws:storagegateway:us-east-1:123456789012:gateway/sgw-12345678/volume/vol-12345678`.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="chapEnabled")
    def chap_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether mutual CHAP is enabled for the iSCSI target.
        """
        return pulumi.get(self, "chap_enabled")

    @chap_enabled.setter
    def chap_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "chap_enabled", value)

    @_builtins.property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier for the gateway local disk that is configured as a stored volume.
        """
        return pulumi.get(self, "disk_id")

    @disk_id.setter
    def disk_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_id", value)

    @_builtins.property
    @pulumi.getter(name="gatewayArn")
    def gateway_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the gateway.
        """
        return pulumi.get(self, "gateway_arn")

    @gateway_arn.setter
    def gateway_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_arn", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncrypted")
    def kms_encrypted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Optional.
        """
        return pulumi.get(self, "kms_encrypted")

    @kms_encrypted.setter
    def kms_encrypted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "kms_encrypted", value)

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is `true`.
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key", value)

    @_builtins.property
    @pulumi.getter(name="lunNumber")
    def lun_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Logical disk number.
        """
        return pulumi.get(self, "lun_number")

    @lun_number.setter
    def lun_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "lun_number", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted.
        """
        return pulumi.get(self, "network_interface_id")

    @network_interface_id.setter
    def network_interface_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_interface_id", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfacePort")
    def network_interface_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port used to communicate with iSCSI targets.
        """
        return pulumi.get(self, "network_interface_port")

    @network_interface_port.setter
    def network_interface_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "network_interface_port", value)

    @_builtins.property
    @pulumi.getter(name="preserveExistingData")
    def preserve_existing_data(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specify this field as `true` if you want to preserve the data on the local disk. Otherwise, specifying this field as false creates an empty volume.
        """
        return pulumi.get(self, "preserve_existing_data")

    @preserve_existing_data.setter
    def preserve_existing_data(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "preserve_existing_data", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snapshot ID of the snapshot to restore as the new stored volumeE.g., `snap-1122aabb`.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value mapping of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="targetArn")
    def target_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Target Amazon Resource Name (ARN), e.g., `arn:aws:storagegateway:us-east-1:123456789012:gateway/sgw-12345678/target/iqn.1997-05.com.amazon:TargetName`.
        """
        return pulumi.get(self, "target_arn")

    @target_arn.setter
    def target_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_arn", value)

    @_builtins.property
    @pulumi.getter(name="targetName")
    def target_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the iSCSI target used by initiators to connect to the target and as a suffix for the target ARN. The target name must be unique across all volumes of a gateway.
        """
        return pulumi.get(self, "target_name")

    @target_name.setter
    def target_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_name", value)

    @_builtins.property
    @pulumi.getter(name="volumeAttachmentStatus")
    def volume_attachment_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A value that indicates whether a storage volume is attached to, detached from, or is in the process of detaching from a gateway.
        """
        return pulumi.get(self, "volume_attachment_status")

    @volume_attachment_status.setter
    def volume_attachment_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_attachment_status", value)

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Volume ID, e.g., `vol-12345678`.
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_id", value)

    @_builtins.property
    @pulumi.getter(name="volumeSizeInBytes")
    def volume_size_in_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the data stored on the volume in bytes.
        """
        return pulumi.get(self, "volume_size_in_bytes")

    @volume_size_in_bytes.setter
    def volume_size_in_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "volume_size_in_bytes", value)

    @_builtins.property
    @pulumi.getter(name="volumeStatus")
    def volume_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        indicates the state of the storage volume.
        """
        return pulumi.get(self, "volume_status")

    @volume_status.setter
    def volume_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_status", value)

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        indicates the type of the volume.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_type", value)


@pulumi.type_token("aws:storagegateway/storedIscsiVolume:StoredIscsiVolume")
class StoredIscsiVolume(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disk_id: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 kms_key: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 preserve_existing_data: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an AWS Storage Gateway stored iSCSI volume.

        > **NOTE:** The gateway must have a working storage added (e.g., via the `storagegateway.WorkingStorage` resource) before the volume is operational to clients, however the Storage Gateway API will allow volume creation without error in that case and return volume status as `WORKING STORAGE NOT CONFIGURED`.

        ## Example Usage

        ### Create Empty Stored iSCSI Volume

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.storagegateway.StoredIscsiVolume("example",
            gateway_arn=example_aws_storagegateway_cache["gatewayArn"],
            network_interface_id=example_aws_instance["privateIp"],
            target_name="example",
            preserve_existing_data=False,
            disk_id=test["id"])
        ```

        ### Create Stored iSCSI Volume From Snapshot

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.storagegateway.StoredIscsiVolume("example",
            gateway_arn=example_aws_storagegateway_cache["gatewayArn"],
            network_interface_id=example_aws_instance["privateIp"],
            snapshot_id=example_aws_ebs_snapshot["id"],
            target_name="example",
            preserve_existing_data=False,
            disk_id=test["id"])
        ```

        ## Import

        Using `pulumi import`, import `aws_storagegateway_stored_iscsi_volume` using the volume Amazon Resource Name (ARN). For example:

        ```sh
        $ pulumi import aws:storagegateway/storedIscsiVolume:StoredIscsiVolume example arn:aws:storagegateway:us-east-1:123456789012:gateway/sgw-12345678/volume/vol-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] disk_id: The unique identifier for the gateway local disk that is configured as a stored volume.
        :param pulumi.Input[_builtins.str] gateway_arn: The Amazon Resource Name (ARN) of the gateway.
        :param pulumi.Input[_builtins.bool] kms_encrypted: `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Optional.
        :param pulumi.Input[_builtins.str] kms_key: The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is `true`.
        :param pulumi.Input[_builtins.str] network_interface_id: The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted.
        :param pulumi.Input[_builtins.bool] preserve_existing_data: Specify this field as `true` if you want to preserve the data on the local disk. Otherwise, specifying this field as false creates an empty volume.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] snapshot_id: The snapshot ID of the snapshot to restore as the new stored volumeE.g., `snap-1122aabb`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] target_name: The name of the iSCSI target used by initiators to connect to the target and as a suffix for the target ARN. The target name must be unique across all volumes of a gateway.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StoredIscsiVolumeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AWS Storage Gateway stored iSCSI volume.

        > **NOTE:** The gateway must have a working storage added (e.g., via the `storagegateway.WorkingStorage` resource) before the volume is operational to clients, however the Storage Gateway API will allow volume creation without error in that case and return volume status as `WORKING STORAGE NOT CONFIGURED`.

        ## Example Usage

        ### Create Empty Stored iSCSI Volume

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.storagegateway.StoredIscsiVolume("example",
            gateway_arn=example_aws_storagegateway_cache["gatewayArn"],
            network_interface_id=example_aws_instance["privateIp"],
            target_name="example",
            preserve_existing_data=False,
            disk_id=test["id"])
        ```

        ### Create Stored iSCSI Volume From Snapshot

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.storagegateway.StoredIscsiVolume("example",
            gateway_arn=example_aws_storagegateway_cache["gatewayArn"],
            network_interface_id=example_aws_instance["privateIp"],
            snapshot_id=example_aws_ebs_snapshot["id"],
            target_name="example",
            preserve_existing_data=False,
            disk_id=test["id"])
        ```

        ## Import

        Using `pulumi import`, import `aws_storagegateway_stored_iscsi_volume` using the volume Amazon Resource Name (ARN). For example:

        ```sh
        $ pulumi import aws:storagegateway/storedIscsiVolume:StoredIscsiVolume example arn:aws:storagegateway:us-east-1:123456789012:gateway/sgw-12345678/volume/vol-12345678
        ```

        :param str resource_name: The name of the resource.
        :param StoredIscsiVolumeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StoredIscsiVolumeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disk_id: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 kms_key: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 preserve_existing_data: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StoredIscsiVolumeArgs.__new__(StoredIscsiVolumeArgs)

            if disk_id is None and not opts.urn:
                raise TypeError("Missing required property 'disk_id'")
            __props__.__dict__["disk_id"] = disk_id
            if gateway_arn is None and not opts.urn:
                raise TypeError("Missing required property 'gateway_arn'")
            __props__.__dict__["gateway_arn"] = gateway_arn
            __props__.__dict__["kms_encrypted"] = kms_encrypted
            __props__.__dict__["kms_key"] = kms_key
            if network_interface_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_interface_id'")
            __props__.__dict__["network_interface_id"] = network_interface_id
            if preserve_existing_data is None and not opts.urn:
                raise TypeError("Missing required property 'preserve_existing_data'")
            __props__.__dict__["preserve_existing_data"] = preserve_existing_data
            __props__.__dict__["region"] = region
            __props__.__dict__["snapshot_id"] = snapshot_id
            __props__.__dict__["tags"] = tags
            if target_name is None and not opts.urn:
                raise TypeError("Missing required property 'target_name'")
            __props__.__dict__["target_name"] = target_name
            __props__.__dict__["arn"] = None
            __props__.__dict__["chap_enabled"] = None
            __props__.__dict__["lun_number"] = None
            __props__.__dict__["network_interface_port"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["target_arn"] = None
            __props__.__dict__["volume_attachment_status"] = None
            __props__.__dict__["volume_id"] = None
            __props__.__dict__["volume_size_in_bytes"] = None
            __props__.__dict__["volume_status"] = None
            __props__.__dict__["volume_type"] = None
        super(StoredIscsiVolume, __self__).__init__(
            'aws:storagegateway/storedIscsiVolume:StoredIscsiVolume',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            chap_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            disk_id: Optional[pulumi.Input[_builtins.str]] = None,
            gateway_arn: Optional[pulumi.Input[_builtins.str]] = None,
            kms_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
            kms_key: Optional[pulumi.Input[_builtins.str]] = None,
            lun_number: Optional[pulumi.Input[_builtins.int]] = None,
            network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
            network_interface_port: Optional[pulumi.Input[_builtins.int]] = None,
            preserve_existing_data: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            target_arn: Optional[pulumi.Input[_builtins.str]] = None,
            target_name: Optional[pulumi.Input[_builtins.str]] = None,
            volume_attachment_status: Optional[pulumi.Input[_builtins.str]] = None,
            volume_id: Optional[pulumi.Input[_builtins.str]] = None,
            volume_size_in_bytes: Optional[pulumi.Input[_builtins.int]] = None,
            volume_status: Optional[pulumi.Input[_builtins.str]] = None,
            volume_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'StoredIscsiVolume':
        """
        Get an existing StoredIscsiVolume resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: Volume Amazon Resource Name (ARN), e.g., `arn:aws:storagegateway:us-east-1:123456789012:gateway/sgw-12345678/volume/vol-12345678`.
        :param pulumi.Input[_builtins.bool] chap_enabled: Whether mutual CHAP is enabled for the iSCSI target.
        :param pulumi.Input[_builtins.str] disk_id: The unique identifier for the gateway local disk that is configured as a stored volume.
        :param pulumi.Input[_builtins.str] gateway_arn: The Amazon Resource Name (ARN) of the gateway.
        :param pulumi.Input[_builtins.bool] kms_encrypted: `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Optional.
        :param pulumi.Input[_builtins.str] kms_key: The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is `true`.
        :param pulumi.Input[_builtins.int] lun_number: Logical disk number.
        :param pulumi.Input[_builtins.str] network_interface_id: The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted.
        :param pulumi.Input[_builtins.int] network_interface_port: The port used to communicate with iSCSI targets.
        :param pulumi.Input[_builtins.bool] preserve_existing_data: Specify this field as `true` if you want to preserve the data on the local disk. Otherwise, specifying this field as false creates an empty volume.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] snapshot_id: The snapshot ID of the snapshot to restore as the new stored volumeE.g., `snap-1122aabb`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] target_arn: Target Amazon Resource Name (ARN), e.g., `arn:aws:storagegateway:us-east-1:123456789012:gateway/sgw-12345678/target/iqn.1997-05.com.amazon:TargetName`.
        :param pulumi.Input[_builtins.str] target_name: The name of the iSCSI target used by initiators to connect to the target and as a suffix for the target ARN. The target name must be unique across all volumes of a gateway.
        :param pulumi.Input[_builtins.str] volume_attachment_status: A value that indicates whether a storage volume is attached to, detached from, or is in the process of detaching from a gateway.
        :param pulumi.Input[_builtins.str] volume_id: Volume ID, e.g., `vol-12345678`.
        :param pulumi.Input[_builtins.int] volume_size_in_bytes: The size of the data stored on the volume in bytes.
        :param pulumi.Input[_builtins.str] volume_status: indicates the state of the storage volume.
        :param pulumi.Input[_builtins.str] volume_type: indicates the type of the volume.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StoredIscsiVolumeState.__new__(_StoredIscsiVolumeState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["chap_enabled"] = chap_enabled
        __props__.__dict__["disk_id"] = disk_id
        __props__.__dict__["gateway_arn"] = gateway_arn
        __props__.__dict__["kms_encrypted"] = kms_encrypted
        __props__.__dict__["kms_key"] = kms_key
        __props__.__dict__["lun_number"] = lun_number
        __props__.__dict__["network_interface_id"] = network_interface_id
        __props__.__dict__["network_interface_port"] = network_interface_port
        __props__.__dict__["preserve_existing_data"] = preserve_existing_data
        __props__.__dict__["region"] = region
        __props__.__dict__["snapshot_id"] = snapshot_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["target_arn"] = target_arn
        __props__.__dict__["target_name"] = target_name
        __props__.__dict__["volume_attachment_status"] = volume_attachment_status
        __props__.__dict__["volume_id"] = volume_id
        __props__.__dict__["volume_size_in_bytes"] = volume_size_in_bytes
        __props__.__dict__["volume_status"] = volume_status
        __props__.__dict__["volume_type"] = volume_type
        return StoredIscsiVolume(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        Volume Amazon Resource Name (ARN), e.g., `arn:aws:storagegateway:us-east-1:123456789012:gateway/sgw-12345678/volume/vol-12345678`.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="chapEnabled")
    def chap_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether mutual CHAP is enabled for the iSCSI target.
        """
        return pulumi.get(self, "chap_enabled")

    @_builtins.property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier for the gateway local disk that is configured as a stored volume.
        """
        return pulumi.get(self, "disk_id")

    @_builtins.property
    @pulumi.getter(name="gatewayArn")
    def gateway_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon Resource Name (ARN) of the gateway.
        """
        return pulumi.get(self, "gateway_arn")

    @_builtins.property
    @pulumi.getter(name="kmsEncrypted")
    def kms_encrypted(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Optional.
        """
        return pulumi.get(self, "kms_encrypted")

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is `true`.
        """
        return pulumi.get(self, "kms_key")

    @_builtins.property
    @pulumi.getter(name="lunNumber")
    def lun_number(self) -> pulumi.Output[_builtins.int]:
        """
        Logical disk number.
        """
        return pulumi.get(self, "lun_number")

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> pulumi.Output[_builtins.str]:
        """
        The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted.
        """
        return pulumi.get(self, "network_interface_id")

    @_builtins.property
    @pulumi.getter(name="networkInterfacePort")
    def network_interface_port(self) -> pulumi.Output[_builtins.int]:
        """
        The port used to communicate with iSCSI targets.
        """
        return pulumi.get(self, "network_interface_port")

    @_builtins.property
    @pulumi.getter(name="preserveExistingData")
    def preserve_existing_data(self) -> pulumi.Output[_builtins.bool]:
        """
        Specify this field as `true` if you want to preserve the data on the local disk. Otherwise, specifying this field as false creates an empty volume.
        """
        return pulumi.get(self, "preserve_existing_data")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The snapshot ID of the snapshot to restore as the new stored volumeE.g., `snap-1122aabb`.
        """
        return pulumi.get(self, "snapshot_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value mapping of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="targetArn")
    def target_arn(self) -> pulumi.Output[_builtins.str]:
        """
        Target Amazon Resource Name (ARN), e.g., `arn:aws:storagegateway:us-east-1:123456789012:gateway/sgw-12345678/target/iqn.1997-05.com.amazon:TargetName`.
        """
        return pulumi.get(self, "target_arn")

    @_builtins.property
    @pulumi.getter(name="targetName")
    def target_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the iSCSI target used by initiators to connect to the target and as a suffix for the target ARN. The target name must be unique across all volumes of a gateway.
        """
        return pulumi.get(self, "target_name")

    @_builtins.property
    @pulumi.getter(name="volumeAttachmentStatus")
    def volume_attachment_status(self) -> pulumi.Output[_builtins.str]:
        """
        A value that indicates whether a storage volume is attached to, detached from, or is in the process of detaching from a gateway.
        """
        return pulumi.get(self, "volume_attachment_status")

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> pulumi.Output[_builtins.str]:
        """
        Volume ID, e.g., `vol-12345678`.
        """
        return pulumi.get(self, "volume_id")

    @_builtins.property
    @pulumi.getter(name="volumeSizeInBytes")
    def volume_size_in_bytes(self) -> pulumi.Output[_builtins.int]:
        """
        The size of the data stored on the volume in bytes.
        """
        return pulumi.get(self, "volume_size_in_bytes")

    @_builtins.property
    @pulumi.getter(name="volumeStatus")
    def volume_status(self) -> pulumi.Output[_builtins.str]:
        """
        indicates the state of the storage volume.
        """
        return pulumi.get(self, "volume_status")

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> pulumi.Output[_builtins.str]:
        """
        indicates the type of the volume.
        """
        return pulumi.get(self, "volume_type")

