# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'LanguageModelInputDataConfig',
]

@pulumi.output_type
class LanguageModelInputDataConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataAccessRoleArn":
            suggest = "data_access_role_arn"
        elif key == "s3Uri":
            suggest = "s3_uri"
        elif key == "tuningDataS3Uri":
            suggest = "tuning_data_s3_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LanguageModelInputDataConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LanguageModelInputDataConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LanguageModelInputDataConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_access_role_arn: _builtins.str,
                 s3_uri: _builtins.str,
                 tuning_data_s3_uri: Optional[_builtins.str] = None):
        """
        :param _builtins.str data_access_role_arn: IAM role with access to S3 bucket.
        :param _builtins.str s3_uri: S3 URI where training data is located.
        :param _builtins.str tuning_data_s3_uri: S3 URI where tuning data is located.
               
               The following arguments are optional:
        """
        pulumi.set(__self__, "data_access_role_arn", data_access_role_arn)
        pulumi.set(__self__, "s3_uri", s3_uri)
        if tuning_data_s3_uri is not None:
            pulumi.set(__self__, "tuning_data_s3_uri", tuning_data_s3_uri)

    @_builtins.property
    @pulumi.getter(name="dataAccessRoleArn")
    def data_access_role_arn(self) -> _builtins.str:
        """
        IAM role with access to S3 bucket.
        """
        return pulumi.get(self, "data_access_role_arn")

    @_builtins.property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> _builtins.str:
        """
        S3 URI where training data is located.
        """
        return pulumi.get(self, "s3_uri")

    @_builtins.property
    @pulumi.getter(name="tuningDataS3Uri")
    def tuning_data_s3_uri(self) -> Optional[_builtins.str]:
        """
        S3 URI where tuning data is located.

        The following arguments are optional:
        """
        return pulumi.get(self, "tuning_data_s3_uri")


