# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['HostKeyArgs', 'HostKey']

@pulumi.input_type
class HostKeyArgs:
    def __init__(__self__, *,
                 server_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 host_key_body: Optional[pulumi.Input[_builtins.str]] = None,
                 host_key_body_wo: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a HostKey resource.
        :param pulumi.Input[_builtins.str] server_id: Server ID.
        :param pulumi.Input[_builtins.str] description: Text description.
        :param pulumi.Input[_builtins.str] host_key_body: Private key portion of an SSH key pair.
        :param pulumi.Input[_builtins.str] host_key_body_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-only private key portion of an SSH key pair, guaranteed not to be written to plan or state artifacts. One of `host_key_body` or `host_key_body_wo` must be configured.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "server_id", server_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if host_key_body is not None:
            pulumi.set(__self__, "host_key_body", host_key_body)
        if host_key_body_wo is not None:
            pulumi.set(__self__, "host_key_body_wo", host_key_body_wo)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> pulumi.Input[_builtins.str]:
        """
        Server ID.
        """
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "server_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Text description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="hostKeyBody")
    def host_key_body(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Private key portion of an SSH key pair.
        """
        return pulumi.get(self, "host_key_body")

    @host_key_body.setter
    def host_key_body(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_key_body", value)

    @_builtins.property
    @pulumi.getter(name="hostKeyBodyWo")
    def host_key_body_wo(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        Write-only private key portion of an SSH key pair, guaranteed not to be written to plan or state artifacts. One of `host_key_body` or `host_key_body_wo` must be configured.
        """
        return pulumi.get(self, "host_key_body_wo")

    @host_key_body_wo.setter
    def host_key_body_wo(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_key_body_wo", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _HostKeyState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 host_key_body: Optional[pulumi.Input[_builtins.str]] = None,
                 host_key_body_wo: Optional[pulumi.Input[_builtins.str]] = None,
                 host_key_fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 host_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering HostKey resources.
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name (ARN) of host key.
        :param pulumi.Input[_builtins.str] description: Text description.
        :param pulumi.Input[_builtins.str] host_key_body: Private key portion of an SSH key pair.
        :param pulumi.Input[_builtins.str] host_key_body_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-only private key portion of an SSH key pair, guaranteed not to be written to plan or state artifacts. One of `host_key_body` or `host_key_body_wo` must be configured.
        :param pulumi.Input[_builtins.str] host_key_fingerprint: Public key fingerprint.
        :param pulumi.Input[_builtins.str] host_key_id: ID of the host key.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] server_id: Server ID.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if host_key_body is not None:
            pulumi.set(__self__, "host_key_body", host_key_body)
        if host_key_body_wo is not None:
            pulumi.set(__self__, "host_key_body_wo", host_key_body_wo)
        if host_key_fingerprint is not None:
            pulumi.set(__self__, "host_key_fingerprint", host_key_fingerprint)
        if host_key_id is not None:
            pulumi.set(__self__, "host_key_id", host_key_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if server_id is not None:
            pulumi.set(__self__, "server_id", server_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon Resource Name (ARN) of host key.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Text description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="hostKeyBody")
    def host_key_body(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Private key portion of an SSH key pair.
        """
        return pulumi.get(self, "host_key_body")

    @host_key_body.setter
    def host_key_body(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_key_body", value)

    @_builtins.property
    @pulumi.getter(name="hostKeyBodyWo")
    def host_key_body_wo(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        Write-only private key portion of an SSH key pair, guaranteed not to be written to plan or state artifacts. One of `host_key_body` or `host_key_body_wo` must be configured.
        """
        return pulumi.get(self, "host_key_body_wo")

    @host_key_body_wo.setter
    def host_key_body_wo(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_key_body_wo", value)

    @_builtins.property
    @pulumi.getter(name="hostKeyFingerprint")
    def host_key_fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Public key fingerprint.
        """
        return pulumi.get(self, "host_key_fingerprint")

    @host_key_fingerprint.setter
    def host_key_fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_key_fingerprint", value)

    @_builtins.property
    @pulumi.getter(name="hostKeyId")
    def host_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the host key.
        """
        return pulumi.get(self, "host_key_id")

    @host_key_id.setter
    def host_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_key_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Server ID.
        """
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:transfer/hostKey:HostKey")
class HostKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 host_key_body: Optional[pulumi.Input[_builtins.str]] = None,
                 host_key_body_wo: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a host key for a server. This is an [_additional server host key_](https://docs.aws.amazon.com/transfer/latest/userguide/server-host-key-add.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.transfer.HostKey("example",
            server_id=example_aws_transfer_server["id"],
            description="example additional host key",
            host_key_body_wo="# Private key PEM.\\n")
        ```

        ## Import

        Using `pulumi import`, import host keys using the `server_id` and `host_key_id` separated by `,`. For example:

        ```sh
        $ pulumi import aws:transfer/hostKey:HostKey example s-12345678,key-12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Text description.
        :param pulumi.Input[_builtins.str] host_key_body: Private key portion of an SSH key pair.
        :param pulumi.Input[_builtins.str] host_key_body_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-only private key portion of an SSH key pair, guaranteed not to be written to plan or state artifacts. One of `host_key_body` or `host_key_body_wo` must be configured.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] server_id: Server ID.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HostKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a host key for a server. This is an [_additional server host key_](https://docs.aws.amazon.com/transfer/latest/userguide/server-host-key-add.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.transfer.HostKey("example",
            server_id=example_aws_transfer_server["id"],
            description="example additional host key",
            host_key_body_wo="# Private key PEM.\\n")
        ```

        ## Import

        Using `pulumi import`, import host keys using the `server_id` and `host_key_id` separated by `,`. For example:

        ```sh
        $ pulumi import aws:transfer/hostKey:HostKey example s-12345678,key-12345
        ```

        :param str resource_name: The name of the resource.
        :param HostKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HostKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 host_key_body: Optional[pulumi.Input[_builtins.str]] = None,
                 host_key_body_wo: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HostKeyArgs.__new__(HostKeyArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["host_key_body"] = None if host_key_body is None else pulumi.Output.secret(host_key_body)
            __props__.__dict__["host_key_body_wo"] = None if host_key_body_wo is None else pulumi.Output.secret(host_key_body_wo)
            __props__.__dict__["region"] = region
            if server_id is None and not opts.urn:
                raise TypeError("Missing required property 'server_id'")
            __props__.__dict__["server_id"] = server_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["host_key_fingerprint"] = None
            __props__.__dict__["host_key_id"] = None
            __props__.__dict__["tags_all"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["hostKeyBody", "hostKeyBodyWo"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(HostKey, __self__).__init__(
            'aws:transfer/hostKey:HostKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            host_key_body: Optional[pulumi.Input[_builtins.str]] = None,
            host_key_body_wo: Optional[pulumi.Input[_builtins.str]] = None,
            host_key_fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
            host_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            server_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'HostKey':
        """
        Get an existing HostKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name (ARN) of host key.
        :param pulumi.Input[_builtins.str] description: Text description.
        :param pulumi.Input[_builtins.str] host_key_body: Private key portion of an SSH key pair.
        :param pulumi.Input[_builtins.str] host_key_body_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-only private key portion of an SSH key pair, guaranteed not to be written to plan or state artifacts. One of `host_key_body` or `host_key_body_wo` must be configured.
        :param pulumi.Input[_builtins.str] host_key_fingerprint: Public key fingerprint.
        :param pulumi.Input[_builtins.str] host_key_id: ID of the host key.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] server_id: Server ID.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HostKeyState.__new__(_HostKeyState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["description"] = description
        __props__.__dict__["host_key_body"] = host_key_body
        __props__.__dict__["host_key_body_wo"] = host_key_body_wo
        __props__.__dict__["host_key_fingerprint"] = host_key_fingerprint
        __props__.__dict__["host_key_id"] = host_key_id
        __props__.__dict__["region"] = region
        __props__.__dict__["server_id"] = server_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return HostKey(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        Amazon Resource Name (ARN) of host key.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Text description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="hostKeyBody")
    def host_key_body(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Private key portion of an SSH key pair.
        """
        return pulumi.get(self, "host_key_body")

    @_builtins.property
    @pulumi.getter(name="hostKeyBodyWo")
    def host_key_body_wo(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        Write-only private key portion of an SSH key pair, guaranteed not to be written to plan or state artifacts. One of `host_key_body` or `host_key_body_wo` must be configured.
        """
        return pulumi.get(self, "host_key_body_wo")

    @_builtins.property
    @pulumi.getter(name="hostKeyFingerprint")
    def host_key_fingerprint(self) -> pulumi.Output[_builtins.str]:
        """
        Public key fingerprint.
        """
        return pulumi.get(self, "host_key_fingerprint")

    @_builtins.property
    @pulumi.getter(name="hostKeyId")
    def host_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the host key.
        """
        return pulumi.get(self, "host_key_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> pulumi.Output[_builtins.str]:
        """
        Server ID.
        """
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

