# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WebAppArgs', 'WebApp']

@pulumi.input_type
class WebAppArgs:
    def __init__(__self__, *,
                 access_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_provider_details: Optional[pulumi.Input['WebAppIdentityProviderDetailsArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 web_app_endpoint_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 web_app_units: Optional[pulumi.Input[Sequence[pulumi.Input['WebAppWebAppUnitArgs']]]] = None):
        """
        The set of arguments for constructing a WebApp resource.
        :param pulumi.Input[_builtins.str] access_endpoint: URL provided to interact with the Transfer Family web app.
        :param pulumi.Input['WebAppIdentityProviderDetailsArgs'] identity_provider_details: Block for details of the identity provider to use with the web app. See Identity provider details below.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value pairs that can be used to group and search for web apps.
        :param pulumi.Input[_builtins.str] web_app_endpoint_policy: Type of endpoint policy for the web app. Valid values are: `STANDARD`(default) or `FIPS`.
        :param pulumi.Input[Sequence[pulumi.Input['WebAppWebAppUnitArgs']]] web_app_units: Block for number of concurrent connections or the user sessions on the web app.
               * provisioned - (Optional) Number of units of concurrent connections.
        """
        if access_endpoint is not None:
            pulumi.set(__self__, "access_endpoint", access_endpoint)
        if identity_provider_details is not None:
            pulumi.set(__self__, "identity_provider_details", identity_provider_details)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if web_app_endpoint_policy is not None:
            pulumi.set(__self__, "web_app_endpoint_policy", web_app_endpoint_policy)
        if web_app_units is not None:
            pulumi.set(__self__, "web_app_units", web_app_units)

    @_builtins.property
    @pulumi.getter(name="accessEndpoint")
    def access_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL provided to interact with the Transfer Family web app.
        """
        return pulumi.get(self, "access_endpoint")

    @access_endpoint.setter
    def access_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="identityProviderDetails")
    def identity_provider_details(self) -> Optional[pulumi.Input['WebAppIdentityProviderDetailsArgs']]:
        """
        Block for details of the identity provider to use with the web app. See Identity provider details below.

        The following arguments are optional:
        """
        return pulumi.get(self, "identity_provider_details")

    @identity_provider_details.setter
    def identity_provider_details(self, value: Optional[pulumi.Input['WebAppIdentityProviderDetailsArgs']]):
        pulumi.set(self, "identity_provider_details", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value pairs that can be used to group and search for web apps.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="webAppEndpointPolicy")
    def web_app_endpoint_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of endpoint policy for the web app. Valid values are: `STANDARD`(default) or `FIPS`.
        """
        return pulumi.get(self, "web_app_endpoint_policy")

    @web_app_endpoint_policy.setter
    def web_app_endpoint_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "web_app_endpoint_policy", value)

    @_builtins.property
    @pulumi.getter(name="webAppUnits")
    def web_app_units(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WebAppWebAppUnitArgs']]]]:
        """
        Block for number of concurrent connections or the user sessions on the web app.
        * provisioned - (Optional) Number of units of concurrent connections.
        """
        return pulumi.get(self, "web_app_units")

    @web_app_units.setter
    def web_app_units(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WebAppWebAppUnitArgs']]]]):
        pulumi.set(self, "web_app_units", value)


@pulumi.input_type
class _WebAppState:
    def __init__(__self__, *,
                 access_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_provider_details: Optional[pulumi.Input['WebAppIdentityProviderDetailsArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 web_app_endpoint_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 web_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 web_app_units: Optional[pulumi.Input[Sequence[pulumi.Input['WebAppWebAppUnitArgs']]]] = None):
        """
        Input properties used for looking up and filtering WebApp resources.
        :param pulumi.Input[_builtins.str] access_endpoint: URL provided to interact with the Transfer Family web app.
        :param pulumi.Input[_builtins.str] arn: ARN of the Web App.
        :param pulumi.Input['WebAppIdentityProviderDetailsArgs'] identity_provider_details: Block for details of the identity provider to use with the web app. See Identity provider details below.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value pairs that can be used to group and search for web apps.
        :param pulumi.Input[_builtins.str] web_app_endpoint_policy: Type of endpoint policy for the web app. Valid values are: `STANDARD`(default) or `FIPS`.
        :param pulumi.Input[_builtins.str] web_app_id: ID of the Wep App resource.
        :param pulumi.Input[Sequence[pulumi.Input['WebAppWebAppUnitArgs']]] web_app_units: Block for number of concurrent connections or the user sessions on the web app.
               * provisioned - (Optional) Number of units of concurrent connections.
        """
        if access_endpoint is not None:
            pulumi.set(__self__, "access_endpoint", access_endpoint)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if identity_provider_details is not None:
            pulumi.set(__self__, "identity_provider_details", identity_provider_details)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if web_app_endpoint_policy is not None:
            pulumi.set(__self__, "web_app_endpoint_policy", web_app_endpoint_policy)
        if web_app_id is not None:
            pulumi.set(__self__, "web_app_id", web_app_id)
        if web_app_units is not None:
            pulumi.set(__self__, "web_app_units", web_app_units)

    @_builtins.property
    @pulumi.getter(name="accessEndpoint")
    def access_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL provided to interact with the Transfer Family web app.
        """
        return pulumi.get(self, "access_endpoint")

    @access_endpoint.setter
    def access_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the Web App.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="identityProviderDetails")
    def identity_provider_details(self) -> Optional[pulumi.Input['WebAppIdentityProviderDetailsArgs']]:
        """
        Block for details of the identity provider to use with the web app. See Identity provider details below.

        The following arguments are optional:
        """
        return pulumi.get(self, "identity_provider_details")

    @identity_provider_details.setter
    def identity_provider_details(self, value: Optional[pulumi.Input['WebAppIdentityProviderDetailsArgs']]):
        pulumi.set(self, "identity_provider_details", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value pairs that can be used to group and search for web apps.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="webAppEndpointPolicy")
    def web_app_endpoint_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of endpoint policy for the web app. Valid values are: `STANDARD`(default) or `FIPS`.
        """
        return pulumi.get(self, "web_app_endpoint_policy")

    @web_app_endpoint_policy.setter
    def web_app_endpoint_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "web_app_endpoint_policy", value)

    @_builtins.property
    @pulumi.getter(name="webAppId")
    def web_app_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the Wep App resource.
        """
        return pulumi.get(self, "web_app_id")

    @web_app_id.setter
    def web_app_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "web_app_id", value)

    @_builtins.property
    @pulumi.getter(name="webAppUnits")
    def web_app_units(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WebAppWebAppUnitArgs']]]]:
        """
        Block for number of concurrent connections or the user sessions on the web app.
        * provisioned - (Optional) Number of units of concurrent connections.
        """
        return pulumi.get(self, "web_app_units")

    @web_app_units.setter
    def web_app_units(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WebAppWebAppUnitArgs']]]]):
        pulumi.set(self, "web_app_units", value)


@pulumi.type_token("aws:transfer/webApp:WebApp")
class WebApp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_provider_details: Optional[pulumi.Input[Union['WebAppIdentityProviderDetailsArgs', 'WebAppIdentityProviderDetailsArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 web_app_endpoint_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 web_app_units: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WebAppWebAppUnitArgs', 'WebAppWebAppUnitArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Transfer Family Web App.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        current_get_region = aws.get_region()
        current_get_partition = aws.get_partition()
        example = aws.ssoadmin.get_instances()
        assume_role_transfer = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "actions": [
                "sts:AssumeRole",
                "sts:SetContext",
            ],
            "principals": [{
                "type": "Service",
                "identifiers": ["transfer.amazonaws.com"],
            }],
            "conditions": [{
                "test": "StringEquals",
                "values": [current.account_id],
                "variable": "aws:SourceAccount",
            }],
        }])
        example_role = aws.iam.Role("example",
            name="example",
            assume_role_policy=assume_role_transfer.json)
        example_get_policy_document = aws.iam.get_policy_document(statements=[
            {
                "effect": "Allow",
                "actions": [
                    "s3:GetDataAccess",
                    "s3:ListCallerAccessGrants",
                ],
                "resources": [f"arn:{current_get_partition.partition}:s3:{current_get_region.name}:{current.account_id}:access-grants/*"],
                "conditions": [{
                    "test": "StringEquals",
                    "values": [current.account_id],
                    "variable": "s3:ResourceAccount",
                }],
            },
            {
                "effect": "Allow",
                "actions": ["s3:ListAccessGrantsInstances"],
                "resources": ["*"],
                "conditions": [{
                    "test": "StringEquals",
                    "values": [current.account_id],
                    "variable": "s3:ResourceAccount",
                }],
            },
        ])
        example_role_policy = aws.iam.RolePolicy("example",
            policy=example_get_policy_document.json,
            role=example_role.name)
        example_web_app = aws.transfer.WebApp("example",
            identity_provider_details={
                "identity_center_config": {
                    "instance_arn": example.arns[0],
                    "role": example_role.arn,
                },
            },
            web_app_units=[{
                "provisioned": 1,
            }],
            tags={
                "Name": "test",
            })
        ```

        ## Import

        Using `pulumi import`, import Transfer Family Web App using the `web_app_id`. For example:

        ```sh
        $ pulumi import aws:transfer/webApp:WebApp example web_app-id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_endpoint: URL provided to interact with the Transfer Family web app.
        :param pulumi.Input[Union['WebAppIdentityProviderDetailsArgs', 'WebAppIdentityProviderDetailsArgsDict']] identity_provider_details: Block for details of the identity provider to use with the web app. See Identity provider details below.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value pairs that can be used to group and search for web apps.
        :param pulumi.Input[_builtins.str] web_app_endpoint_policy: Type of endpoint policy for the web app. Valid values are: `STANDARD`(default) or `FIPS`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WebAppWebAppUnitArgs', 'WebAppWebAppUnitArgsDict']]]] web_app_units: Block for number of concurrent connections or the user sessions on the web app.
               * provisioned - (Optional) Number of units of concurrent connections.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[WebAppArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Transfer Family Web App.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        current_get_region = aws.get_region()
        current_get_partition = aws.get_partition()
        example = aws.ssoadmin.get_instances()
        assume_role_transfer = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "actions": [
                "sts:AssumeRole",
                "sts:SetContext",
            ],
            "principals": [{
                "type": "Service",
                "identifiers": ["transfer.amazonaws.com"],
            }],
            "conditions": [{
                "test": "StringEquals",
                "values": [current.account_id],
                "variable": "aws:SourceAccount",
            }],
        }])
        example_role = aws.iam.Role("example",
            name="example",
            assume_role_policy=assume_role_transfer.json)
        example_get_policy_document = aws.iam.get_policy_document(statements=[
            {
                "effect": "Allow",
                "actions": [
                    "s3:GetDataAccess",
                    "s3:ListCallerAccessGrants",
                ],
                "resources": [f"arn:{current_get_partition.partition}:s3:{current_get_region.name}:{current.account_id}:access-grants/*"],
                "conditions": [{
                    "test": "StringEquals",
                    "values": [current.account_id],
                    "variable": "s3:ResourceAccount",
                }],
            },
            {
                "effect": "Allow",
                "actions": ["s3:ListAccessGrantsInstances"],
                "resources": ["*"],
                "conditions": [{
                    "test": "StringEquals",
                    "values": [current.account_id],
                    "variable": "s3:ResourceAccount",
                }],
            },
        ])
        example_role_policy = aws.iam.RolePolicy("example",
            policy=example_get_policy_document.json,
            role=example_role.name)
        example_web_app = aws.transfer.WebApp("example",
            identity_provider_details={
                "identity_center_config": {
                    "instance_arn": example.arns[0],
                    "role": example_role.arn,
                },
            },
            web_app_units=[{
                "provisioned": 1,
            }],
            tags={
                "Name": "test",
            })
        ```

        ## Import

        Using `pulumi import`, import Transfer Family Web App using the `web_app_id`. For example:

        ```sh
        $ pulumi import aws:transfer/webApp:WebApp example web_app-id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param WebAppArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WebAppArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_provider_details: Optional[pulumi.Input[Union['WebAppIdentityProviderDetailsArgs', 'WebAppIdentityProviderDetailsArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 web_app_endpoint_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 web_app_units: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WebAppWebAppUnitArgs', 'WebAppWebAppUnitArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WebAppArgs.__new__(WebAppArgs)

            __props__.__dict__["access_endpoint"] = access_endpoint
            __props__.__dict__["identity_provider_details"] = identity_provider_details
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["web_app_endpoint_policy"] = web_app_endpoint_policy
            __props__.__dict__["web_app_units"] = web_app_units
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["web_app_id"] = None
        super(WebApp, __self__).__init__(
            'aws:transfer/webApp:WebApp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            identity_provider_details: Optional[pulumi.Input[Union['WebAppIdentityProviderDetailsArgs', 'WebAppIdentityProviderDetailsArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            web_app_endpoint_policy: Optional[pulumi.Input[_builtins.str]] = None,
            web_app_id: Optional[pulumi.Input[_builtins.str]] = None,
            web_app_units: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WebAppWebAppUnitArgs', 'WebAppWebAppUnitArgsDict']]]]] = None) -> 'WebApp':
        """
        Get an existing WebApp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_endpoint: URL provided to interact with the Transfer Family web app.
        :param pulumi.Input[_builtins.str] arn: ARN of the Web App.
        :param pulumi.Input[Union['WebAppIdentityProviderDetailsArgs', 'WebAppIdentityProviderDetailsArgsDict']] identity_provider_details: Block for details of the identity provider to use with the web app. See Identity provider details below.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value pairs that can be used to group and search for web apps.
        :param pulumi.Input[_builtins.str] web_app_endpoint_policy: Type of endpoint policy for the web app. Valid values are: `STANDARD`(default) or `FIPS`.
        :param pulumi.Input[_builtins.str] web_app_id: ID of the Wep App resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WebAppWebAppUnitArgs', 'WebAppWebAppUnitArgsDict']]]] web_app_units: Block for number of concurrent connections or the user sessions on the web app.
               * provisioned - (Optional) Number of units of concurrent connections.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WebAppState.__new__(_WebAppState)

        __props__.__dict__["access_endpoint"] = access_endpoint
        __props__.__dict__["arn"] = arn
        __props__.__dict__["identity_provider_details"] = identity_provider_details
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["web_app_endpoint_policy"] = web_app_endpoint_policy
        __props__.__dict__["web_app_id"] = web_app_id
        __props__.__dict__["web_app_units"] = web_app_units
        return WebApp(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessEndpoint")
    def access_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        URL provided to interact with the Transfer Family web app.
        """
        return pulumi.get(self, "access_endpoint")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the Web App.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="identityProviderDetails")
    def identity_provider_details(self) -> pulumi.Output[Optional['outputs.WebAppIdentityProviderDetails']]:
        """
        Block for details of the identity provider to use with the web app. See Identity provider details below.

        The following arguments are optional:
        """
        return pulumi.get(self, "identity_provider_details")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value pairs that can be used to group and search for web apps.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="webAppEndpointPolicy")
    def web_app_endpoint_policy(self) -> pulumi.Output[_builtins.str]:
        """
        Type of endpoint policy for the web app. Valid values are: `STANDARD`(default) or `FIPS`.
        """
        return pulumi.get(self, "web_app_endpoint_policy")

    @_builtins.property
    @pulumi.getter(name="webAppId")
    def web_app_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the Wep App resource.
        """
        return pulumi.get(self, "web_app_id")

    @_builtins.property
    @pulumi.getter(name="webAppUnits")
    def web_app_units(self) -> pulumi.Output[Sequence['outputs.WebAppWebAppUnit']]:
        """
        Block for number of concurrent connections or the user sessions on the web app.
        * provisioned - (Optional) Number of units of concurrent connections.
        """
        return pulumi.get(self, "web_app_units")

