# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WebAppCustomizationArgs', 'WebAppCustomization']

@pulumi.input_type
class WebAppCustomizationArgs:
    def __init__(__self__, *,
                 web_app_id: pulumi.Input[_builtins.str],
                 favicon_file: Optional[pulumi.Input[_builtins.str]] = None,
                 logo_file: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WebAppCustomization resource.
        :param pulumi.Input[_builtins.str] web_app_id: The identifier of the web app to be customized.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] title: Title of the web app. Must be between 1 and 100 characters in length (an empty string is not allowed). To remove the title, omit this argument from your configuration.
        """
        pulumi.set(__self__, "web_app_id", web_app_id)
        if favicon_file is not None:
            pulumi.set(__self__, "favicon_file", favicon_file)
        if logo_file is not None:
            pulumi.set(__self__, "logo_file", logo_file)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @_builtins.property
    @pulumi.getter(name="webAppId")
    def web_app_id(self) -> pulumi.Input[_builtins.str]:
        """
        The identifier of the web app to be customized.

        The following arguments are optional:
        """
        return pulumi.get(self, "web_app_id")

    @web_app_id.setter
    def web_app_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "web_app_id", value)

    @_builtins.property
    @pulumi.getter(name="faviconFile")
    def favicon_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "favicon_file")

    @favicon_file.setter
    def favicon_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "favicon_file", value)

    @_builtins.property
    @pulumi.getter(name="logoFile")
    def logo_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "logo_file")

    @logo_file.setter
    def logo_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logo_file", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Title of the web app. Must be between 1 and 100 characters in length (an empty string is not allowed). To remove the title, omit this argument from your configuration.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class _WebAppCustomizationState:
    def __init__(__self__, *,
                 favicon_file: Optional[pulumi.Input[_builtins.str]] = None,
                 logo_file: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None,
                 web_app_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WebAppCustomization resources.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] title: Title of the web app. Must be between 1 and 100 characters in length (an empty string is not allowed). To remove the title, omit this argument from your configuration.
        :param pulumi.Input[_builtins.str] web_app_id: The identifier of the web app to be customized.
               
               The following arguments are optional:
        """
        if favicon_file is not None:
            pulumi.set(__self__, "favicon_file", favicon_file)
        if logo_file is not None:
            pulumi.set(__self__, "logo_file", logo_file)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if web_app_id is not None:
            pulumi.set(__self__, "web_app_id", web_app_id)

    @_builtins.property
    @pulumi.getter(name="faviconFile")
    def favicon_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "favicon_file")

    @favicon_file.setter
    def favicon_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "favicon_file", value)

    @_builtins.property
    @pulumi.getter(name="logoFile")
    def logo_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "logo_file")

    @logo_file.setter
    def logo_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logo_file", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Title of the web app. Must be between 1 and 100 characters in length (an empty string is not allowed). To remove the title, omit this argument from your configuration.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "title", value)

    @_builtins.property
    @pulumi.getter(name="webAppId")
    def web_app_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier of the web app to be customized.

        The following arguments are optional:
        """
        return pulumi.get(self, "web_app_id")

    @web_app_id.setter
    def web_app_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "web_app_id", value)


@pulumi.type_token("aws:transfer/webAppCustomization:WebAppCustomization")
class WebAppCustomization(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 favicon_file: Optional[pulumi.Input[_builtins.str]] = None,
                 logo_file: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None,
                 web_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Transfer Family Web App Customization.

        ## Example Usage

        ## Import

        Using `pulumi import`, import Transfer Family Web App Customization using the `web_app_id`. For example:

        ```sh
        $ pulumi import aws:transfer/webAppCustomization:WebAppCustomization example webapp-12345678901234567890
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] title: Title of the web app. Must be between 1 and 100 characters in length (an empty string is not allowed). To remove the title, omit this argument from your configuration.
        :param pulumi.Input[_builtins.str] web_app_id: The identifier of the web app to be customized.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WebAppCustomizationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Transfer Family Web App Customization.

        ## Example Usage

        ## Import

        Using `pulumi import`, import Transfer Family Web App Customization using the `web_app_id`. For example:

        ```sh
        $ pulumi import aws:transfer/webAppCustomization:WebAppCustomization example webapp-12345678901234567890
        ```

        :param str resource_name: The name of the resource.
        :param WebAppCustomizationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WebAppCustomizationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 favicon_file: Optional[pulumi.Input[_builtins.str]] = None,
                 logo_file: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None,
                 web_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WebAppCustomizationArgs.__new__(WebAppCustomizationArgs)

            __props__.__dict__["favicon_file"] = favicon_file
            __props__.__dict__["logo_file"] = logo_file
            __props__.__dict__["region"] = region
            __props__.__dict__["title"] = title
            if web_app_id is None and not opts.urn:
                raise TypeError("Missing required property 'web_app_id'")
            __props__.__dict__["web_app_id"] = web_app_id
        super(WebAppCustomization, __self__).__init__(
            'aws:transfer/webAppCustomization:WebAppCustomization',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            favicon_file: Optional[pulumi.Input[_builtins.str]] = None,
            logo_file: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            title: Optional[pulumi.Input[_builtins.str]] = None,
            web_app_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'WebAppCustomization':
        """
        Get an existing WebAppCustomization resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] title: Title of the web app. Must be between 1 and 100 characters in length (an empty string is not allowed). To remove the title, omit this argument from your configuration.
        :param pulumi.Input[_builtins.str] web_app_id: The identifier of the web app to be customized.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WebAppCustomizationState.__new__(_WebAppCustomizationState)

        __props__.__dict__["favicon_file"] = favicon_file
        __props__.__dict__["logo_file"] = logo_file
        __props__.__dict__["region"] = region
        __props__.__dict__["title"] = title
        __props__.__dict__["web_app_id"] = web_app_id
        return WebAppCustomization(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="faviconFile")
    def favicon_file(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "favicon_file")

    @_builtins.property
    @pulumi.getter(name="logoFile")
    def logo_file(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "logo_file")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def title(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Title of the web app. Must be between 1 and 100 characters in length (an empty string is not allowed). To remove the title, omit this argument from your configuration.
        """
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter(name="webAppId")
    def web_app_id(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier of the web app to be customized.

        The following arguments are optional:
        """
        return pulumi.get(self, "web_app_id")

