# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'IdentitySourceConfiguration',
    'IdentitySourceConfigurationCognitoUserPoolConfiguration',
    'IdentitySourceConfigurationCognitoUserPoolConfigurationGroupConfiguration',
    'IdentitySourceConfigurationOpenIdConnectConfiguration',
    'IdentitySourceConfigurationOpenIdConnectConfigurationGroupConfiguration',
    'IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelection',
    'IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionAccessTokenOnly',
    'IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionIdentityTokenOnly',
    'PolicyDefinition',
    'PolicyDefinitionStatic',
    'PolicyDefinitionTemplateLinked',
    'PolicyDefinitionTemplateLinkedPrincipal',
    'PolicyDefinitionTemplateLinkedResource',
    'PolicyStoreValidationSettings',
    'SchemaDefinition',
    'GetPolicyStoreValidationSettingResult',
]

@pulumi.output_type
class IdentitySourceConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cognitoUserPoolConfiguration":
            suggest = "cognito_user_pool_configuration"
        elif key == "openIdConnectConfiguration":
            suggest = "open_id_connect_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentitySourceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentitySourceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentitySourceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cognito_user_pool_configuration: Optional['outputs.IdentitySourceConfigurationCognitoUserPoolConfiguration'] = None,
                 open_id_connect_configuration: Optional['outputs.IdentitySourceConfigurationOpenIdConnectConfiguration'] = None):
        """
        :param 'IdentitySourceConfigurationCognitoUserPoolConfigurationArgs' cognito_user_pool_configuration: Specifies the configuration details of an Amazon Cognito user pool that Verified Permissions can use as a source of authenticated identities as entities. See Cognito User Pool Configuration below.
        :param 'IdentitySourceConfigurationOpenIdConnectConfigurationArgs' open_id_connect_configuration: Specifies the configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that Verified Permissions can use to generate entities from authenticated identities. See Open ID Connect Configuration below.
        """
        if cognito_user_pool_configuration is not None:
            pulumi.set(__self__, "cognito_user_pool_configuration", cognito_user_pool_configuration)
        if open_id_connect_configuration is not None:
            pulumi.set(__self__, "open_id_connect_configuration", open_id_connect_configuration)

    @_builtins.property
    @pulumi.getter(name="cognitoUserPoolConfiguration")
    def cognito_user_pool_configuration(self) -> Optional['outputs.IdentitySourceConfigurationCognitoUserPoolConfiguration']:
        """
        Specifies the configuration details of an Amazon Cognito user pool that Verified Permissions can use as a source of authenticated identities as entities. See Cognito User Pool Configuration below.
        """
        return pulumi.get(self, "cognito_user_pool_configuration")

    @_builtins.property
    @pulumi.getter(name="openIdConnectConfiguration")
    def open_id_connect_configuration(self) -> Optional['outputs.IdentitySourceConfigurationOpenIdConnectConfiguration']:
        """
        Specifies the configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that Verified Permissions can use to generate entities from authenticated identities. See Open ID Connect Configuration below.
        """
        return pulumi.get(self, "open_id_connect_configuration")


@pulumi.output_type
class IdentitySourceConfigurationCognitoUserPoolConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userPoolArn":
            suggest = "user_pool_arn"
        elif key == "clientIds":
            suggest = "client_ids"
        elif key == "groupConfiguration":
            suggest = "group_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentitySourceConfigurationCognitoUserPoolConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentitySourceConfigurationCognitoUserPoolConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentitySourceConfigurationCognitoUserPoolConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_pool_arn: _builtins.str,
                 client_ids: Optional[Sequence[_builtins.str]] = None,
                 group_configuration: Optional['outputs.IdentitySourceConfigurationCognitoUserPoolConfigurationGroupConfiguration'] = None):
        """
        :param _builtins.str user_pool_arn: The Amazon Resource Name (ARN) of the Amazon Cognito user pool that contains the identities to be authorized.
        :param Sequence[_builtins.str] client_ids: The unique application client IDs that are associated with the specified Amazon Cognito user pool.
        :param 'IdentitySourceConfigurationCognitoUserPoolConfigurationGroupConfigurationArgs' group_configuration: The type of entity that a policy store maps to groups from an Amazon Cognito user pool identity source. See Group Configuration below.
        """
        pulumi.set(__self__, "user_pool_arn", user_pool_arn)
        if client_ids is not None:
            pulumi.set(__self__, "client_ids", client_ids)
        if group_configuration is not None:
            pulumi.set(__self__, "group_configuration", group_configuration)

    @_builtins.property
    @pulumi.getter(name="userPoolArn")
    def user_pool_arn(self) -> _builtins.str:
        """
        The Amazon Resource Name (ARN) of the Amazon Cognito user pool that contains the identities to be authorized.
        """
        return pulumi.get(self, "user_pool_arn")

    @_builtins.property
    @pulumi.getter(name="clientIds")
    def client_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        The unique application client IDs that are associated with the specified Amazon Cognito user pool.
        """
        return pulumi.get(self, "client_ids")

    @_builtins.property
    @pulumi.getter(name="groupConfiguration")
    def group_configuration(self) -> Optional['outputs.IdentitySourceConfigurationCognitoUserPoolConfigurationGroupConfiguration']:
        """
        The type of entity that a policy store maps to groups from an Amazon Cognito user pool identity source. See Group Configuration below.
        """
        return pulumi.get(self, "group_configuration")


@pulumi.output_type
class IdentitySourceConfigurationCognitoUserPoolConfigurationGroupConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupEntityType":
            suggest = "group_entity_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentitySourceConfigurationCognitoUserPoolConfigurationGroupConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentitySourceConfigurationCognitoUserPoolConfigurationGroupConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentitySourceConfigurationCognitoUserPoolConfigurationGroupConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_entity_type: _builtins.str):
        """
        :param _builtins.str group_entity_type: The name of the schema entity type that's mapped to the user pool group. Defaults to `AWS::CognitoGroup`.
        """
        pulumi.set(__self__, "group_entity_type", group_entity_type)

    @_builtins.property
    @pulumi.getter(name="groupEntityType")
    def group_entity_type(self) -> _builtins.str:
        """
        The name of the schema entity type that's mapped to the user pool group. Defaults to `AWS::CognitoGroup`.
        """
        return pulumi.get(self, "group_entity_type")


@pulumi.output_type
class IdentitySourceConfigurationOpenIdConnectConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entityIdPrefix":
            suggest = "entity_id_prefix"
        elif key == "groupConfiguration":
            suggest = "group_configuration"
        elif key == "tokenSelection":
            suggest = "token_selection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentitySourceConfigurationOpenIdConnectConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentitySourceConfigurationOpenIdConnectConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentitySourceConfigurationOpenIdConnectConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 issuer: _builtins.str,
                 entity_id_prefix: Optional[_builtins.str] = None,
                 group_configuration: Optional['outputs.IdentitySourceConfigurationOpenIdConnectConfigurationGroupConfiguration'] = None,
                 token_selection: Optional['outputs.IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelection'] = None):
        """
        :param _builtins.str issuer: The issuer URL of an OIDC identity provider. This URL must have an OIDC discovery endpoint at the path `.well-known/openid-configuration`.
        :param _builtins.str entity_id_prefix: A descriptive string that you want to prefix to user entities from your OIDC identity provider.
        :param 'IdentitySourceConfigurationOpenIdConnectConfigurationGroupConfigurationArgs' group_configuration: The type of entity that a policy store maps to groups from an Amazon Cognito user pool identity source. See Group Configuration below.
        :param 'IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionArgs' token_selection: The token type that you want to process from your OIDC identity provider. Your policy store can process either identity (ID) or access tokens from a given OIDC identity source. See Token Selection below.
        """
        pulumi.set(__self__, "issuer", issuer)
        if entity_id_prefix is not None:
            pulumi.set(__self__, "entity_id_prefix", entity_id_prefix)
        if group_configuration is not None:
            pulumi.set(__self__, "group_configuration", group_configuration)
        if token_selection is not None:
            pulumi.set(__self__, "token_selection", token_selection)

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> _builtins.str:
        """
        The issuer URL of an OIDC identity provider. This URL must have an OIDC discovery endpoint at the path `.well-known/openid-configuration`.
        """
        return pulumi.get(self, "issuer")

    @_builtins.property
    @pulumi.getter(name="entityIdPrefix")
    def entity_id_prefix(self) -> Optional[_builtins.str]:
        """
        A descriptive string that you want to prefix to user entities from your OIDC identity provider.
        """
        return pulumi.get(self, "entity_id_prefix")

    @_builtins.property
    @pulumi.getter(name="groupConfiguration")
    def group_configuration(self) -> Optional['outputs.IdentitySourceConfigurationOpenIdConnectConfigurationGroupConfiguration']:
        """
        The type of entity that a policy store maps to groups from an Amazon Cognito user pool identity source. See Group Configuration below.
        """
        return pulumi.get(self, "group_configuration")

    @_builtins.property
    @pulumi.getter(name="tokenSelection")
    def token_selection(self) -> Optional['outputs.IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelection']:
        """
        The token type that you want to process from your OIDC identity provider. Your policy store can process either identity (ID) or access tokens from a given OIDC identity source. See Token Selection below.
        """
        return pulumi.get(self, "token_selection")


@pulumi.output_type
class IdentitySourceConfigurationOpenIdConnectConfigurationGroupConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupClaim":
            suggest = "group_claim"
        elif key == "groupEntityType":
            suggest = "group_entity_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentitySourceConfigurationOpenIdConnectConfigurationGroupConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentitySourceConfigurationOpenIdConnectConfigurationGroupConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentitySourceConfigurationOpenIdConnectConfigurationGroupConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_claim: _builtins.str,
                 group_entity_type: _builtins.str):
        """
        :param _builtins.str group_claim: The token claim that you want Verified Permissions to interpret as group membership. For example, `groups`.
        :param _builtins.str group_entity_type: The name of the schema entity type that's mapped to the user pool group. Defaults to `AWS::CognitoGroup`.
        """
        pulumi.set(__self__, "group_claim", group_claim)
        pulumi.set(__self__, "group_entity_type", group_entity_type)

    @_builtins.property
    @pulumi.getter(name="groupClaim")
    def group_claim(self) -> _builtins.str:
        """
        The token claim that you want Verified Permissions to interpret as group membership. For example, `groups`.
        """
        return pulumi.get(self, "group_claim")

    @_builtins.property
    @pulumi.getter(name="groupEntityType")
    def group_entity_type(self) -> _builtins.str:
        """
        The name of the schema entity type that's mapped to the user pool group. Defaults to `AWS::CognitoGroup`.
        """
        return pulumi.get(self, "group_entity_type")


@pulumi.output_type
class IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessTokenOnly":
            suggest = "access_token_only"
        elif key == "identityTokenOnly":
            suggest = "identity_token_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_token_only: Optional['outputs.IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionAccessTokenOnly'] = None,
                 identity_token_only: Optional['outputs.IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionIdentityTokenOnly'] = None):
        """
        :param 'IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionAccessTokenOnlyArgs' access_token_only: The OIDC configuration for processing access tokens. See Access Token Only below.
        :param 'IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionIdentityTokenOnlyArgs' identity_token_only: The OIDC configuration for processing identity (ID) tokens. See Identity Token Only below.
        """
        if access_token_only is not None:
            pulumi.set(__self__, "access_token_only", access_token_only)
        if identity_token_only is not None:
            pulumi.set(__self__, "identity_token_only", identity_token_only)

    @_builtins.property
    @pulumi.getter(name="accessTokenOnly")
    def access_token_only(self) -> Optional['outputs.IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionAccessTokenOnly']:
        """
        The OIDC configuration for processing access tokens. See Access Token Only below.
        """
        return pulumi.get(self, "access_token_only")

    @_builtins.property
    @pulumi.getter(name="identityTokenOnly")
    def identity_token_only(self) -> Optional['outputs.IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionIdentityTokenOnly']:
        """
        The OIDC configuration for processing identity (ID) tokens. See Identity Token Only below.
        """
        return pulumi.get(self, "identity_token_only")


@pulumi.output_type
class IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionAccessTokenOnly(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalIdClaim":
            suggest = "principal_id_claim"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionAccessTokenOnly. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionAccessTokenOnly.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionAccessTokenOnly.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audiences: Optional[Sequence[_builtins.str]] = None,
                 principal_id_claim: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] audiences: The access token aud claim values that you want to accept in your policy store.
        :param _builtins.str principal_id_claim: The claim that determines the principal in OIDC access tokens.
        """
        if audiences is not None:
            pulumi.set(__self__, "audiences", audiences)
        if principal_id_claim is not None:
            pulumi.set(__self__, "principal_id_claim", principal_id_claim)

    @_builtins.property
    @pulumi.getter
    def audiences(self) -> Optional[Sequence[_builtins.str]]:
        """
        The access token aud claim values that you want to accept in your policy store.
        """
        return pulumi.get(self, "audiences")

    @_builtins.property
    @pulumi.getter(name="principalIdClaim")
    def principal_id_claim(self) -> Optional[_builtins.str]:
        """
        The claim that determines the principal in OIDC access tokens.
        """
        return pulumi.get(self, "principal_id_claim")


@pulumi.output_type
class IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionIdentityTokenOnly(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientIds":
            suggest = "client_ids"
        elif key == "principalIdClaim":
            suggest = "principal_id_claim"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionIdentityTokenOnly. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionIdentityTokenOnly.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionIdentityTokenOnly.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id_claim: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] client_ids: The ID token audience, or client ID, claim values that you want to accept in your policy store from an OIDC identity provider.
        :param _builtins.str principal_id_claim: The claim that determines the principal in OIDC access tokens.
        """
        if client_ids is not None:
            pulumi.set(__self__, "client_ids", client_ids)
        if principal_id_claim is not None:
            pulumi.set(__self__, "principal_id_claim", principal_id_claim)

    @_builtins.property
    @pulumi.getter(name="clientIds")
    def client_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        The ID token audience, or client ID, claim values that you want to accept in your policy store from an OIDC identity provider.
        """
        return pulumi.get(self, "client_ids")

    @_builtins.property
    @pulumi.getter(name="principalIdClaim")
    def principal_id_claim(self) -> Optional[_builtins.str]:
        """
        The claim that determines the principal in OIDC access tokens.
        """
        return pulumi.get(self, "principal_id_claim")


@pulumi.output_type
class PolicyDefinition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "templateLinked":
            suggest = "template_linked"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 static: Optional['outputs.PolicyDefinitionStatic'] = None,
                 template_linked: Optional['outputs.PolicyDefinitionTemplateLinked'] = None):
        """
        :param 'PolicyDefinitionStaticArgs' static: The static policy statement. See Static below.
        :param 'PolicyDefinitionTemplateLinkedArgs' template_linked: The template linked policy. See Template Linked below.
        """
        if static is not None:
            pulumi.set(__self__, "static", static)
        if template_linked is not None:
            pulumi.set(__self__, "template_linked", template_linked)

    @_builtins.property
    @pulumi.getter
    def static(self) -> Optional['outputs.PolicyDefinitionStatic']:
        """
        The static policy statement. See Static below.
        """
        return pulumi.get(self, "static")

    @_builtins.property
    @pulumi.getter(name="templateLinked")
    def template_linked(self) -> Optional['outputs.PolicyDefinitionTemplateLinked']:
        """
        The template linked policy. See Template Linked below.
        """
        return pulumi.get(self, "template_linked")


@pulumi.output_type
class PolicyDefinitionStatic(dict):
    def __init__(__self__, *,
                 statement: _builtins.str,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str statement: The statement of the static policy.
        :param _builtins.str description: The description of the static policy.
        """
        pulumi.set(__self__, "statement", statement)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def statement(self) -> _builtins.str:
        """
        The statement of the static policy.
        """
        return pulumi.get(self, "statement")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        The description of the static policy.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class PolicyDefinitionTemplateLinked(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyTemplateId":
            suggest = "policy_template_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyDefinitionTemplateLinked. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyDefinitionTemplateLinked.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyDefinitionTemplateLinked.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy_template_id: _builtins.str,
                 principal: Optional['outputs.PolicyDefinitionTemplateLinkedPrincipal'] = None,
                 resource: Optional['outputs.PolicyDefinitionTemplateLinkedResource'] = None):
        """
        :param _builtins.str policy_template_id: The ID of the template.
        :param 'PolicyDefinitionTemplateLinkedPrincipalArgs' principal: The principal of the template linked policy.
        :param 'PolicyDefinitionTemplateLinkedResourceArgs' resource: The resource of the template linked policy.
        """
        pulumi.set(__self__, "policy_template_id", policy_template_id)
        if principal is not None:
            pulumi.set(__self__, "principal", principal)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)

    @_builtins.property
    @pulumi.getter(name="policyTemplateId")
    def policy_template_id(self) -> _builtins.str:
        """
        The ID of the template.
        """
        return pulumi.get(self, "policy_template_id")

    @_builtins.property
    @pulumi.getter
    def principal(self) -> Optional['outputs.PolicyDefinitionTemplateLinkedPrincipal']:
        """
        The principal of the template linked policy.
        """
        return pulumi.get(self, "principal")

    @_builtins.property
    @pulumi.getter
    def resource(self) -> Optional['outputs.PolicyDefinitionTemplateLinkedResource']:
        """
        The resource of the template linked policy.
        """
        return pulumi.get(self, "resource")


@pulumi.output_type
class PolicyDefinitionTemplateLinkedPrincipal(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entityId":
            suggest = "entity_id"
        elif key == "entityType":
            suggest = "entity_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyDefinitionTemplateLinkedPrincipal. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyDefinitionTemplateLinkedPrincipal.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyDefinitionTemplateLinkedPrincipal.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 entity_id: _builtins.str,
                 entity_type: _builtins.str):
        """
        :param _builtins.str entity_id: The entity ID of the principal.
        :param _builtins.str entity_type: The entity type of the principal.
        """
        pulumi.set(__self__, "entity_id", entity_id)
        pulumi.set(__self__, "entity_type", entity_type)

    @_builtins.property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> _builtins.str:
        """
        The entity ID of the principal.
        """
        return pulumi.get(self, "entity_id")

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> _builtins.str:
        """
        The entity type of the principal.
        """
        return pulumi.get(self, "entity_type")


@pulumi.output_type
class PolicyDefinitionTemplateLinkedResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entityId":
            suggest = "entity_id"
        elif key == "entityType":
            suggest = "entity_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyDefinitionTemplateLinkedResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyDefinitionTemplateLinkedResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyDefinitionTemplateLinkedResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 entity_id: _builtins.str,
                 entity_type: _builtins.str):
        """
        :param _builtins.str entity_id: The entity ID of the resource.
        :param _builtins.str entity_type: The entity type of the resource.
        """
        pulumi.set(__self__, "entity_id", entity_id)
        pulumi.set(__self__, "entity_type", entity_type)

    @_builtins.property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> _builtins.str:
        """
        The entity ID of the resource.
        """
        return pulumi.get(self, "entity_id")

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> _builtins.str:
        """
        The entity type of the resource.
        """
        return pulumi.get(self, "entity_type")


@pulumi.output_type
class PolicyStoreValidationSettings(dict):
    def __init__(__self__, *,
                 mode: _builtins.str):
        """
        :param _builtins.str mode: The mode for the validation settings. Valid values: `OFF`, `STRICT`.
               
               The following arguments are optional:
        """
        pulumi.set(__self__, "mode", mode)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.str:
        """
        The mode for the validation settings. Valid values: `OFF`, `STRICT`.

        The following arguments are optional:
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class SchemaDefinition(dict):
    def __init__(__self__, *,
                 value: _builtins.str):
        """
        :param _builtins.str value: A JSON string representation of the schema.
        """
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        A JSON string representation of the schema.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetPolicyStoreValidationSettingResult(dict):
    def __init__(__self__, *,
                 mode: _builtins.str):
        pulumi.set(__self__, "mode", mode)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.str:
        return pulumi.get(self, "mode")


