# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAuthPolicyResult',
    'AwaitableGetAuthPolicyResult',
    'get_auth_policy',
    'get_auth_policy_output',
]

@pulumi.output_type
class GetAuthPolicyResult:
    """
    A collection of values returned by getAuthPolicy.
    """
    def __init__(__self__, id=None, policy=None, region=None, resource_identifier=None, state=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if policy and not isinstance(policy, str):
            raise TypeError("Expected argument 'policy' to be a str")
        pulumi.set(__self__, "policy", policy)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if resource_identifier and not isinstance(resource_identifier, str):
            raise TypeError("Expected argument 'resource_identifier' to be a str")
        pulumi.set(__self__, "resource_identifier", resource_identifier)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[_builtins.str]:
        """
        The auth policy. The policy string in JSON must not contain newlines or blank lines.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourceIdentifier")
    def resource_identifier(self) -> _builtins.str:
        return pulumi.get(self, "resource_identifier")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The state of the auth policy. The auth policy is only active when the auth type is set to AWS_IAM. If you provide a policy, then authentication and authorization decisions are made based on this policy and the client's IAM policy. If the Auth type is NONE, then, any auth policy you provide will remain inactive.
        """
        return pulumi.get(self, "state")


class AwaitableGetAuthPolicyResult(GetAuthPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAuthPolicyResult(
            id=self.id,
            policy=self.policy,
            region=self.region,
            resource_identifier=self.resource_identifier,
            state=self.state)


def get_auth_policy(policy: Optional[_builtins.str] = None,
                    region: Optional[_builtins.str] = None,
                    resource_identifier: Optional[_builtins.str] = None,
                    state: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAuthPolicyResult:
    """
    Data source for managing an AWS VPC Lattice Auth Policy.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.vpclattice.get_auth_policy(resource_identifier=test_aws_vpclattice_auth_policy["resourceIdentifier"])
    ```


    :param _builtins.str policy: The auth policy. The policy string in JSON must not contain newlines or blank lines.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str resource_identifier: The ID or Amazon Resource Name (ARN) of the service network or service for which the policy is created.
    :param _builtins.str state: The state of the auth policy. The auth policy is only active when the auth type is set to AWS_IAM. If you provide a policy, then authentication and authorization decisions are made based on this policy and the client's IAM policy. If the Auth type is NONE, then, any auth policy you provide will remain inactive.
    """
    __args__ = dict()
    __args__['policy'] = policy
    __args__['region'] = region
    __args__['resourceIdentifier'] = resource_identifier
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:vpclattice/getAuthPolicy:getAuthPolicy', __args__, opts=opts, typ=GetAuthPolicyResult).value

    return AwaitableGetAuthPolicyResult(
        id=pulumi.get(__ret__, 'id'),
        policy=pulumi.get(__ret__, 'policy'),
        region=pulumi.get(__ret__, 'region'),
        resource_identifier=pulumi.get(__ret__, 'resource_identifier'),
        state=pulumi.get(__ret__, 'state'))
def get_auth_policy_output(policy: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           resource_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                           state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAuthPolicyResult]:
    """
    Data source for managing an AWS VPC Lattice Auth Policy.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.vpclattice.get_auth_policy(resource_identifier=test_aws_vpclattice_auth_policy["resourceIdentifier"])
    ```


    :param _builtins.str policy: The auth policy. The policy string in JSON must not contain newlines or blank lines.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str resource_identifier: The ID or Amazon Resource Name (ARN) of the service network or service for which the policy is created.
    :param _builtins.str state: The state of the auth policy. The auth policy is only active when the auth type is set to AWS_IAM. If you provide a policy, then authentication and authorization decisions are made based on this policy and the client's IAM policy. If the Auth type is NONE, then, any auth policy you provide will remain inactive.
    """
    __args__ = dict()
    __args__['policy'] = policy
    __args__['region'] = region
    __args__['resourceIdentifier'] = resource_identifier
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:vpclattice/getAuthPolicy:getAuthPolicy', __args__, opts=opts, typ=GetAuthPolicyResult)
    return __ret__.apply(lambda __response__: GetAuthPolicyResult(
        id=pulumi.get(__response__, 'id'),
        policy=pulumi.get(__response__, 'policy'),
        region=pulumi.get(__response__, 'region'),
        resource_identifier=pulumi.get(__response__, 'resource_identifier'),
        state=pulumi.get(__response__, 'state')))
