# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetListenerResult',
    'AwaitableGetListenerResult',
    'get_listener',
    'get_listener_output',
]

@pulumi.output_type
class GetListenerResult:
    """
    A collection of values returned by getListener.
    """
    def __init__(__self__, arn=None, created_at=None, default_actions=None, id=None, last_updated_at=None, listener_id=None, listener_identifier=None, name=None, port=None, protocol=None, region=None, service_arn=None, service_id=None, service_identifier=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if default_actions and not isinstance(default_actions, list):
            raise TypeError("Expected argument 'default_actions' to be a list")
        pulumi.set(__self__, "default_actions", default_actions)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_updated_at and not isinstance(last_updated_at, str):
            raise TypeError("Expected argument 'last_updated_at' to be a str")
        pulumi.set(__self__, "last_updated_at", last_updated_at)
        if listener_id and not isinstance(listener_id, str):
            raise TypeError("Expected argument 'listener_id' to be a str")
        pulumi.set(__self__, "listener_id", listener_id)
        if listener_identifier and not isinstance(listener_identifier, str):
            raise TypeError("Expected argument 'listener_identifier' to be a str")
        pulumi.set(__self__, "listener_identifier", listener_identifier)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if port and not isinstance(port, int):
            raise TypeError("Expected argument 'port' to be a int")
        pulumi.set(__self__, "port", port)
        if protocol and not isinstance(protocol, str):
            raise TypeError("Expected argument 'protocol' to be a str")
        pulumi.set(__self__, "protocol", protocol)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if service_arn and not isinstance(service_arn, str):
            raise TypeError("Expected argument 'service_arn' to be a str")
        pulumi.set(__self__, "service_arn", service_arn)
        if service_id and not isinstance(service_id, str):
            raise TypeError("Expected argument 'service_id' to be a str")
        pulumi.set(__self__, "service_id", service_id)
        if service_identifier and not isinstance(service_identifier, str):
            raise TypeError("Expected argument 'service_identifier' to be a str")
        pulumi.set(__self__, "service_identifier", service_identifier)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN of the listener.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The date and time that the listener was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="defaultActions")
    def default_actions(self) -> Sequence['outputs.GetListenerDefaultActionResult']:
        """
        The actions for the default listener rule.
        """
        return pulumi.get(self, "default_actions")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedAt")
    def last_updated_at(self) -> _builtins.str:
        """
        The date and time the listener was last updated.
        """
        return pulumi.get(self, "last_updated_at")

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> _builtins.str:
        """
        The ID of the listener.
        """
        return pulumi.get(self, "listener_id")

    @_builtins.property
    @pulumi.getter(name="listenerIdentifier")
    def listener_identifier(self) -> _builtins.str:
        return pulumi.get(self, "listener_identifier")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the listener.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The listener port.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The listener protocol. Either `HTTPS` or `HTTP`.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="serviceArn")
    def service_arn(self) -> _builtins.str:
        """
        The ARN of the service.
        """
        return pulumi.get(self, "service_arn")

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> _builtins.str:
        """
        The ID of the service.
        """
        return pulumi.get(self, "service_id")

    @_builtins.property
    @pulumi.getter(name="serviceIdentifier")
    def service_identifier(self) -> _builtins.str:
        return pulumi.get(self, "service_identifier")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        List of tags associated with the listener.
        """
        return pulumi.get(self, "tags")


class AwaitableGetListenerResult(GetListenerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetListenerResult(
            arn=self.arn,
            created_at=self.created_at,
            default_actions=self.default_actions,
            id=self.id,
            last_updated_at=self.last_updated_at,
            listener_id=self.listener_id,
            listener_identifier=self.listener_identifier,
            name=self.name,
            port=self.port,
            protocol=self.protocol,
            region=self.region,
            service_arn=self.service_arn,
            service_id=self.service_id,
            service_identifier=self.service_identifier,
            tags=self.tags)


def get_listener(listener_identifier: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 service_identifier: Optional[_builtins.str] = None,
                 tags: Optional[Mapping[str, _builtins.str]] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetListenerResult:
    """
    Data source for managing an AWS VPC Lattice Listener.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.vpclattice.get_listener()
    ```


    :param _builtins.str listener_identifier: ID or Amazon Resource Name (ARN) of the listener
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str service_identifier: ID or Amazon Resource Name (ARN) of the service network
    :param Mapping[str, _builtins.str] tags: List of tags associated with the listener.
    """
    __args__ = dict()
    __args__['listenerIdentifier'] = listener_identifier
    __args__['region'] = region
    __args__['serviceIdentifier'] = service_identifier
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:vpclattice/getListener:getListener', __args__, opts=opts, typ=GetListenerResult).value

    return AwaitableGetListenerResult(
        arn=pulumi.get(__ret__, 'arn'),
        created_at=pulumi.get(__ret__, 'created_at'),
        default_actions=pulumi.get(__ret__, 'default_actions'),
        id=pulumi.get(__ret__, 'id'),
        last_updated_at=pulumi.get(__ret__, 'last_updated_at'),
        listener_id=pulumi.get(__ret__, 'listener_id'),
        listener_identifier=pulumi.get(__ret__, 'listener_identifier'),
        name=pulumi.get(__ret__, 'name'),
        port=pulumi.get(__ret__, 'port'),
        protocol=pulumi.get(__ret__, 'protocol'),
        region=pulumi.get(__ret__, 'region'),
        service_arn=pulumi.get(__ret__, 'service_arn'),
        service_id=pulumi.get(__ret__, 'service_id'),
        service_identifier=pulumi.get(__ret__, 'service_identifier'),
        tags=pulumi.get(__ret__, 'tags'))
def get_listener_output(listener_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                        region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        service_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                        tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetListenerResult]:
    """
    Data source for managing an AWS VPC Lattice Listener.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.vpclattice.get_listener()
    ```


    :param _builtins.str listener_identifier: ID or Amazon Resource Name (ARN) of the listener
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str service_identifier: ID or Amazon Resource Name (ARN) of the service network
    :param Mapping[str, _builtins.str] tags: List of tags associated with the listener.
    """
    __args__ = dict()
    __args__['listenerIdentifier'] = listener_identifier
    __args__['region'] = region
    __args__['serviceIdentifier'] = service_identifier
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:vpclattice/getListener:getListener', __args__, opts=opts, typ=GetListenerResult)
    return __ret__.apply(lambda __response__: GetListenerResult(
        arn=pulumi.get(__response__, 'arn'),
        created_at=pulumi.get(__response__, 'created_at'),
        default_actions=pulumi.get(__response__, 'default_actions'),
        id=pulumi.get(__response__, 'id'),
        last_updated_at=pulumi.get(__response__, 'last_updated_at'),
        listener_id=pulumi.get(__response__, 'listener_id'),
        listener_identifier=pulumi.get(__response__, 'listener_identifier'),
        name=pulumi.get(__response__, 'name'),
        port=pulumi.get(__response__, 'port'),
        protocol=pulumi.get(__response__, 'protocol'),
        region=pulumi.get(__response__, 'region'),
        service_arn=pulumi.get(__response__, 'service_arn'),
        service_id=pulumi.get(__response__, 'service_id'),
        service_identifier=pulumi.get(__response__, 'service_identifier'),
        tags=pulumi.get(__response__, 'tags')))
