# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetServiceResult',
    'AwaitableGetServiceResult',
    'get_service',
    'get_service_output',
]

@pulumi.output_type
class GetServiceResult:
    """
    A collection of values returned by getService.
    """
    def __init__(__self__, arn=None, auth_type=None, certificate_arn=None, custom_domain_name=None, dns_entries=None, id=None, name=None, region=None, service_identifier=None, status=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if auth_type and not isinstance(auth_type, str):
            raise TypeError("Expected argument 'auth_type' to be a str")
        pulumi.set(__self__, "auth_type", auth_type)
        if certificate_arn and not isinstance(certificate_arn, str):
            raise TypeError("Expected argument 'certificate_arn' to be a str")
        pulumi.set(__self__, "certificate_arn", certificate_arn)
        if custom_domain_name and not isinstance(custom_domain_name, str):
            raise TypeError("Expected argument 'custom_domain_name' to be a str")
        pulumi.set(__self__, "custom_domain_name", custom_domain_name)
        if dns_entries and not isinstance(dns_entries, list):
            raise TypeError("Expected argument 'dns_entries' to be a list")
        pulumi.set(__self__, "dns_entries", dns_entries)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if service_identifier and not isinstance(service_identifier, str):
            raise TypeError("Expected argument 'service_identifier' to be a str")
        pulumi.set(__self__, "service_identifier", service_identifier)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN of the service.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> _builtins.str:
        """
        Type of IAM policy. Either `NONE` or `AWS_IAM`.
        """
        return pulumi.get(self, "auth_type")

    @_builtins.property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> _builtins.str:
        """
        Amazon Resource Name (ARN) of the certificate.
        """
        return pulumi.get(self, "certificate_arn")

    @_builtins.property
    @pulumi.getter(name="customDomainName")
    def custom_domain_name(self) -> _builtins.str:
        """
        Custom domain name of the service.
        """
        return pulumi.get(self, "custom_domain_name")

    @_builtins.property
    @pulumi.getter(name="dnsEntries")
    def dns_entries(self) -> Sequence['outputs.GetServiceDnsEntryResult']:
        """
        List of objects with DNS names.
        """
        return pulumi.get(self, "dns_entries")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="serviceIdentifier")
    def service_identifier(self) -> _builtins.str:
        return pulumi.get(self, "service_identifier")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the service.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        List of tags associated with the service.
        """
        return pulumi.get(self, "tags")


class AwaitableGetServiceResult(GetServiceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceResult(
            arn=self.arn,
            auth_type=self.auth_type,
            certificate_arn=self.certificate_arn,
            custom_domain_name=self.custom_domain_name,
            dns_entries=self.dns_entries,
            id=self.id,
            name=self.name,
            region=self.region,
            service_identifier=self.service_identifier,
            status=self.status,
            tags=self.tags)


def get_service(name: Optional[_builtins.str] = None,
                region: Optional[_builtins.str] = None,
                service_identifier: Optional[_builtins.str] = None,
                tags: Optional[Mapping[str, _builtins.str]] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceResult:
    """
    Data source for managing an AWS VPC Lattice Service.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.vpclattice.get_service(name="example")
    ```


    :param _builtins.str name: Service name.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str service_identifier: ID or Amazon Resource Name (ARN) of the service.
    :param Mapping[str, _builtins.str] tags: List of tags associated with the service.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['serviceIdentifier'] = service_identifier
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:vpclattice/getService:getService', __args__, opts=opts, typ=GetServiceResult).value

    return AwaitableGetServiceResult(
        arn=pulumi.get(__ret__, 'arn'),
        auth_type=pulumi.get(__ret__, 'auth_type'),
        certificate_arn=pulumi.get(__ret__, 'certificate_arn'),
        custom_domain_name=pulumi.get(__ret__, 'custom_domain_name'),
        dns_entries=pulumi.get(__ret__, 'dns_entries'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        service_identifier=pulumi.get(__ret__, 'service_identifier'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'))
def get_service_output(name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       service_identifier: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceResult]:
    """
    Data source for managing an AWS VPC Lattice Service.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.vpclattice.get_service(name="example")
    ```


    :param _builtins.str name: Service name.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str service_identifier: ID or Amazon Resource Name (ARN) of the service.
    :param Mapping[str, _builtins.str] tags: List of tags associated with the service.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['serviceIdentifier'] = service_identifier
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:vpclattice/getService:getService', __args__, opts=opts, typ=GetServiceResult)
    return __ret__.apply(lambda __response__: GetServiceResult(
        arn=pulumi.get(__response__, 'arn'),
        auth_type=pulumi.get(__response__, 'auth_type'),
        certificate_arn=pulumi.get(__response__, 'certificate_arn'),
        custom_domain_name=pulumi.get(__response__, 'custom_domain_name'),
        dns_entries=pulumi.get(__response__, 'dns_entries'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        service_identifier=pulumi.get(__response__, 'service_identifier'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags')))
