# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ResourceConfigurationArgs', 'ResourceConfiguration']

@pulumi.input_type
class ResourceConfigurationArgs:
    def __init__(__self__, *,
                 allow_association_to_shareable_service_network: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_configuration_definition: Optional[pulumi.Input['ResourceConfigurationResourceConfigurationDefinitionArgs']] = None,
                 resource_configuration_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_gateway_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['ResourceConfigurationTimeoutsArgs']] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ResourceConfiguration resource.
        :param pulumi.Input[_builtins.bool] allow_association_to_shareable_service_network: Allow or Deny the association of this resource to a shareable service network.
        :param pulumi.Input[_builtins.str] name: Name for the Resource Configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] port_ranges: Port ranges to access the Resource either single port `80` or range `80-81` range.
        :param pulumi.Input[_builtins.str] protocol: Protocol for the Resource `TCP` is currently the only supported value.  MUST be specified if `resource_configuration_group_id` is not.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['ResourceConfigurationResourceConfigurationDefinitionArgs'] resource_configuration_definition: Details of the Resource Configuration. See `resource_configuration_definition` Block for details.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] resource_configuration_group_id: ID of Resource Configuration where `type` is `CHILD`.
        :param pulumi.Input[_builtins.str] resource_gateway_identifier: ID of the Resource Gateway used to access the resource. MUST be specified if `resource_configuration_group_id` is not.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] type: Type of Resource Configuration. Must be one of `GROUP`, `CHILD`, `SINGLE`, `ARN`.
        """
        if allow_association_to_shareable_service_network is not None:
            pulumi.set(__self__, "allow_association_to_shareable_service_network", allow_association_to_shareable_service_network)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port_ranges is not None:
            pulumi.set(__self__, "port_ranges", port_ranges)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_configuration_definition is not None:
            pulumi.set(__self__, "resource_configuration_definition", resource_configuration_definition)
        if resource_configuration_group_id is not None:
            pulumi.set(__self__, "resource_configuration_group_id", resource_configuration_group_id)
        if resource_gateway_identifier is not None:
            pulumi.set(__self__, "resource_gateway_identifier", resource_gateway_identifier)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="allowAssociationToShareableServiceNetwork")
    def allow_association_to_shareable_service_network(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow or Deny the association of this resource to a shareable service network.
        """
        return pulumi.get(self, "allow_association_to_shareable_service_network")

    @allow_association_to_shareable_service_network.setter
    def allow_association_to_shareable_service_network(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_association_to_shareable_service_network", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name for the Resource Configuration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="portRanges")
    def port_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Port ranges to access the Resource either single port `80` or range `80-81` range.
        """
        return pulumi.get(self, "port_ranges")

    @port_ranges.setter
    def port_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "port_ranges", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Protocol for the Resource `TCP` is currently the only supported value.  MUST be specified if `resource_configuration_group_id` is not.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourceConfigurationDefinition")
    def resource_configuration_definition(self) -> Optional[pulumi.Input['ResourceConfigurationResourceConfigurationDefinitionArgs']]:
        """
        Details of the Resource Configuration. See `resource_configuration_definition` Block for details.

        The following arguments are optional:
        """
        return pulumi.get(self, "resource_configuration_definition")

    @resource_configuration_definition.setter
    def resource_configuration_definition(self, value: Optional[pulumi.Input['ResourceConfigurationResourceConfigurationDefinitionArgs']]):
        pulumi.set(self, "resource_configuration_definition", value)

    @_builtins.property
    @pulumi.getter(name="resourceConfigurationGroupId")
    def resource_configuration_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of Resource Configuration where `type` is `CHILD`.
        """
        return pulumi.get(self, "resource_configuration_group_id")

    @resource_configuration_group_id.setter
    def resource_configuration_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_configuration_group_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGatewayIdentifier")
    def resource_gateway_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the Resource Gateway used to access the resource. MUST be specified if `resource_configuration_group_id` is not.
        """
        return pulumi.get(self, "resource_gateway_identifier")

    @resource_gateway_identifier.setter
    def resource_gateway_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_gateway_identifier", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ResourceConfigurationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ResourceConfigurationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of Resource Configuration. Must be one of `GROUP`, `CHILD`, `SINGLE`, `ARN`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _ResourceConfigurationState:
    def __init__(__self__, *,
                 allow_association_to_shareable_service_network: Optional[pulumi.Input[_builtins.bool]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_configuration_definition: Optional[pulumi.Input['ResourceConfigurationResourceConfigurationDefinitionArgs']] = None,
                 resource_configuration_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_gateway_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['ResourceConfigurationTimeoutsArgs']] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ResourceConfiguration resources.
        :param pulumi.Input[_builtins.bool] allow_association_to_shareable_service_network: Allow or Deny the association of this resource to a shareable service network.
        :param pulumi.Input[_builtins.str] arn: ARN of the resource gateway.
        :param pulumi.Input[_builtins.str] name: Name for the Resource Configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] port_ranges: Port ranges to access the Resource either single port `80` or range `80-81` range.
        :param pulumi.Input[_builtins.str] protocol: Protocol for the Resource `TCP` is currently the only supported value.  MUST be specified if `resource_configuration_group_id` is not.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['ResourceConfigurationResourceConfigurationDefinitionArgs'] resource_configuration_definition: Details of the Resource Configuration. See `resource_configuration_definition` Block for details.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] resource_configuration_group_id: ID of Resource Configuration where `type` is `CHILD`.
        :param pulumi.Input[_builtins.str] resource_gateway_identifier: ID of the Resource Gateway used to access the resource. MUST be specified if `resource_configuration_group_id` is not.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] type: Type of Resource Configuration. Must be one of `GROUP`, `CHILD`, `SINGLE`, `ARN`.
        """
        if allow_association_to_shareable_service_network is not None:
            pulumi.set(__self__, "allow_association_to_shareable_service_network", allow_association_to_shareable_service_network)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port_ranges is not None:
            pulumi.set(__self__, "port_ranges", port_ranges)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_configuration_definition is not None:
            pulumi.set(__self__, "resource_configuration_definition", resource_configuration_definition)
        if resource_configuration_group_id is not None:
            pulumi.set(__self__, "resource_configuration_group_id", resource_configuration_group_id)
        if resource_gateway_identifier is not None:
            pulumi.set(__self__, "resource_gateway_identifier", resource_gateway_identifier)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="allowAssociationToShareableServiceNetwork")
    def allow_association_to_shareable_service_network(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow or Deny the association of this resource to a shareable service network.
        """
        return pulumi.get(self, "allow_association_to_shareable_service_network")

    @allow_association_to_shareable_service_network.setter
    def allow_association_to_shareable_service_network(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_association_to_shareable_service_network", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the resource gateway.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name for the Resource Configuration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="portRanges")
    def port_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Port ranges to access the Resource either single port `80` or range `80-81` range.
        """
        return pulumi.get(self, "port_ranges")

    @port_ranges.setter
    def port_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "port_ranges", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Protocol for the Resource `TCP` is currently the only supported value.  MUST be specified if `resource_configuration_group_id` is not.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourceConfigurationDefinition")
    def resource_configuration_definition(self) -> Optional[pulumi.Input['ResourceConfigurationResourceConfigurationDefinitionArgs']]:
        """
        Details of the Resource Configuration. See `resource_configuration_definition` Block for details.

        The following arguments are optional:
        """
        return pulumi.get(self, "resource_configuration_definition")

    @resource_configuration_definition.setter
    def resource_configuration_definition(self, value: Optional[pulumi.Input['ResourceConfigurationResourceConfigurationDefinitionArgs']]):
        pulumi.set(self, "resource_configuration_definition", value)

    @_builtins.property
    @pulumi.getter(name="resourceConfigurationGroupId")
    def resource_configuration_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of Resource Configuration where `type` is `CHILD`.
        """
        return pulumi.get(self, "resource_configuration_group_id")

    @resource_configuration_group_id.setter
    def resource_configuration_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_configuration_group_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGatewayIdentifier")
    def resource_gateway_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the Resource Gateway used to access the resource. MUST be specified if `resource_configuration_group_id` is not.
        """
        return pulumi.get(self, "resource_gateway_identifier")

    @resource_gateway_identifier.setter
    def resource_gateway_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_gateway_identifier", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ResourceConfigurationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ResourceConfigurationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of Resource Configuration. Must be one of `GROUP`, `CHILD`, `SINGLE`, `ARN`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("aws:vpclattice/resourceConfiguration:ResourceConfiguration")
class ResourceConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_association_to_shareable_service_network: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_configuration_definition: Optional[pulumi.Input[Union['ResourceConfigurationResourceConfigurationDefinitionArgs', 'ResourceConfigurationResourceConfigurationDefinitionArgsDict']]] = None,
                 resource_configuration_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_gateway_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['ResourceConfigurationTimeoutsArgs', 'ResourceConfigurationTimeoutsArgsDict']]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS VPC Lattice Resource Configuration.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.vpclattice.ResourceConfiguration("example",
            name="Example",
            resource_gateway_identifier=example_aws_vpclattice_resource_gateway["id"],
            port_ranges=["80"],
            protocol="TCP",
            resource_configuration_definition={
                "dns_resource": {
                    "domain_name": "example.com",
                    "ip_address_type": "IPV4",
                },
            },
            tags={
                "Environment": "Example",
            })
        ```

        ### IP Address Example

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.vpclattice.ResourceConfiguration("example",
            name="Example",
            resource_gateway_identifier=example_aws_vpclattice_resource_gateway["id"],
            port_ranges=["80"],
            protocol="TCP",
            resource_configuration_definition={
                "ip_resource": {
                    "ip_address": "10.0.0.1",
                },
            },
            tags={
                "Environment": "Example",
            })
        ```

        ### ARN Example

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.vpclattice.ResourceConfiguration("test",
            name="Example",
            resource_gateway_identifier=test_aws_vpclattice_resource_gateway["id"],
            type="ARN",
            resource_configuration_definition={
                "arn_resource": {
                    "arn": example["arn"],
                },
            })
        ```

        ## Import

        Using `pulumi import`, import VPC Lattice Resource Configuration using the `id`. For example:

        ```sh
        $ pulumi import aws:vpclattice/resourceConfiguration:ResourceConfiguration example rcfg-1234567890abcdef1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_association_to_shareable_service_network: Allow or Deny the association of this resource to a shareable service network.
        :param pulumi.Input[_builtins.str] name: Name for the Resource Configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] port_ranges: Port ranges to access the Resource either single port `80` or range `80-81` range.
        :param pulumi.Input[_builtins.str] protocol: Protocol for the Resource `TCP` is currently the only supported value.  MUST be specified if `resource_configuration_group_id` is not.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['ResourceConfigurationResourceConfigurationDefinitionArgs', 'ResourceConfigurationResourceConfigurationDefinitionArgsDict']] resource_configuration_definition: Details of the Resource Configuration. See `resource_configuration_definition` Block for details.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] resource_configuration_group_id: ID of Resource Configuration where `type` is `CHILD`.
        :param pulumi.Input[_builtins.str] resource_gateway_identifier: ID of the Resource Gateway used to access the resource. MUST be specified if `resource_configuration_group_id` is not.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] type: Type of Resource Configuration. Must be one of `GROUP`, `CHILD`, `SINGLE`, `ARN`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ResourceConfigurationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS VPC Lattice Resource Configuration.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.vpclattice.ResourceConfiguration("example",
            name="Example",
            resource_gateway_identifier=example_aws_vpclattice_resource_gateway["id"],
            port_ranges=["80"],
            protocol="TCP",
            resource_configuration_definition={
                "dns_resource": {
                    "domain_name": "example.com",
                    "ip_address_type": "IPV4",
                },
            },
            tags={
                "Environment": "Example",
            })
        ```

        ### IP Address Example

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.vpclattice.ResourceConfiguration("example",
            name="Example",
            resource_gateway_identifier=example_aws_vpclattice_resource_gateway["id"],
            port_ranges=["80"],
            protocol="TCP",
            resource_configuration_definition={
                "ip_resource": {
                    "ip_address": "10.0.0.1",
                },
            },
            tags={
                "Environment": "Example",
            })
        ```

        ### ARN Example

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.vpclattice.ResourceConfiguration("test",
            name="Example",
            resource_gateway_identifier=test_aws_vpclattice_resource_gateway["id"],
            type="ARN",
            resource_configuration_definition={
                "arn_resource": {
                    "arn": example["arn"],
                },
            })
        ```

        ## Import

        Using `pulumi import`, import VPC Lattice Resource Configuration using the `id`. For example:

        ```sh
        $ pulumi import aws:vpclattice/resourceConfiguration:ResourceConfiguration example rcfg-1234567890abcdef1
        ```

        :param str resource_name: The name of the resource.
        :param ResourceConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResourceConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_association_to_shareable_service_network: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_configuration_definition: Optional[pulumi.Input[Union['ResourceConfigurationResourceConfigurationDefinitionArgs', 'ResourceConfigurationResourceConfigurationDefinitionArgsDict']]] = None,
                 resource_configuration_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_gateway_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['ResourceConfigurationTimeoutsArgs', 'ResourceConfigurationTimeoutsArgsDict']]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResourceConfigurationArgs.__new__(ResourceConfigurationArgs)

            __props__.__dict__["allow_association_to_shareable_service_network"] = allow_association_to_shareable_service_network
            __props__.__dict__["name"] = name
            __props__.__dict__["port_ranges"] = port_ranges
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["region"] = region
            __props__.__dict__["resource_configuration_definition"] = resource_configuration_definition
            __props__.__dict__["resource_configuration_group_id"] = resource_configuration_group_id
            __props__.__dict__["resource_gateway_identifier"] = resource_gateway_identifier
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["type"] = type
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(ResourceConfiguration, __self__).__init__(
            'aws:vpclattice/resourceConfiguration:ResourceConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_association_to_shareable_service_network: Optional[pulumi.Input[_builtins.bool]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            resource_configuration_definition: Optional[pulumi.Input[Union['ResourceConfigurationResourceConfigurationDefinitionArgs', 'ResourceConfigurationResourceConfigurationDefinitionArgsDict']]] = None,
            resource_configuration_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_gateway_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['ResourceConfigurationTimeoutsArgs', 'ResourceConfigurationTimeoutsArgsDict']]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'ResourceConfiguration':
        """
        Get an existing ResourceConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_association_to_shareable_service_network: Allow or Deny the association of this resource to a shareable service network.
        :param pulumi.Input[_builtins.str] arn: ARN of the resource gateway.
        :param pulumi.Input[_builtins.str] name: Name for the Resource Configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] port_ranges: Port ranges to access the Resource either single port `80` or range `80-81` range.
        :param pulumi.Input[_builtins.str] protocol: Protocol for the Resource `TCP` is currently the only supported value.  MUST be specified if `resource_configuration_group_id` is not.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['ResourceConfigurationResourceConfigurationDefinitionArgs', 'ResourceConfigurationResourceConfigurationDefinitionArgsDict']] resource_configuration_definition: Details of the Resource Configuration. See `resource_configuration_definition` Block for details.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] resource_configuration_group_id: ID of Resource Configuration where `type` is `CHILD`.
        :param pulumi.Input[_builtins.str] resource_gateway_identifier: ID of the Resource Gateway used to access the resource. MUST be specified if `resource_configuration_group_id` is not.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] type: Type of Resource Configuration. Must be one of `GROUP`, `CHILD`, `SINGLE`, `ARN`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResourceConfigurationState.__new__(_ResourceConfigurationState)

        __props__.__dict__["allow_association_to_shareable_service_network"] = allow_association_to_shareable_service_network
        __props__.__dict__["arn"] = arn
        __props__.__dict__["name"] = name
        __props__.__dict__["port_ranges"] = port_ranges
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["region"] = region
        __props__.__dict__["resource_configuration_definition"] = resource_configuration_definition
        __props__.__dict__["resource_configuration_group_id"] = resource_configuration_group_id
        __props__.__dict__["resource_gateway_identifier"] = resource_gateway_identifier
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["type"] = type
        return ResourceConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowAssociationToShareableServiceNetwork")
    def allow_association_to_shareable_service_network(self) -> pulumi.Output[_builtins.bool]:
        """
        Allow or Deny the association of this resource to a shareable service network.
        """
        return pulumi.get(self, "allow_association_to_shareable_service_network")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the resource gateway.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name for the Resource Configuration.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="portRanges")
    def port_ranges(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Port ranges to access the Resource either single port `80` or range `80-81` range.
        """
        return pulumi.get(self, "port_ranges")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[_builtins.str]:
        """
        Protocol for the Resource `TCP` is currently the only supported value.  MUST be specified if `resource_configuration_group_id` is not.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourceConfigurationDefinition")
    def resource_configuration_definition(self) -> pulumi.Output[Optional['outputs.ResourceConfigurationResourceConfigurationDefinition']]:
        """
        Details of the Resource Configuration. See `resource_configuration_definition` Block for details.

        The following arguments are optional:
        """
        return pulumi.get(self, "resource_configuration_definition")

    @_builtins.property
    @pulumi.getter(name="resourceConfigurationGroupId")
    def resource_configuration_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of Resource Configuration where `type` is `CHILD`.
        """
        return pulumi.get(self, "resource_configuration_group_id")

    @_builtins.property
    @pulumi.getter(name="resourceGatewayIdentifier")
    def resource_gateway_identifier(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the Resource Gateway used to access the resource. MUST be specified if `resource_configuration_group_id` is not.
        """
        return pulumi.get(self, "resource_gateway_identifier")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.ResourceConfigurationTimeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of Resource Configuration. Must be one of `GROUP`, `CHILD`, `SINGLE`, `ARN`.
        """
        return pulumi.get(self, "type")

