# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetBundleResult',
    'AwaitableGetBundleResult',
    'get_bundle',
    'get_bundle_output',
]

@pulumi.output_type
class GetBundleResult:
    """
    A collection of values returned by getBundle.
    """
    def __init__(__self__, bundle_id=None, compute_types=None, description=None, id=None, name=None, owner=None, region=None, root_storages=None, user_storages=None):
        if bundle_id and not isinstance(bundle_id, str):
            raise TypeError("Expected argument 'bundle_id' to be a str")
        pulumi.set(__self__, "bundle_id", bundle_id)
        if compute_types and not isinstance(compute_types, list):
            raise TypeError("Expected argument 'compute_types' to be a list")
        pulumi.set(__self__, "compute_types", compute_types)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if owner and not isinstance(owner, str):
            raise TypeError("Expected argument 'owner' to be a str")
        pulumi.set(__self__, "owner", owner)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if root_storages and not isinstance(root_storages, list):
            raise TypeError("Expected argument 'root_storages' to be a list")
        pulumi.set(__self__, "root_storages", root_storages)
        if user_storages and not isinstance(user_storages, list):
            raise TypeError("Expected argument 'user_storages' to be a list")
        pulumi.set(__self__, "user_storages", user_storages)

    @_builtins.property
    @pulumi.getter(name="bundleId")
    def bundle_id(self) -> Optional[_builtins.str]:
        """
        The ID of the bundle.
        """
        return pulumi.get(self, "bundle_id")

    @_builtins.property
    @pulumi.getter(name="computeTypes")
    def compute_types(self) -> Sequence['outputs.GetBundleComputeTypeResult']:
        """
        The compute type. See supported fields below.
        """
        return pulumi.get(self, "compute_types")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the bundle.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the compute type.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[_builtins.str]:
        """
        The owner of the bundle.
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="rootStorages")
    def root_storages(self) -> Sequence['outputs.GetBundleRootStorageResult']:
        """
        The root volume. See supported fields below.
        """
        return pulumi.get(self, "root_storages")

    @_builtins.property
    @pulumi.getter(name="userStorages")
    def user_storages(self) -> Sequence['outputs.GetBundleUserStorageResult']:
        """
        The user storage. See supported fields below.
        """
        return pulumi.get(self, "user_storages")


class AwaitableGetBundleResult(GetBundleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBundleResult(
            bundle_id=self.bundle_id,
            compute_types=self.compute_types,
            description=self.description,
            id=self.id,
            name=self.name,
            owner=self.owner,
            region=self.region,
            root_storages=self.root_storages,
            user_storages=self.user_storages)


def get_bundle(bundle_id: Optional[_builtins.str] = None,
               name: Optional[_builtins.str] = None,
               owner: Optional[_builtins.str] = None,
               region: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBundleResult:
    """
    Retrieve information about an AWS WorkSpaces bundle.

    ## Example Usage

    ### By ID

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.workspaces.get_bundle(bundle_id="wsb-b0s22j3d7")
    ```

    ### By Owner & Name

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.workspaces.get_bundle(owner="AMAZON",
        name="Value with Windows 10 and Office 2016")
    ```


    :param _builtins.str bundle_id: ID of the bundle.
    :param _builtins.str name: Name of the bundle. You cannot combine this parameter with `bundle_id`.
    :param _builtins.str owner: Owner of the bundles. You have to leave it blank for own bundles. You cannot combine this parameter with `bundle_id`.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['bundleId'] = bundle_id
    __args__['name'] = name
    __args__['owner'] = owner
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:workspaces/getBundle:getBundle', __args__, opts=opts, typ=GetBundleResult).value

    return AwaitableGetBundleResult(
        bundle_id=pulumi.get(__ret__, 'bundle_id'),
        compute_types=pulumi.get(__ret__, 'compute_types'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        owner=pulumi.get(__ret__, 'owner'),
        region=pulumi.get(__ret__, 'region'),
        root_storages=pulumi.get(__ret__, 'root_storages'),
        user_storages=pulumi.get(__ret__, 'user_storages'))
def get_bundle_output(bundle_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      owner: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBundleResult]:
    """
    Retrieve information about an AWS WorkSpaces bundle.

    ## Example Usage

    ### By ID

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.workspaces.get_bundle(bundle_id="wsb-b0s22j3d7")
    ```

    ### By Owner & Name

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.workspaces.get_bundle(owner="AMAZON",
        name="Value with Windows 10 and Office 2016")
    ```


    :param _builtins.str bundle_id: ID of the bundle.
    :param _builtins.str name: Name of the bundle. You cannot combine this parameter with `bundle_id`.
    :param _builtins.str owner: Owner of the bundles. You have to leave it blank for own bundles. You cannot combine this parameter with `bundle_id`.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['bundleId'] = bundle_id
    __args__['name'] = name
    __args__['owner'] = owner
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:workspaces/getBundle:getBundle', __args__, opts=opts, typ=GetBundleResult)
    return __ret__.apply(lambda __response__: GetBundleResult(
        bundle_id=pulumi.get(__response__, 'bundle_id'),
        compute_types=pulumi.get(__response__, 'compute_types'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        owner=pulumi.get(__response__, 'owner'),
        region=pulumi.get(__response__, 'region'),
        root_storages=pulumi.get(__response__, 'root_storages'),
        user_storages=pulumi.get(__response__, 'user_storages')))
