# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SessionLoggerArgs', 'SessionLogger']

@pulumi.input_type
class SessionLoggerArgs:
    def __init__(__self__, *,
                 additional_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 customer_managed_key: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 event_filter: Optional[pulumi.Input['SessionLoggerEventFilterArgs']] = None,
                 log_configuration: Optional[pulumi.Input['SessionLoggerLogConfigurationArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a SessionLogger resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_encryption_context: Map of additional encryption context key-value pairs.
        :param pulumi.Input[_builtins.str] customer_managed_key: ARN of the customer managed KMS key used to encrypt sensitive information.
        :param pulumi.Input[_builtins.str] display_name: Human-readable display name for the session logger resource. Forces replacement if changed.
        :param pulumi.Input['SessionLoggerEventFilterArgs'] event_filter: Event filter that determines which events are logged. See Event Filter below.
        :param pulumi.Input['SessionLoggerLogConfigurationArgs'] log_configuration: Configuration block for specifying where logs are delivered. See Log Configuration below.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        if additional_encryption_context is not None:
            pulumi.set(__self__, "additional_encryption_context", additional_encryption_context)
        if customer_managed_key is not None:
            pulumi.set(__self__, "customer_managed_key", customer_managed_key)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if event_filter is not None:
            pulumi.set(__self__, "event_filter", event_filter)
        if log_configuration is not None:
            pulumi.set(__self__, "log_configuration", log_configuration)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="additionalEncryptionContext")
    def additional_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of additional encryption context key-value pairs.
        """
        return pulumi.get(self, "additional_encryption_context")

    @additional_encryption_context.setter
    def additional_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_encryption_context", value)

    @_builtins.property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the customer managed KMS key used to encrypt sensitive information.
        """
        return pulumi.get(self, "customer_managed_key")

    @customer_managed_key.setter
    def customer_managed_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "customer_managed_key", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable display name for the session logger resource. Forces replacement if changed.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="eventFilter")
    def event_filter(self) -> Optional[pulumi.Input['SessionLoggerEventFilterArgs']]:
        """
        Event filter that determines which events are logged. See Event Filter below.
        """
        return pulumi.get(self, "event_filter")

    @event_filter.setter
    def event_filter(self, value: Optional[pulumi.Input['SessionLoggerEventFilterArgs']]):
        pulumi.set(self, "event_filter", value)

    @_builtins.property
    @pulumi.getter(name="logConfiguration")
    def log_configuration(self) -> Optional[pulumi.Input['SessionLoggerLogConfigurationArgs']]:
        """
        Configuration block for specifying where logs are delivered. See Log Configuration below.

        The following arguments are optional:
        """
        return pulumi.get(self, "log_configuration")

    @log_configuration.setter
    def log_configuration(self, value: Optional[pulumi.Input['SessionLoggerLogConfigurationArgs']]):
        pulumi.set(self, "log_configuration", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _SessionLoggerState:
    def __init__(__self__, *,
                 additional_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 associated_portal_arns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 customer_managed_key: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 event_filter: Optional[pulumi.Input['SessionLoggerEventFilterArgs']] = None,
                 log_configuration: Optional[pulumi.Input['SessionLoggerLogConfigurationArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 session_logger_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering SessionLogger resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_encryption_context: Map of additional encryption context key-value pairs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] associated_portal_arns: List of ARNs of the web portals associated with the session logger.
        :param pulumi.Input[_builtins.str] customer_managed_key: ARN of the customer managed KMS key used to encrypt sensitive information.
        :param pulumi.Input[_builtins.str] display_name: Human-readable display name for the session logger resource. Forces replacement if changed.
        :param pulumi.Input['SessionLoggerEventFilterArgs'] event_filter: Event filter that determines which events are logged. See Event Filter below.
        :param pulumi.Input['SessionLoggerLogConfigurationArgs'] log_configuration: Configuration block for specifying where logs are delivered. See Log Configuration below.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] session_logger_arn: ARN of the session logger.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if additional_encryption_context is not None:
            pulumi.set(__self__, "additional_encryption_context", additional_encryption_context)
        if associated_portal_arns is not None:
            pulumi.set(__self__, "associated_portal_arns", associated_portal_arns)
        if customer_managed_key is not None:
            pulumi.set(__self__, "customer_managed_key", customer_managed_key)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if event_filter is not None:
            pulumi.set(__self__, "event_filter", event_filter)
        if log_configuration is not None:
            pulumi.set(__self__, "log_configuration", log_configuration)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if session_logger_arn is not None:
            pulumi.set(__self__, "session_logger_arn", session_logger_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @_builtins.property
    @pulumi.getter(name="additionalEncryptionContext")
    def additional_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of additional encryption context key-value pairs.
        """
        return pulumi.get(self, "additional_encryption_context")

    @additional_encryption_context.setter
    def additional_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_encryption_context", value)

    @_builtins.property
    @pulumi.getter(name="associatedPortalArns")
    def associated_portal_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of ARNs of the web portals associated with the session logger.
        """
        return pulumi.get(self, "associated_portal_arns")

    @associated_portal_arns.setter
    def associated_portal_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "associated_portal_arns", value)

    @_builtins.property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the customer managed KMS key used to encrypt sensitive information.
        """
        return pulumi.get(self, "customer_managed_key")

    @customer_managed_key.setter
    def customer_managed_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "customer_managed_key", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable display name for the session logger resource. Forces replacement if changed.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="eventFilter")
    def event_filter(self) -> Optional[pulumi.Input['SessionLoggerEventFilterArgs']]:
        """
        Event filter that determines which events are logged. See Event Filter below.
        """
        return pulumi.get(self, "event_filter")

    @event_filter.setter
    def event_filter(self, value: Optional[pulumi.Input['SessionLoggerEventFilterArgs']]):
        pulumi.set(self, "event_filter", value)

    @_builtins.property
    @pulumi.getter(name="logConfiguration")
    def log_configuration(self) -> Optional[pulumi.Input['SessionLoggerLogConfigurationArgs']]:
        """
        Configuration block for specifying where logs are delivered. See Log Configuration below.

        The following arguments are optional:
        """
        return pulumi.get(self, "log_configuration")

    @log_configuration.setter
    def log_configuration(self, value: Optional[pulumi.Input['SessionLoggerLogConfigurationArgs']]):
        pulumi.set(self, "log_configuration", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sessionLoggerArn")
    def session_logger_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the session logger.
        """
        return pulumi.get(self, "session_logger_arn")

    @session_logger_arn.setter
    def session_logger_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "session_logger_arn", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:workspacesweb/sessionLogger:SessionLogger")
class SessionLogger(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 customer_managed_key: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 event_filter: Optional[pulumi.Input[Union['SessionLoggerEventFilterArgs', 'SessionLoggerEventFilterArgsDict']]] = None,
                 log_configuration: Optional[pulumi.Input[Union['SessionLoggerLogConfigurationArgs', 'SessionLoggerLogConfigurationArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Resource for managing an AWS WorkSpaces Web Session Logger.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_bucket = aws.s3.Bucket("example", bucket="example-session-logs")
        example = aws.iam.get_policy_document_output(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["workspaces-web.amazonaws.com"],
            }],
            "actions": ["s3:PutObject"],
            "resources": [example_bucket.arn.apply(lambda arn: f"{arn}/*")],
        }])
        example_bucket_policy = aws.s3.BucketPolicy("example",
            bucket=example_bucket.id,
            policy=example.json)
        example_session_logger = aws.workspacesweb.SessionLogger("example",
            display_name="example-session-logger",
            event_filter={
                "all": {},
            },
            log_configuration={
                "s3": {
                    "bucket": example_bucket.id,
                    "folder_structure": "Flat",
                    "log_file_format": "Json",
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[example_bucket_policy]))
        ```

        ### Complete Configuration with KMS Encryption

        ```python
        import pulumi
        import pulumi_aws as aws

        example_bucket = aws.s3.Bucket("example",
            bucket="example-session-logs",
            force_destroy=True)
        example = aws.iam.get_policy_document_output(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["workspaces-web.amazonaws.com"],
            }],
            "actions": ["s3:PutObject"],
            "resources": [
                example_bucket.arn,
                example_bucket.arn.apply(lambda arn: f"{arn}/*"),
            ],
        }])
        example_bucket_policy = aws.s3.BucketPolicy("example",
            bucket=example_bucket.id,
            policy=example.json)
        current = aws.get_partition()
        current_get_caller_identity = aws.get_caller_identity()
        kms_key_policy = aws.iam.get_policy_document(statements=[
            {
                "principals": [{
                    "type": "AWS",
                    "identifiers": [f"arn:{current.partition}:iam::{current_get_caller_identity.account_id}:root"],
                }],
                "actions": ["kms:*"],
                "resources": ["*"],
            },
            {
                "principals": [{
                    "type": "Service",
                    "identifiers": ["workspaces-web.amazonaws.com"],
                }],
                "actions": [
                    "kms:Encrypt",
                    "kms:GenerateDataKey*",
                    "kms:ReEncrypt*",
                    "kms:Decrypt",
                ],
                "resources": ["*"],
            },
        ])
        example_key = aws.kms.Key("example",
            description="KMS key for WorkSpaces Web Session Logger",
            policy=kms_key_policy.json)
        example_session_logger = aws.workspacesweb.SessionLogger("example",
            display_name="example-session-logger",
            customer_managed_key=example_key.arn,
            additional_encryption_context={
                "Environment": "Production",
                "Application": "WorkSpacesWeb",
            },
            event_filter={
                "includes": [
                    "SessionStart",
                    "SessionEnd",
                ],
            },
            log_configuration={
                "s3": {
                    "bucket": example_bucket.id,
                    "bucket_owner": current_get_caller_identity.account_id,
                    "folder_structure": "NestedByDate",
                    "key_prefix": "workspaces-web-logs/",
                    "log_file_format": "JsonLines",
                },
            },
            tags={
                "Name": "example-session-logger",
                "Environment": "Production",
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    example_bucket_policy,
                    example_key,
                ]))
        ```

        ## Import

        Using `pulumi import`, import WorkSpaces Web Session Logger using the `session_logger_arn`. For example:

        ```sh
        $ pulumi import aws:workspacesweb/sessionLogger:SessionLogger example arn:aws:workspaces-web:us-west-2:123456789012:sessionLogger/session_logger-id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_encryption_context: Map of additional encryption context key-value pairs.
        :param pulumi.Input[_builtins.str] customer_managed_key: ARN of the customer managed KMS key used to encrypt sensitive information.
        :param pulumi.Input[_builtins.str] display_name: Human-readable display name for the session logger resource. Forces replacement if changed.
        :param pulumi.Input[Union['SessionLoggerEventFilterArgs', 'SessionLoggerEventFilterArgsDict']] event_filter: Event filter that determines which events are logged. See Event Filter below.
        :param pulumi.Input[Union['SessionLoggerLogConfigurationArgs', 'SessionLoggerLogConfigurationArgsDict']] log_configuration: Configuration block for specifying where logs are delivered. See Log Configuration below.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SessionLoggerArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS WorkSpaces Web Session Logger.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_bucket = aws.s3.Bucket("example", bucket="example-session-logs")
        example = aws.iam.get_policy_document_output(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["workspaces-web.amazonaws.com"],
            }],
            "actions": ["s3:PutObject"],
            "resources": [example_bucket.arn.apply(lambda arn: f"{arn}/*")],
        }])
        example_bucket_policy = aws.s3.BucketPolicy("example",
            bucket=example_bucket.id,
            policy=example.json)
        example_session_logger = aws.workspacesweb.SessionLogger("example",
            display_name="example-session-logger",
            event_filter={
                "all": {},
            },
            log_configuration={
                "s3": {
                    "bucket": example_bucket.id,
                    "folder_structure": "Flat",
                    "log_file_format": "Json",
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[example_bucket_policy]))
        ```

        ### Complete Configuration with KMS Encryption

        ```python
        import pulumi
        import pulumi_aws as aws

        example_bucket = aws.s3.Bucket("example",
            bucket="example-session-logs",
            force_destroy=True)
        example = aws.iam.get_policy_document_output(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["workspaces-web.amazonaws.com"],
            }],
            "actions": ["s3:PutObject"],
            "resources": [
                example_bucket.arn,
                example_bucket.arn.apply(lambda arn: f"{arn}/*"),
            ],
        }])
        example_bucket_policy = aws.s3.BucketPolicy("example",
            bucket=example_bucket.id,
            policy=example.json)
        current = aws.get_partition()
        current_get_caller_identity = aws.get_caller_identity()
        kms_key_policy = aws.iam.get_policy_document(statements=[
            {
                "principals": [{
                    "type": "AWS",
                    "identifiers": [f"arn:{current.partition}:iam::{current_get_caller_identity.account_id}:root"],
                }],
                "actions": ["kms:*"],
                "resources": ["*"],
            },
            {
                "principals": [{
                    "type": "Service",
                    "identifiers": ["workspaces-web.amazonaws.com"],
                }],
                "actions": [
                    "kms:Encrypt",
                    "kms:GenerateDataKey*",
                    "kms:ReEncrypt*",
                    "kms:Decrypt",
                ],
                "resources": ["*"],
            },
        ])
        example_key = aws.kms.Key("example",
            description="KMS key for WorkSpaces Web Session Logger",
            policy=kms_key_policy.json)
        example_session_logger = aws.workspacesweb.SessionLogger("example",
            display_name="example-session-logger",
            customer_managed_key=example_key.arn,
            additional_encryption_context={
                "Environment": "Production",
                "Application": "WorkSpacesWeb",
            },
            event_filter={
                "includes": [
                    "SessionStart",
                    "SessionEnd",
                ],
            },
            log_configuration={
                "s3": {
                    "bucket": example_bucket.id,
                    "bucket_owner": current_get_caller_identity.account_id,
                    "folder_structure": "NestedByDate",
                    "key_prefix": "workspaces-web-logs/",
                    "log_file_format": "JsonLines",
                },
            },
            tags={
                "Name": "example-session-logger",
                "Environment": "Production",
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    example_bucket_policy,
                    example_key,
                ]))
        ```

        ## Import

        Using `pulumi import`, import WorkSpaces Web Session Logger using the `session_logger_arn`. For example:

        ```sh
        $ pulumi import aws:workspacesweb/sessionLogger:SessionLogger example arn:aws:workspaces-web:us-west-2:123456789012:sessionLogger/session_logger-id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param SessionLoggerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SessionLoggerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 customer_managed_key: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 event_filter: Optional[pulumi.Input[Union['SessionLoggerEventFilterArgs', 'SessionLoggerEventFilterArgsDict']]] = None,
                 log_configuration: Optional[pulumi.Input[Union['SessionLoggerLogConfigurationArgs', 'SessionLoggerLogConfigurationArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SessionLoggerArgs.__new__(SessionLoggerArgs)

            __props__.__dict__["additional_encryption_context"] = additional_encryption_context
            __props__.__dict__["customer_managed_key"] = customer_managed_key
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["event_filter"] = event_filter
            __props__.__dict__["log_configuration"] = log_configuration
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["associated_portal_arns"] = None
            __props__.__dict__["session_logger_arn"] = None
            __props__.__dict__["tags_all"] = None
        super(SessionLogger, __self__).__init__(
            'aws:workspacesweb/sessionLogger:SessionLogger',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            associated_portal_arns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            customer_managed_key: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            event_filter: Optional[pulumi.Input[Union['SessionLoggerEventFilterArgs', 'SessionLoggerEventFilterArgsDict']]] = None,
            log_configuration: Optional[pulumi.Input[Union['SessionLoggerLogConfigurationArgs', 'SessionLoggerLogConfigurationArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            session_logger_arn: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'SessionLogger':
        """
        Get an existing SessionLogger resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_encryption_context: Map of additional encryption context key-value pairs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] associated_portal_arns: List of ARNs of the web portals associated with the session logger.
        :param pulumi.Input[_builtins.str] customer_managed_key: ARN of the customer managed KMS key used to encrypt sensitive information.
        :param pulumi.Input[_builtins.str] display_name: Human-readable display name for the session logger resource. Forces replacement if changed.
        :param pulumi.Input[Union['SessionLoggerEventFilterArgs', 'SessionLoggerEventFilterArgsDict']] event_filter: Event filter that determines which events are logged. See Event Filter below.
        :param pulumi.Input[Union['SessionLoggerLogConfigurationArgs', 'SessionLoggerLogConfigurationArgsDict']] log_configuration: Configuration block for specifying where logs are delivered. See Log Configuration below.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] session_logger_arn: ARN of the session logger.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SessionLoggerState.__new__(_SessionLoggerState)

        __props__.__dict__["additional_encryption_context"] = additional_encryption_context
        __props__.__dict__["associated_portal_arns"] = associated_portal_arns
        __props__.__dict__["customer_managed_key"] = customer_managed_key
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["event_filter"] = event_filter
        __props__.__dict__["log_configuration"] = log_configuration
        __props__.__dict__["region"] = region
        __props__.__dict__["session_logger_arn"] = session_logger_arn
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return SessionLogger(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="additionalEncryptionContext")
    def additional_encryption_context(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of additional encryption context key-value pairs.
        """
        return pulumi.get(self, "additional_encryption_context")

    @_builtins.property
    @pulumi.getter(name="associatedPortalArns")
    def associated_portal_arns(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of ARNs of the web portals associated with the session logger.
        """
        return pulumi.get(self, "associated_portal_arns")

    @_builtins.property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ARN of the customer managed KMS key used to encrypt sensitive information.
        """
        return pulumi.get(self, "customer_managed_key")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Human-readable display name for the session logger resource. Forces replacement if changed.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="eventFilter")
    def event_filter(self) -> pulumi.Output[Optional['outputs.SessionLoggerEventFilter']]:
        """
        Event filter that determines which events are logged. See Event Filter below.
        """
        return pulumi.get(self, "event_filter")

    @_builtins.property
    @pulumi.getter(name="logConfiguration")
    def log_configuration(self) -> pulumi.Output[Optional['outputs.SessionLoggerLogConfiguration']]:
        """
        Configuration block for specifying where logs are delivered. See Log Configuration below.

        The following arguments are optional:
        """
        return pulumi.get(self, "log_configuration")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="sessionLoggerArn")
    def session_logger_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the session logger.
        """
        return pulumi.get(self, "session_logger_arn")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

