from typing import Literal

UNIT_OF_MEASUREMENT = Literal[
    "mVA",
    "VA",
    "mW",
    "W",
    "kW",
    "MW",
    "GW",
    "TW",
    "BTU/h",
    "mvar",
    "var",
    "kvar",
    "J",
    "kJ",
    "MJ",
    "GJ",
    "mWh",
    "Wh",
    "kWh",
    "MWh",
    "GWh",
    "TWh",
    "cal",
    "kcal",
    "Mcal",
    "Gcal",
    "varh",
    "kvarh",
    "kWh/100km",
    "Wh/km",
    "mi/kWh",
    "km/kWh",
    "mA",
    "A",
    "µV",
    "mV",
    "V",
    "kV",
    "MV",
    "°C",
    "°F",
    "K",
    "μs",
    "ms",
    "s",
    "min",
    "h",
    "d",
    "w",
    "m",
    "y",
    "mm",
    "cm",
    "m",
    "km",
    "in",
    "ft",
    "yd",
    "mi",
    "nmi",
    "Hz",
    "kHz",
    "MHz",
    "GHz",
    "Pa",
    "hPa",
    "kPa",
    "bar",
    "cbar",
    "mbar",
    "mmHg",
    "inHg",
    "psi",
    "dB",
    "dBA",
    "ft³",
    "CCF",
    "m³",
    "L",
    "mL",
    "gal",
    "fl. oz.",
    "m³/h",
    "m³/s",
    "ft³/min",
    "L/h",
    "L/min",
    "L/s",
    "gal/min",
    "mL/s",
    "m²",
    "cm²",
    "km²",
    "mm²",
    "in²",
    "ft²",
    "yd²",
    "mi²",
    "ac",
    "ha",
    "g",
    "kg",
    "mg",
    "µg",
    "oz",
    "lb",
    "st",
    "S/cm",
    "µS/cm",
    "mS/cm",
    "W/m²",
    "BTU/(h⋅ft²)",
    "in/d",
    "in/h",
    "mm/d",
    "mm/h",
    "in",
    "mm",
    "cm",
    "mg/dL",
    "mmol/L",
    "Beaufort",
    "ft/s",
    "in/s",
    "m/s",
    "km/h",
    "kn",
    "mph",
    "mm/s",
    "bit",
    "kbit",
    "Mbit",
    "Gbit",
    "B",
    "kB",
    "MB",
    "GB",
    "TB",
    "PB",
    "EB",
    "ZB",
    "YB",
    "KiB",
    "MiB",
    "GiB",
    "TiB",
    "PiB",
    "EiB",
    "ZiB",
    "YiB",
    "bit/s",
    "kbit/s",
    "Mbit/s",
    "Gbit/s",
    "B/s",
    "kB/s",
    "MB/s",
    "GB/s",
    "KiB/s",
    "MiB/s",
    "GiB/s",
    "°",
    "$",
    "€",
    "¢",
    "dB",
    "dBm",
    "g/m³",
    "µg/m³",
    "mg/m³",
    "μg/ft³",
    "p/m³",
    "ppm",
    "ppb",
    "lx",
    "UV index",
    "%",
    "rpm",
]

DEVICE_CLASS = Literal[
    "date",
    "enum",
    "timestamp",
    "absolute_humidity",
    "apparent_power",
    "aqi",
    "area",
    "atmospheric_pressure",
    "battery",
    "blood_glucose_concentration",
    "carbon_monoxide",
    "carbon_dioxide",
    "conductivity",
    "current",
    "data_rate",
    "data_size",
    "distance",
    "duration",
    "energy",
    "energy_distance",
    "energy_storage",
    "frequency",
    "gas",
    "humidity",
    "illuminance",
    "irradiance",
    "moisture",
    "monetary",
    "nitrogen_dioxide",
    "nitrogen_monoxide",
    "nitrous_oxide",
    "ozone",
    "ph",
    "pm1",
    "pm10",
    "pm25",
    "power_factor",
    "power",
    "precipitation",
    "precipitation_intensity",
    "pressure",
    "reactive_energy",
    "reactive_power",
    "signal_strength",
    "sound_pressure",
    "speed",
    "sulphur_dioxide",
    "temperature",
    "volatile_organic_compounds",
    "volatile_organic_compounds_parts",
    "voltage",
    "volume",
    "volume_storage",
    "volume_flow_rate",
    "water",
    "weight",
    "wind_direction",
    "wind_speed",
]

STATE_CLASS = Literal["measurement", "measurement_angle", "total", "total_increasing"]
