"""Generated by Django 5.0.6 on 2024-06-06 02:22."""

import os
from contextlib import suppress
from pathlib import Path

import django.db.models.deletion
from django.db import migrations, models

from codex.models.util import get_sort_name

CONFIG_PATH = Path(os.environ.get("CODEX_CONFIG_DIR", Path.cwd() / "config"))
COVER_ROOT = CONFIG_PATH / "cache" / "covers"
_GROUP_MODEL_NAMES = (
    "publisher",
    "imprint",
    "series",
    "storyarc",
    "folder",
    "comic",
)


def _set_sort_name(obj):
    """Create sort_name for model."""
    obj.sort_name = get_sort_name(obj.name)


def _generate_sort_name(apps, _schema_editor):
    """Update new sort_name field."""
    for model_name in _GROUP_MODEL_NAMES:
        model = apps.get_model("codex", model_name)
        update_fields = ("sort_name",)
        only_fields = ("name", *update_fields)
        update_groups = []
        objs = model.objects.only(*only_fields)
        for obj in objs:
            _set_sort_name(obj)
            update_groups.append(obj)
        if update_groups:
            model.objects.bulk_update(update_groups, update_fields)
            print(f"\tUpdated sort_name for {len(update_groups)} {model_name}s")


def _remove_cover_symlinks(_apps, _schema_editor):
    """Remove old missing cover symlinks."""
    # Handled programmatically now.
    count = 0
    for dirpath_str, _, filenames in os.walk(COVER_ROOT):
        dirpath = Path(dirpath_str)
        for filename in filenames:
            full_path = dirpath / filename
            if full_path.is_symlink():
                with suppress(OSError):
                    full_path.unlink(missing_ok=True)
                    count += 1
    if count:
        print(f"Removed {count} missing-cover symlinks from cover cache.")


class Migration(migrations.Migration):
    """Migrate db."""

    dependencies = [
        ("codex", "0026_comicbox_1"),
    ]

    operations = [
        migrations.AddField(
            model_name="comic",
            name="sort_name",
            field=models.CharField(db_index=True, default="", max_length=128),
        ),
        migrations.AddField(
            model_name="folder",
            name="sort_name",
            field=models.CharField(db_index=True, default="", max_length=128),
        ),
        migrations.AddField(
            model_name="imprint",
            name="sort_name",
            field=models.CharField(db_index=True, default="", max_length=128),
        ),
        migrations.AddField(
            model_name="library",
            name="covers_only",
            field=models.BooleanField(db_index=True, default=False),
        ),
        migrations.AddField(
            model_name="publisher",
            name="sort_name",
            field=models.CharField(db_index=True, default="", max_length=128),
        ),
        migrations.AddField(
            model_name="series",
            name="sort_name",
            field=models.CharField(db_index=True, default="", max_length=128),
        ),
        migrations.AddField(
            model_name="storyarc",
            name="sort_name",
            field=models.CharField(db_index=True, default="", max_length=128),
        ),
        migrations.AlterField(
            model_name="adminflag",
            name="key",
            field=models.CharField(
                choices=[
                    ("FV", "Folder View"),
                    ("RG", "Registration"),
                    ("NU", "Non Users"),
                    ("AU", "Auto Update"),
                    ("SO", "Search Index Optimize"),
                    ("IM", "Import Metadata"),
                ],
                db_index=True,
                max_length=2,
            ),
        ),
        migrations.AlterField(
            model_name="librarianstatus",
            name="status_type",
            field=models.CharField(
                choices=[
                    ("CCC", "Create Covers"),
                    ("CCD", "Purge Covers"),
                    ("CFO", "Find Orphan"),
                    ("IDM", "Dirs Moved"),
                    ("IFM", "Files Moved"),
                    ("ITR", "Aggregate Tags"),
                    ("ITQ", "Query Missing Fks"),
                    ("ITC", "Create Fks"),
                    ("IDU", "Dirs Modified"),
                    ("IFU", "Files Modified"),
                    ("IFC", "Files Created"),
                    ("IMQ", "Query M2M Fields"),
                    ("IMC", "Link M2M Fields"),
                    ("IDD", "Dirs Deleted"),
                    ("IFD", "Files Deleted"),
                    ("IFI", "Failed Imports"),
                    ("ICQ", "Query Missing Covers"),
                    ("ICM", "Covers Moved"),
                    ("ICU", "Covers Modified"),
                    ("ICC", "Covers Created"),
                    ("ICD", "Covers Deleted"),
                    ("ICL", "Covers Link"),
                    ("IGU", "Group Update"),
                    ("IAF", "Adopt Folders"),
                    ("JTD", "Cleanup Fk"),
                    ("JCU", "Codex Update"),
                    ("JCR", "Codex Restart"),
                    ("JCS", "Codex Stop"),
                    ("JDO", "Db Optimize"),
                    ("JDB", "Db Backup"),
                    ("JSD", "Cleanup Sessions"),
                    ("JCD", "Cleanup Covers"),
                    ("SIX", "Search Index Clear"),
                    ("SIU", "Search Index Update"),
                    ("SID", "Search Index Remove"),
                    ("SIM", "Search Index Merge"),
                    ("WPO", "Poll"),
                ],
                db_index=True,
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="timestamp",
            name="key",
            field=models.CharField(
                choices=[
                    ("JA", "Janitor"),
                    ("VR", "Codex Version"),
                    ("SI", "Search Index UUID"),
                    ("AP", "API Key"),
                ],
                db_index=True,
                max_length=2,
            ),
        ),
        migrations.CreateModel(
            name="CustomCover",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("path", models.CharField(db_index=True, max_length=4095)),
                ("stat", models.JSONField(null=True)),
                (
                    "group",
                    models.CharField(
                        choices=[
                            ("p", "P"),
                            ("i", "I"),
                            ("s", "S"),
                            ("a", "A"),
                            ("f", "F"),
                        ],
                        db_index=True,
                        max_length=1,
                    ),
                ),
                (
                    "sort_name",
                    models.CharField(db_index=True, default="", max_length=128),
                ),
                (
                    "library",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="codex.library"
                    ),
                ),
            ],
            options={
                "get_latest_by": "updated_at",
                "abstract": False,
                "unique_together": {("library", "path")},
            },
        ),
        migrations.AddField(
            model_name="folder",
            name="custom_cover",
            field=models.ForeignKey(
                default=None,
                null=True,
                on_delete=django.db.models.deletion.SET_DEFAULT,
                to="codex.customcover",
            ),
        ),
        migrations.AddField(
            model_name="imprint",
            name="custom_cover",
            field=models.ForeignKey(
                default=None,
                null=True,
                on_delete=django.db.models.deletion.SET_DEFAULT,
                to="codex.customcover",
            ),
        ),
        migrations.AddField(
            model_name="publisher",
            name="custom_cover",
            field=models.ForeignKey(
                default=None,
                null=True,
                on_delete=django.db.models.deletion.SET_DEFAULT,
                to="codex.customcover",
            ),
        ),
        migrations.AddField(
            model_name="series",
            name="custom_cover",
            field=models.ForeignKey(
                default=None,
                null=True,
                on_delete=django.db.models.deletion.SET_DEFAULT,
                to="codex.customcover",
            ),
        ),
        migrations.AddField(
            model_name="storyarc",
            name="custom_cover",
            field=models.ForeignKey(
                default=None,
                null=True,
                on_delete=django.db.models.deletion.SET_DEFAULT,
                to="codex.customcover",
            ),
        ),
        migrations.RunPython(_generate_sort_name),
        migrations.RunPython(_remove_cover_symlinks),
    ]
