## Factuality Detection in Generative AI

This repository contains the source code and plugin configuration for our paper [Factuality Detection in Generative AI: A Tool Augmented Framework for Multi-Task and Multi-Domain Scenarios]().

Factool is a tool augmented framework for detecting factual errors of texts generated by large language models (e.g., ChatGPT). 

Factool now supports 4 tasks: 
* **knowledge-based QA**: Factool detects factual errors in knowledge-based QA.
* **code generation**: Factool detects execution errors in code generation.
* **mathematical reasoning**: Factool detects calculation errors in mathematical reasoning.
* **scientific literature review**: Factool detects hallucinated scientific literatures.

<p align="center"> 
<img src="./figure/factool.png" width="300"/>
 </p>

## Installation

### For General User

```bash
pip install factool
```


### For Developer

```bash
git clone git@github.com:GAIR-NLP/factool.git
cd factool
pip install -e .
``` 
 

## Quick Start:


### Knowledge-based QA

```python
export OPENAI_API_KEY=...
export SERPER_API_KEY=...
```
where you can
* get your OpenAI API key from [here](https://beta.openai.com/).
* get your Serper API key from [here](https://serpapi.com/).


```python
from factool  import Factool

factool_instance = Factool("gpt-3.5-turbo")

inputs = [
            {
                "prompt": "Introduce Graham Neubig",
                "response": "Graham Neubig is a professor at MIT",
                "category": "kbqa",
                "entry_point": "answer_question",
            },
]
response_list = factool_instance.run(inputs)

print(response_list)
```

where
* `prompt`: the prompt for the model to generate the response.
* `response`: the response generated by the model.
* `category`: the category of the task. it could be:
    * `kbqa`
    * `code`
    * `math`
    * `sci`
* `entry_point`: The function name of the code snippet to be fact-checked in the response. Could be "null" if the response doesn't contain any code snippet.



The response_list should following the following format:

```python
[
    {
        'prompt': prompt_1, 
        'response': response_1, 
        'category': 'kbqa', 
        'claims': [claim_11, claim_12, ..., claims_1n], 
        'queries': [[query_111, query_112], [query_121, query_122], ..[query_1n1, query_1n2]], 
        'evidences': [[evidences_11], [evidences_12], ..., [evidences_1n]], 
        'claim_level_factuality': [{claim_11, reasoning_11, error_11, correction_11, factuality_11}, {claim_12, reasoning_12, error_12, correction_12, factuality_12}, ..., {claim_1n, reasoning_1n, error_1n, correction_1n, factuality_1n}], 
        'response_level_factuality': factuality_1
    },
    {
        'prompt': prompt_2, 
        'response': response_2, 
        'category': 'kbqa',
        'claims': [claim_21, claim_22, ..., claims_2n], 
        'queries': [[query_211, query_212], [query_221, query_222], ..., [query_2n1, query_2n2]], 
        'evidences': [[evidences_21], [evidences_22], ..., [evidences_2n]], 
        'claim_level_factuality': [{claim_21, reasoning_21, error_21, correction_21, factuality_21}, {claim_22, reasoning_22, error_22, correction_22, factuality_22}, ..., {claim_2n, reasoning_2n, error_2n, correction_2n, factuality_2n}],
        'response_level_factuality': factuality_2,
    },
    ...
]
```

In this case, you will get:


```json
[
  {
    'prompt': 'Introduce Graham Neubig',
    'response': 'Graham Neubig is a professor at MIT',
    'category': 'kbqa',
    'entry_point': 'answer_question',
    'claims': [{'claim': 'Graham Neubig is a professor at MIT'}],
    'queries': [['Is Graham Neubig a professor at MIT?', 'Graham Neubig MIT']],
    'evidences': [['I am an Associate Professor of Computer Science at Carnegie Mellon University and CEO of Inspired Cognition. My research and development focuses on AI and ...', 'Graham Neubig. I am an Associate Professor at the Carnegie Mellon University Language Technology Institute in the School of Computer Science, and work with ...', 'Missing: MIT? | Must include:MIT?.', 'Associate Professor, Language Technology Institute, Carnegie Mellon University Affiliated Faculty, Machine Learning Department, Carnegie Mellon University', 'Missing: MIT? | Must include:MIT?.', 'I am an Associate Professor at the Carnegie Mellon University Language Technology Institute in the School of Computer Science, and work with a bunch of great ...', 'Missing: MIT | Must include:MIT.', 'I am an Associate Professor of Computer Science at Carnegie Mellon University and CEO of Inspired Cognition. My research and development focuses on AI and ...', 'was heavily inspired by an MIT PhD thesis finished 16 years earlier in 1996! ... Episode 22 of The Thesis Review: Graham Neubig (@gneubig), ...', 'Graham Neubig,. Graham Neubig. Graduate School of Information Science Nara Institute of Science and Technology. Search for other works by this author on:.']],
    'claim_level_factuality': [{'reasoning': 'The given text states that Graham Neubig is a professor at MIT. However, the provided evidences consistently mention that Graham Neubig is an Associate Professor at Carnegie Mellon University. There is no mention of Graham Neubig being affiliated with MIT in any of the provided evidences.', 'error': 'The given text Falsely states that Graham Neubig is a professor at MIT.', 'correction': 'Graham Neubig is an Associate Professor at Carnegie Mellon University.', 'factuality': False, 'claim': 'Graham Neubig is a professor at MIT'}],
    'response_level_factuality': False
  }
]
```



### Code

### Math

### Scientific Literature Review

 






## Steps for setting up FACTOOL ChatGPT Plugin:
1. Install the package: [Installation](#installation)
2. git clone the repo: `git clone https://github.com/GAIR-NLP/factool.git`
3. `cd ./factool/plugin_config`
4. Create your `keys.yaml`
5. Run the API locally: `uvicorn main:app --host 0.0.0.0 --port ${PORT:-5003}`
6. Enter plugin store of [ChatGPT Website](https://chat.openai.com/?model=gpt-4-plugins)
7. Click 'develop your own plugin' then enter the website domain `localhost: 5003` under 'domain'.

## Experiments:

1. Experimental results:

- Exp I: `.results/knowledge_QA/RoSE/`

- Exp II: `.results/knowledge_QA`, `.results/code`, `.results/math`, `.results/scientific`

- Exp III `.results/chat`

2. Get the final results and statistics for fine-grained analysis:

- Exp I: `python ./results/knowledge_QA/RoSE/run_rose_claim_extraction.py`

- Exp II: `bash ./results/evaluation.sh`

- Exp III: `python ./results/chat/calc_stats.py`

3. Reimplement the experiments:

- Exp II: `bash run_experiments.sh`

- Exp III: `bash run_chatbot.sh`