import os


def format_query(
    input: dict,
    provide_domain_knowledge: bool = False,
    provide_workflow_tags: bool = False,
):
    """
    This function constructs a full query with metadata details.
    Args:
        input (dict): The task input containing query, question_type, data_folder, and metadata.
        provide_domain_knowledge (bool): Whether to provide domain knowledge.
        provide_workflow_tags (bool): Whether to provide workflow tags.
    Returns:
        formatted_query (str): The query to be sent to the solver.
    """
    dataset_meta = ""
    for dataset_metadata in input["metadata"]["datasets"]:
        dataset_meta += (
            "Dataset path: "
            + os.path.join(input["data_folder"], dataset_metadata["name"])
            + "\n"
        )
        dataset_meta += "Dataset description: " + dataset_metadata["description"] + "\n"
        dataset_meta += "\nBrief description of columns: " + "\n"
        for col in dataset_metadata["columns"]["raw"]:
            dataset_meta += col["name"] + ": " + col["description"] + ", " + "\n"

    formatted_query = dataset_meta

    formatted_query += f"\nQuery: {input['query']}"

    if provide_domain_knowledge:
        formatted_query += (
            "\nAdditionally, we provide some hints that might be useful to solve the task. Domain Knowledge: \n"
            + input["metadata"]["domain_knowledge"]
            + ".\n"
        )

    if provide_workflow_tags:
        formatted_query += (
            "The meta tags are: " + input["metadata"]["workflow_tags"] + ".\n"
        )

    formatted_query += """
    In the final answer, please output a json containing two keys: 
    
    {
        'hypothesis': SCIENTIFIC HYPOTHESIS,
        'workflow': WORKFLOW SUMMARY
    }

    where 
    the SCIENTIFIC HYPOTHESIS is a natural language hypothesis, derived from the provided dataset, clearly stating the context of hypothesis (if any), variables chosen (if any) and relationship between those variables (if any) including any statistical significance. Please include all numeric information as necessary to support the hypothesis.
    
    and 

    the WORKFLOW SUMMARY is a summary of the full workflow starting from data loading that led to the final hypothesis.
    """

    return formatted_query
