"""A simple calculator tool that can be used for testing."""

import logging

logger = logging.getLogger(__name__)


async def calculator(
    op: str,
    num1: float | int,
    num2: float | int,
) -> float | int:
    """
    Perform a basic arithmetic operation.

    Args:
        op: The operation to perform. One of "+", "-", "*", or "/".
        num1: The first number.
        num2: The second number.
    """
    if op == "+":
        return num1 + num2
    elif op == "-":
        return num1 - num2
    elif op == "*":
        return num1 * num2
    elif op == "/":
        return num1 / num2
    else:
        raise ValueError(f"Unknown operation: {op}")
