from .types import ResponsesMessage as ResponsesMessage, ResponsesPart as ResponsesPart, Role as Role
from dataclasses import dataclass
from typing import Any

@dataclass
class Message:
    role: str
    content: str
    name: str | None = ...
    def __post_init__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...

@dataclass
class StructuredPrompt:
    name: str
    system_message: str | None = ...
    developer_message: str | None = ...
    conversation: list[Message] | None = ...
    def __post_init__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    @classmethod
    def from_promptdown_string(cls, promptdown_string: str) -> StructuredPrompt: ...
    @classmethod
    def from_promptdown_file(cls, file_path: str) -> StructuredPrompt: ...
    @classmethod
    def from_package_resource(cls, package: str, resource_name: str) -> StructuredPrompt: ...
    def to_promptdown_string(self) -> str: ...
    def to_promptdown_file(self, file_path: str) -> None: ...
    def to_chat_completion_messages(self) -> list[dict[str, str | list[dict[str, Any]]]]: ...
    def to_responses_input(self, map_system_to_developer: bool = True) -> list[ResponsesMessage]: ...
    def apply_template_values(self, template_values: dict[str, str]) -> None: ...
