# Migration: 0.2 — auth, credentials, secret

This guide maps prior patterns to the new, clearer credential model.

## Before → After

Postgres

```diff
- type: postgres
- credential: pg_local
+ type: postgres
+ auth: pg_local
```

DuckDB

```diff
- with:
-   pg: "{{ get_pg_credential.data.data }}"
-   gcs: "{{ get_gcs_credential.data.data }}"
+ credentials:
+   pg_db: { key: pg_local }
+   gcs_secret: { key: gcs_hmac_local }
```

HTTP

```diff
- headers:
-   Authorization: "Bearer {{ env.API_TOKEN }}"
+ headers:
+   Authorization: "Bearer {{ secret.api_service_token }}"
```

## Plugin behavior changes

- Postgres step resolves connection fields from `auth:`. Non-secret overrides via `with:` are still supported; avoid putting secrets in `with`.
- DuckDB step uses `credentials:` aliases for multiple bindings. Aliases are the native names in DuckDB SQL (e.g., `ATTACH AS pg_db`, `CREATE SECRET gcs_secret`). The engine exposes a convenience `credentials.<alias>.connstr` for Postgres ATTACH.
- HTTP step can read tokens/passwords via `{{ secret.* }}` at runtime.

## Deprecations

- Passing decrypted secrets via `with:` is deprecated.
- Use `auth:` for single-credential steps and `credentials:` for multi-credential bindings.

