"""
Plugin runtime package - Worker infrastructure for all plugins.

This package provides core runtime functionality for plugin execution:

- Task execution: Main entry point for routing tasks to appropriate plugins
- Event reporting: Worker-to-server communication with metadata enrichment
- Retry policy: Retry evaluation and handling
- SQL utilities: SQL statement parsing and processing

These tools are used across all plugin implementations to provide consistent
functionality and reliable communication with the NoETL server.
"""

from noetl.plugin.runtime.execution import execute_task, execute_task_resolved
from noetl.plugin.runtime.events import report_event
from noetl.plugin.runtime.retry import RetryPolicy
from noetl.plugin.runtime.sql import sql_split

__all__ = [
    'execute_task',
    'execute_task_resolved',
    'report_event',
    'RetryPolicy',
    'sql_split',
]
