from pydantic import ValidationError
from noetl.server.api.catalog import CatalogEntry
from noetl.core.common import transform


a = [
    {
        "resource_path": "examples/weather/weather_example",
        "resource_type": "Playbook",
        "resource_version": "0.1.0",
        "content": "apiVersion: noetl.io/v1\nkind: Playbook\nname: weather\npath: examples/weather/weather_example\ndescription: \"Simple weather data workflow\"\n\nworkload:\n  jobId: \"{{ job.uuid }}\"\n  state: ready\n  cities:\n    - name: \"New York\"\n      lat: 40.71\n      lon: -74.01\n  temperature_threshold: 20\n  base_url: \"https://api.open-meteo.com/v1\"\n\nworkflow:\n  - step: start\n    desc: \"Start weather workflow\"\n    next:\n      - when: \"{{ workload.state == 'ready' }}\"\n        then:\n          - step: fetch_weather\n      - else:\n          - step: end\n\n  - step: fetch_weather\n    desc: \"Fetch weather data for the city\"\n    type: workbook\n    task: fetch_weather\n    input:\n      city: \"{{ workload.cities[0] }}\"\n      threshold: \"{{ workload.temperature_threshold }}\"\n      base_url: \"{{ workload.base_url }}\"\n    next:\n      - when: \"{{ fetch_weather.alert }}\"\n        then:\n          - step: report_warm\n            input:\n              city: \"{{ workload.cities[0] }}\"\n              temperature: \"{{ fetch_weather.max_temp }}\"\n      - else:\n          - step: report_cold\n            input:\n              city: \"{{ workload.cities[0] }}\"\n              temperature: \"{{ fetch_weather.max_temp }}\"\n\n  - step: report_warm\n    desc: \"Report warm weather\"\n    type: python\n    input:\n      city: \"{{ city }}\"\n      temperature: \"{{ temperature }}\"\n    code: |\n      def main(city, temperature):\n          city_name = city[\"name\"] if isinstance(city, dict) else str(city)\n          print(f\"It's warm in {city_name} ({temperature}°C)\")\n          return {\"status\": \"warm\", \"city\": city_name, \"temperature\": temperature}\n    next:\n      - step: end\n\n  - step: report_cold\n    desc: \"Report cold weather\"\n    type: python\n    name: report_cold\n    input:\n      city: \"{{ city }}\"\n      temperature: \"{{ temperature }}\"\n    code: |\n      def main(city, temperature):\n          city_name = city[\"name\"] if isinstance(city, dict) else str(city)\n          print(f\"It's cold in {city_name} ({temperature}°C)\")\n          return {\"status\": \"cold\", \"city\": city_name, \"temperature\": temperature}\n    next:\n      - step: end\n\n  - step: end\n    desc: \"End of workflow\"\n\nworkbook:\n  - name: fetch_weather\n    type: python\n    code: |\n      def main(city, threshold, base_url):\n          import httpx\n          threshold = float(threshold) if threshold else 20\n          if isinstance(city, str):\n              city_dict = {\"name\": city, \"lat\": 40.71, \"lon\": -74.01}\n          else:\n              city_dict = city\n          url = f\"{base_url}/forecast\"\n          params = {\n              \"latitude\": city_dict[\"lat\"],\n              \"longitude\": city_dict[\"lon\"],\n              \"hourly\": \"temperature_2m\",\n              \"forecast_days\": 1\n          }\n\n          response = httpx.get(url, params=params)\n          forecast_data = response.json()\n          temps = []\n          if isinstance(forecast_data, dict):\n              hourly = forecast_data.get('hourly', {})\n              if isinstance(hourly, dict) and 'temperature_2m' in hourly:\n                  temps = hourly['temperature_2m']\n          max_temp = max(temps) if temps else 0\n          alert = max_temp > threshold\n\n          # Return result\n          result = {\n              \"city\": city_dict[\"name\"],\n              \"max_temp\": max_temp,\n              \"alert\": alert,\n              \"threshold\": threshold\n          }\n\n          return result\n",
        "meta": {
            "registered_at": "2025-10-01T17:24:18.001125"
        },
        # "timestamp": "2025-10-01T12:24:17.999568-05:00"
    },
    {
        "resource_path": "examples/weather/weather_example",
        "resource_type": "Playbook",
        "resource_version": "0.1.1",
        "content": "apiVersion: noetl.io/v1\nkind: Playbook\nname: weather\npath: examples/weather/weather_example\ndescription: \"Simple weather data workflow\"\n\nworkload:\n  jobId: \"{{ job.uuid }}\"\n  state: ready\n  cities:\n    - name: \"New York\"\n      lat: 40.71\n      lon: -74.01\n  temperature_threshold: 20\n  base_url: \"https://api.open-meteo.com/v1\"\n\nworkflow:\n  - step: start\n    desc: \"Start weather workflow\"\n    next:\n      - when: \"{{ workload.state == 'ready' }}\"\n        then:\n          - step: fetch_weather\n      - else:\n          - step: end\n\n  - step: fetch_weather\n    desc: \"Fetch weather data for the city\"\n    type: workbook\n    task: fetch_weather\n    input:\n      city: \"{{ workload.cities[0] }}\"\n      threshold: \"{{ workload.temperature_threshold }}\"\n      base_url: \"{{ workload.base_url }}\"\n    next:\n      - when: \"{{ fetch_weather.alert }}\"\n        then:\n          - step: report_warm\n            input:\n              city: \"{{ workload.cities[0] }}\"\n              temperature: \"{{ fetch_weather.max_temp }}\"\n      - else:\n          - step: report_cold\n            input:\n              city: \"{{ workload.cities[0] }}\"\n              temperature: \"{{ fetch_weather.max_temp }}\"\n\n  - step: report_warm\n    desc: \"Report warm weather\"\n    type: python\n    input:\n      city: \"{{ city }}\"\n      temperature: \"{{ temperature }}\"\n    code: |\n      def main(city, temperature):\n          city_name = city[\"name\"] if isinstance(city, dict) else str(city)\n          print(f\"It's warm in {city_name} ({temperature}°C)\")\n          return {\"status\": \"warm\", \"city\": city_name, \"temperature\": temperature}\n    next:\n      - step: end\n\n  - step: report_cold\n    desc: \"Report cold weather\"\n    type: python\n    name: report_cold\n    input:\n      city: \"{{ city }}\"\n      temperature: \"{{ temperature }}\"\n    code: |\n      def main(city, temperature):\n          city_name = city[\"name\"] if isinstance(city, dict) else str(city)\n          print(f\"It's cold in {city_name} ({temperature}°C)\")\n          return {\"status\": \"cold\", \"city\": city_name, \"temperature\": temperature}\n    next:\n      - step: end\n\n  - step: end\n    desc: \"End of workflow\"\n\nworkbook:\n  - name: fetch_weather\n    type: python\n    code: |\n      def main(city, threshold, base_url):\n          import httpx\n          threshold = float(threshold) if threshold else 20\n          if isinstance(city, str):\n              city_dict = {\"name\": city, \"lat\": 40.71, \"lon\": -74.01}\n          else:\n              city_dict = city\n          url = f\"{base_url}/forecast\"\n          params = {\n              \"latitude\": city_dict[\"lat\"],\n              \"longitude\": city_dict[\"lon\"],\n              \"hourly\": \"temperature_2m\",\n              \"forecast_days\": 1\n          }\n\n          response = httpx.get(url, params=params)\n          forecast_data = response.json()\n          temps = []\n          if isinstance(forecast_data, dict):\n              hourly = forecast_data.get('hourly', {})\n              if isinstance(hourly, dict) and 'temperature_2m' in hourly:\n                  temps = hourly['temperature_2m']\n          max_temp = max(temps) if temps else 0\n          alert = max_temp > threshold\n\n          # Return result\n          result = {\n              \"city\": city_dict[\"name\"],\n              \"max_temp\": max_temp,\n              \"alert\": alert,\n              \"threshold\": threshold\n          }\n\n          return result\n",
        "meta": {
            "registered_at": "2025-10-01T17:24:18.001125"
        },
        "timestamp": "2025-10-01T12:24:17.999000-05:00"
    }
]
try:
    a = transform(CatalogEntry, a[0])
except ValidationError as e:
    pass
