# This script generated by AI and they'll be refactored later

import inspect
import typing
from typing import get_type_hints, Callable
import re
import json
import yaml

def python_type_to_json_type(py_type):
    origin = typing.get_origin(py_type) or py_type

    if origin in [int]:
        return "integer"
    elif origin in [float]:
        return "number"
    elif origin in [bool]:
        return "boolean"
    elif origin in [str]:
        return "string"
    elif origin in [list, tuple]:
        return "array"
    elif origin in [dict]:
        return "object"
    else:
        return "string"  # fallback

def convert_to_tool(func) -> dict:
    sig = inspect.signature(func)
    type_hints = get_type_hints(func)

    parameters = {
        "type": "object",
        "properties": {},
        "required": []
    }

    for name, param in sig.parameters.items():
        param_type = type_hints.get(name, str)
        param_schema = {"type": python_type_to_json_type(param_type)}
        parameters["properties"][name] = param_schema
        if param.default is param.empty:
            parameters["required"].append(name)

    tool = {
        "name": func.__name__,
        "description": func.__doc__ or "",
        "parameters": parameters
    }

    return tool

def register_tools(tools:list):
    _tools = {}
    for tool in tools:
        tool_definition = convert_to_tool(tool)
        name = tool_definition.get("name", None)
        _tools[name] = {
            "definition": tool_definition,
            "tool": tool
        }
    return _tools

def list_tools(funcs:list[Callable])->str:
    """Use this function for ToolSelector"""
    prompt = []
    for func in funcs:
        name = func.__name__
        definition = str(func.__doc__).strip()
        match = re.search(r'<\|start\|>(.*?)<\|end\|>', definition, re.DOTALL)
        text = match.group(1).strip() if match else ""
        text = re.sub(r'\s+', ' ', text).strip()
        prompt.append(f"\t- {name}: {text}")
    return "\n".join(prompt)

def generate_extract_parameters_prompt(func):
    """Generate a prompt to extract function parameters from user input. It wil be used for ToolCalling (extract parameters and run the function)"""
    sig = inspect.signature(func)
    doc = inspect.getdoc(func) or ""
    
    # Extract description between <|start|> and <|end|>
    desc_match = re.search(r'<\|start\|>(.*?)<\|end\|>', doc, re.DOTALL)
    description = desc_match.group(1).strip() if desc_match else ""
    description = re.sub(r'\s+', ' ', description).strip()
    
    # Build parameter info
    params = []
    for name, param in sig.parameters.items():
        param_type = param.annotation.__name__ if param.annotation != inspect.Parameter.empty else "any"
        params.append(f"- {name} ({param_type})")
    
    # Build YAML template with proper formatting for lists
    yaml_lines = []
    for name, param in sig.parameters.items():
        if param.annotation != inspect.Parameter.empty:
            origin = typing.get_origin(param.annotation) or param.annotation
            if origin in [list, tuple]:
                yaml_lines.append(f"{name}: [<value>]")
            else:
                yaml_lines.append(f"{name}: <value>")
        else:
            yaml_lines.append(f"{name}: <value>")
    
    yaml_template = "\n".join(yaml_lines)
    
    prompt = f"""Extract parameters for the {func.__name__} function from user input and return them in YAML format.

Function: {func.__name__}{sig}
Description: {description}

Parameters:
{chr(10).join(params)}

Return only the YAML format:
```yaml
{yaml_template}
```
User input: {{user_input}}"""
    return prompt

def validate_parameters(params_dict, func):
    """Validate extracted parameters against function signature. This will be used after extracting parameters in tool calling and it'll be validated before feeding into function"""
    sig = inspect.signature(func)
    
    # Check required parameters
    missing = []
    for name, param in sig.parameters.items():
        if param.default is param.empty and name not in params_dict:
            missing.append(name)
    
    if missing:
        return False, f"Missing required parameters: {', '.join(missing)}"
    
    # Check parameter types
    type_hints = get_type_hints(func)
    for name, value in params_dict.items():
        if name in type_hints:
            expected_type = type_hints[name]
            
            # Handle list[float] specifically
            if hasattr(expected_type, '__origin__') and expected_type.__origin__ is list:
                if not isinstance(value, list):
                    return False, f"Parameter '{name}' should be a list"
                
                # Check list elements
                if hasattr(expected_type, '__args__') and expected_type.__args__:
                    element_type = expected_type.__args__[0]
                    if element_type is float:
                        for i, item in enumerate(value):
                            if not isinstance(item, (int, float)):
                                return False, f"Parameter '{name}[{i}]' should be a number, got {type(item).__name__}"
    return True, None

def parse_codeblock_to_dict(output_str, codeblock='yaml'):
    output_str = output_str.split("```"+codeblock)
    if len(output_str)>1:
        output_str = output_str[1]
    else:
        output_str = output_str[-1]
    output_str = output_str.split("```")[0].strip()
    if codeblock=='json':
        return json.loads(output_str)
    return yaml.safe_load(output_str)