# `pyMultiFit`

- [`pyMultiFit`](#pymultifit)
    - [What is `pymultifit`](#what-is-pymultifit)
    - [How to install](#how-to-install)
    - [Documentation](#documentation)

A python multi-fit library for fitting the data with multiple `X` fitters.

![GitHub Release](https://img.shields.io/github/v/release/syedalimohsinbukhari/pymultifit?color=magenta)
![PyPI - Python Version](https://img.shields.io/pypi/pyversions/pymultifit?)
![GitHub-licence](https://img.shields.io/github/license/syedalimohsinbukhari/pymultifit?color=darkblue)
![GiHub-CodeCoverage](https://img.shields.io/codecov/c/github/syedalimohsinbukhari/pymultifit?color=cyan)
[![Project Status](https://www.repostatus.org/badges/latest/active.svg)](https://www.repostatus.org/#active)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.17273507.svg)](https://doi.org/10.5281/zenodo.17273507)
[![pyOpenSci Peer-Reviewed](https://pyopensci.org/badges/peer-reviewed.svg)](https://github.com/pyOpenSci/software-submission/issues/233)
[![status](https://joss.theoj.org/papers/739ef75550f7c096016acf808e796277/status.svg)](https://joss.theoj.org/papers/739ef75550f7c096016acf808e796277)
![GitHub top language](https://img.shields.io/github/languages/top/syedalimohsinbukhari/pymultifit?color=lightgreen)
![GitHub contributors](https://img.shields.io/github/contributors/syedalimohsinbukhari/pymultifit?color=gold)
![Github Issues](https://img.shields.io/github/issues/syedalimohsinbukhari/pymultifit?color=orange)
![GitHub OPEN PRs](https://img.shields.io/github/issues-pr/syedalimohsinbukhari/pymultifit?color=darkred)
![GitHub CLOSED PRs](https://img.shields.io/github/issues-pr-closed/syedalimohsinbukhari/pymultifit?color=darkgreen)

## What is `pymultifit`

`pymultifit` is a library made specifically to tackle one problem, **fit the data with multiple fitters**.

Fitter implementations include,

- `Gaussian` fitter,
- `SkewedNormal` fitter,
- `LogNormal` fitter,
- `Exponential` fitter,
- `Laplace` fitter, and more.

Additionally, it provides capabilities to generated n-modal data as well through its `generators` module.
Along with this, the user can also generate probability distribution data using `distributions` module.

## How to install

Using pip: `pip install pymultifit`

## Documentation

The documentation can be found on [readthedocs](https://pymultifit.readthedocs.io/latest/)
