"""Created on Dec 04 23:24:55 2024"""

import numpy as np

from .backend import BaseFitter
from .utilities_f import sanity_check
from .. import OneDArray, Params_
from ..distributions.utilities_d import folded_normal_pdf_


class FoldedNormalFitter(BaseFitter):
    """A class for fitting multiple FoldedNormal distributions to the given data."""

    def __init__(self, x_values: OneDArray, y_values: OneDArray, max_iterations: int = 1000):
        x_values, y_values = sanity_check(x_values=x_values, y_values=y_values)
        super().__init__(x_values=x_values, y_values=y_values, max_iterations=max_iterations)
        self.n_par = 3

    def fit_boundaries(self):
        lb = [0, -np.inf, 0]
        ub = [np.inf, np.inf, np.inf]
        return lb, ub

    @staticmethod
    def fitter(x, params: Params_):
        return folded_normal_pdf_(x, *params)
