"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudWatchPutMetricAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloudwatch = require("aws-cdk-lib/aws-cloudwatch");
const role_1 = require("./private/role");
/**
 * The action to capture an Amazon CloudWatch metric.
 */
class CloudWatchPutMetricAction {
    constructor(props) {
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_CloudWatchPutMetricActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CloudWatchPutMetricAction);
            }
            throw error;
        }
    }
    /**
     * @internal
     */
    _bind(rule) {
        const role = this.props.role ?? (0, role_1.singletonActionRole)(rule);
        cloudwatch.Metric.grantPutMetricData(role);
        return {
            configuration: {
                cloudwatchMetric: {
                    metricName: this.props.metricName,
                    metricNamespace: this.props.metricNamespace,
                    metricTimestamp: this.props.metricTimestamp,
                    metricUnit: this.props.metricUnit,
                    metricValue: this.props.metricValue,
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
exports.CloudWatchPutMetricAction = CloudWatchPutMetricAction;
_a = JSII_RTTI_SYMBOL_1;
CloudWatchPutMetricAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.CloudWatchPutMetricAction", version: "2.105.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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