"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamoDBv2PutItemAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const role_1 = require("./private/role");
/**
 * The action to put the record from an MQTT message to the DynamoDB table.
 */
class DynamoDBv2PutItemAction {
    /**
     * @param table the DynamoDB table in which to put the items.
     * @param props Optional properties to not use default
     */
    constructor(table, props = {}) {
        this.table = table;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_DynamoDBv2PutItemActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, DynamoDBv2PutItemAction);
            }
            throw error;
        }
        this.role = props.role;
    }
    /**
     * @internal
     */
    _bind(rule) {
        const role = this.role ?? (0, role_1.singletonActionRole)(rule);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['dynamodb:PutItem'],
            resources: [this.table.tableArn],
        }));
        return {
            configuration: {
                dynamoDBv2: {
                    putItem: {
                        tableName: this.table.tableName,
                    },
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
exports.DynamoDBv2PutItemAction = DynamoDBv2PutItemAction;
_a = JSII_RTTI_SYMBOL_1;
DynamoDBv2PutItemAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.DynamoDBv2PutItemAction", version: "2.105.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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