import * as iot from '@aws-cdk/aws-iot-alpha';
import { CommonActionProps } from './common-action-props';
export interface HttpActionSigV4Auth {
    /**
     * The service name.
     */
    readonly serviceName: string;
    /**
     * The signing region.
     */
    readonly signingRegion: string;
}
export interface HttpActionHeader {
    /**
     * The HTTP header key.
     */
    readonly key: string;
    /**
     * The HTTP header value. Substitution templates are supported.
     */
    readonly value: string;
}
/**
 * Configuration properties of an HTTPS action.
 *
 * @see https://docs.aws.amazon.com/iot/latest/developerguide/https-rule-action.html
 */
export interface HttpsActionProps extends CommonActionProps {
    /**
     * If specified, AWS IoT uses the confirmation URL to create a matching topic rule destination.
     */
    readonly confirmationUrl?: string;
    /**
     * The headers to include in the HTTPS request to the endpoint.
     */
    readonly headers?: Array<HttpActionHeader>;
    /**
     * Use Sigv4 authorization.
     */
    readonly auth?: HttpActionSigV4Auth;
}
/**
 * The action to send data from an MQTT message to a web application or service.
 */
export declare class HttpsAction implements iot.IAction {
    private readonly role?;
    private readonly url;
    private readonly confirmationUrl?;
    private readonly headers?;
    private readonly auth?;
    /**
     * @param url The url to which to send post request.
     * @param props Optional properties to not use default.
     */
    constructor(url: string, props?: HttpsActionProps);
    /**
     * @internal
     */
    _bind(topicRule: iot.ITopicRule): iot.ActionConfig;
}
