"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpsAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const role_1 = require("./private/role");
/**
 * The action to send data from an MQTT message to a web application or service.
 */
class HttpsAction {
    /**
     * @param url The url to which to send post request.
     * @param props Optional properties to not use default.
     */
    constructor(url, props = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_HttpsActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HttpsAction);
            }
            throw error;
        }
        this.url = url;
        this.confirmationUrl = props.confirmationUrl;
        this.headers = props.headers;
        this.role = props.role;
        this.auth = props.auth;
    }
    /**
     * @internal
     */
    _bind(topicRule) {
        const role = this.role ?? (0, role_1.singletonActionRole)(topicRule);
        const sigV4 = this.auth ? {
            sigv4: {
                roleArn: role.roleArn,
                serviceName: this.auth.serviceName,
                signingRegion: this.auth.signingRegion,
            },
        } : this.auth;
        return {
            configuration: {
                http: {
                    url: this.url,
                    confirmationUrl: this.confirmationUrl,
                    headers: this.headers,
                    auth: sigV4,
                },
            },
        };
    }
}
exports.HttpsAction = HttpsAction;
_a = JSII_RTTI_SYMBOL_1;
HttpsAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.HttpsAction", version: "2.105.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaHR0cHMtYWN0aW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaHR0cHMtYWN0aW9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUdBLHlDQUFxRDtBQThDckQ7O0dBRUc7QUFDSCxNQUFhLFdBQVc7SUFPdEI7OztPQUdHO0lBQ0gsWUFBYSxHQUFXLEVBQUUsUUFBd0IsRUFBRTs7Ozs7OytDQVh6QyxXQUFXOzs7O1FBWXBCLElBQUksQ0FBQyxHQUFHLEdBQUcsR0FBRyxDQUFDO1FBQ2YsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUMsZUFBZSxDQUFDO1FBQzdDLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQztRQUM3QixJQUFJLENBQUMsSUFBSSxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUM7UUFDdkIsSUFBSSxDQUFDLElBQUksR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDO0tBQ3hCO0lBRUQ7O09BRUc7SUFDSSxLQUFLLENBQUMsU0FBeUI7UUFDcEMsTUFBTSxJQUFJLEdBQUcsSUFBSSxDQUFDLElBQUksSUFBSSxJQUFBLDBCQUFtQixFQUFDLFNBQVMsQ0FBQyxDQUFDO1FBQ3pELE1BQU0sS0FBSyxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO1lBQ3hCLEtBQUssRUFBRTtnQkFDTCxPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU87Z0JBQ3JCLFdBQVcsRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLFdBQVc7Z0JBQ2xDLGFBQWEsRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLGFBQWE7YUFDdkM7U0FDRixDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDO1FBRWQsT0FBTztZQUNMLGFBQWEsRUFBRTtnQkFDYixJQUFJLEVBQUU7b0JBQ0osR0FBRyxFQUFFLElBQUksQ0FBQyxHQUFHO29CQUNiLGVBQWUsRUFBRSxJQUFJLENBQUMsZUFBZTtvQkFDckMsT0FBTyxFQUFFLElBQUksQ0FBQyxPQUFPO29CQUNyQixJQUFJLEVBQUUsS0FBSztpQkFDWjthQUNGO1NBQ0YsQ0FBQztLQUNIOztBQTFDSCxrQ0EyQ0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBpb3QgZnJvbSAnQGF3cy1jZGsvYXdzLWlvdC1hbHBoYSc7XG5pbXBvcnQgKiBhcyBpYW0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWlhbSc7XG5pbXBvcnQgeyBDb21tb25BY3Rpb25Qcm9wcyB9IGZyb20gJy4vY29tbW9uLWFjdGlvbi1wcm9wcyc7XG5pbXBvcnQgeyBzaW5nbGV0b25BY3Rpb25Sb2xlIH0gZnJvbSAnLi9wcml2YXRlL3JvbGUnO1xuXG5leHBvcnQgaW50ZXJmYWNlIEh0dHBBY3Rpb25TaWdWNEF1dGgge1xuICAvKipcbiAgICogVGhlIHNlcnZpY2UgbmFtZS5cbiAgICovXG4gIHJlYWRvbmx5IHNlcnZpY2VOYW1lOiBzdHJpbmc7XG4gIC8qKlxuICAgKiBUaGUgc2lnbmluZyByZWdpb24uXG4gICAqL1xuICByZWFkb25seSBzaWduaW5nUmVnaW9uOiBzdHJpbmc7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgSHR0cEFjdGlvbkhlYWRlciB7XG4gIC8qKlxuICAgKiBUaGUgSFRUUCBoZWFkZXIga2V5LlxuICAgKi9cbiAgcmVhZG9ubHkga2V5OiBzdHJpbmc7XG4gIC8qKlxuICAgKiBUaGUgSFRUUCBoZWFkZXIgdmFsdWUuIFN1YnN0aXR1dGlvbiB0ZW1wbGF0ZXMgYXJlIHN1cHBvcnRlZC5cbiAgICovXG4gIHJlYWRvbmx5IHZhbHVlOiBzdHJpbmc7XG59XG5cbi8qKlxuICogQ29uZmlndXJhdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIEhUVFBTIGFjdGlvbi5cbiAqXG4gKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2h0dHBzLXJ1bGUtYWN0aW9uLmh0bWxcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBIdHRwc0FjdGlvblByb3BzIGV4dGVuZHMgQ29tbW9uQWN0aW9uUHJvcHMge1xuICAvKipcbiAgICogSWYgc3BlY2lmaWVkLCBBV1MgSW9UIHVzZXMgdGhlIGNvbmZpcm1hdGlvbiBVUkwgdG8gY3JlYXRlIGEgbWF0Y2hpbmcgdG9waWMgcnVsZSBkZXN0aW5hdGlvbi5cbiAgICovXG4gIHJlYWRvbmx5IGNvbmZpcm1hdGlvblVybD86IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIGhlYWRlcnMgdG8gaW5jbHVkZSBpbiB0aGUgSFRUUFMgcmVxdWVzdCB0byB0aGUgZW5kcG9pbnQuXG4gICAqL1xuICByZWFkb25seSBoZWFkZXJzPzogQXJyYXk8SHR0cEFjdGlvbkhlYWRlcj47XG5cbiAgLyoqXG4gICAqIFVzZSBTaWd2NCBhdXRob3JpemF0aW9uLlxuICAgKi9cbiAgcmVhZG9ubHkgYXV0aD86IEh0dHBBY3Rpb25TaWdWNEF1dGg7XG59XG5cbi8qKlxuICogVGhlIGFjdGlvbiB0byBzZW5kIGRhdGEgZnJvbSBhbiBNUVRUIG1lc3NhZ2UgdG8gYSB3ZWIgYXBwbGljYXRpb24gb3Igc2VydmljZS5cbiAqL1xuZXhwb3J0IGNsYXNzIEh0dHBzQWN0aW9uIGltcGxlbWVudHMgaW90LklBY3Rpb24ge1xuICBwcml2YXRlIHJlYWRvbmx5IHJvbGU/OiBpYW0uSVJvbGU7XG4gIHByaXZhdGUgcmVhZG9ubHkgdXJsOiBzdHJpbmc7XG4gIHByaXZhdGUgcmVhZG9ubHkgY29uZmlybWF0aW9uVXJsPzogc3RyaW5nO1xuICBwcml2YXRlIHJlYWRvbmx5IGhlYWRlcnM/OiBBcnJheTxIdHRwQWN0aW9uSGVhZGVyPjtcbiAgcHJpdmF0ZSByZWFkb25seSBhdXRoPzogSHR0cEFjdGlvblNpZ1Y0QXV0aDtcblxuICAvKipcbiAgICogQHBhcmFtIHVybCBUaGUgdXJsIHRvIHdoaWNoIHRvIHNlbmQgcG9zdCByZXF1ZXN0LlxuICAgKiBAcGFyYW0gcHJvcHMgT3B0aW9uYWwgcHJvcGVydGllcyB0byBub3QgdXNlIGRlZmF1bHQuXG4gICAqL1xuICBjb25zdHJ1Y3RvciggdXJsOiBzdHJpbmcsIHByb3BzOiBIdHRwc0FjdGlvblByb3BzPXt9KSB7XG4gICAgdGhpcy51cmwgPSB1cmw7XG4gICAgdGhpcy5jb25maXJtYXRpb25VcmwgPSBwcm9wcy5jb25maXJtYXRpb25Vcmw7XG4gICAgdGhpcy5oZWFkZXJzID0gcHJvcHMuaGVhZGVycztcbiAgICB0aGlzLnJvbGUgPSBwcm9wcy5yb2xlO1xuICAgIHRoaXMuYXV0aCA9IHByb3BzLmF1dGg7XG4gIH1cblxuICAvKipcbiAgICogQGludGVybmFsXG4gICAqL1xuICBwdWJsaWMgX2JpbmQodG9waWNSdWxlOiBpb3QuSVRvcGljUnVsZSk6IGlvdC5BY3Rpb25Db25maWcge1xuICAgIGNvbnN0IHJvbGUgPSB0aGlzLnJvbGUgPz8gc2luZ2xldG9uQWN0aW9uUm9sZSh0b3BpY1J1bGUpO1xuICAgIGNvbnN0IHNpZ1Y0ID0gdGhpcy5hdXRoID8ge1xuICAgICAgc2lndjQ6IHtcbiAgICAgICAgcm9sZUFybjogcm9sZS5yb2xlQXJuLFxuICAgICAgICBzZXJ2aWNlTmFtZTogdGhpcy5hdXRoLnNlcnZpY2VOYW1lLFxuICAgICAgICBzaWduaW5nUmVnaW9uOiB0aGlzLmF1dGguc2lnbmluZ1JlZ2lvbixcbiAgICAgIH0sXG4gICAgfSA6IHRoaXMuYXV0aDtcblxuICAgIHJldHVybiB7XG4gICAgICBjb25maWd1cmF0aW9uOiB7XG4gICAgICAgIGh0dHA6IHtcbiAgICAgICAgICB1cmw6IHRoaXMudXJsLFxuICAgICAgICAgIGNvbmZpcm1hdGlvblVybDogdGhpcy5jb25maXJtYXRpb25VcmwsXG4gICAgICAgICAgaGVhZGVyczogdGhpcy5oZWFkZXJzLFxuICAgICAgICAgIGF1dGg6IHNpZ1Y0LFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICB9O1xuICB9XG59Il19