"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IotRepublishMqttAction = exports.MqttQualityOfService = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const role_1 = require("./private/role");
/**
 * MQTT Quality of Service (QoS) indicates the level of assurance for delivery of an MQTT Message.
 *
 * @see https://docs.aws.amazon.com/iot/latest/developerguide/mqtt.html#mqtt-qos
 */
var MqttQualityOfService;
(function (MqttQualityOfService) {
    /**
     * QoS level 0. Sent zero or more times.
     * This level should be used for messages that are sent over reliable communication links or that can be missed without a problem.
     */
    MqttQualityOfService[MqttQualityOfService["ZERO_OR_MORE_TIMES"] = 0] = "ZERO_OR_MORE_TIMES";
    /**
     * QoS level 1. Sent at least one time, and then repeatedly until a PUBACK response is received.
     * The message is not considered complete until the sender receives a PUBACK response to indicate successful delivery.
     */
    MqttQualityOfService[MqttQualityOfService["AT_LEAST_ONCE"] = 1] = "AT_LEAST_ONCE";
})(MqttQualityOfService || (exports.MqttQualityOfService = MqttQualityOfService = {}));
/**
 * The action to put the record from an MQTT message to republish another MQTT topic.
 */
class IotRepublishMqttAction {
    /**
     * @param topic The MQTT topic to which to republish the message.
     * @param props Optional properties to not use default.
     */
    constructor(topic, props = {}) {
        this.topic = topic;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_IotRepublishMqttActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, IotRepublishMqttAction);
            }
            throw error;
        }
        this.qualityOfService = props.qualityOfService;
        this.role = props.role;
    }
    /**
     * @internal
     */
    _bind(rule) {
        const role = this.role ?? (0, role_1.singletonActionRole)(rule);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['iot:Publish'],
            resources: ['*'],
        }));
        return {
            configuration: {
                republish: {
                    topic: this.topic,
                    qos: this.qualityOfService,
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
exports.IotRepublishMqttAction = IotRepublishMqttAction;
_a = JSII_RTTI_SYMBOL_1;
IotRepublishMqttAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.IotRepublishMqttAction", version: "2.105.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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