"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IotEventsPutMessageAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const role_1 = require("./private/role");
/**
 * The action to put the message from an MQTT message to the IoT Events input.
 */
class IotEventsPutMessageAction {
    /**
     * @param input The IoT Events input to put messages.
     * @param props Optional properties to not use default
     */
    constructor(input, props = {}) {
        this.input = input;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_IotEventsPutMessageActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, IotEventsPutMessageAction);
            }
            throw error;
        }
        this.batchMode = props.batchMode;
        this.messageId = props.messageId;
        this.role = props.role;
        if (this.batchMode && this.messageId) {
            throw new Error('messageId is not allowed when batchMode is true');
        }
    }
    /**
     * @internal
     */
    _bind(rule) {
        const role = this.role ?? (0, role_1.singletonActionRole)(rule);
        this.input.grantWrite(role);
        return {
            configuration: {
                iotEvents: {
                    batchMode: this.batchMode,
                    inputName: this.input.inputName,
                    messageId: this.messageId,
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
exports.IotEventsPutMessageAction = IotEventsPutMessageAction;
_a = JSII_RTTI_SYMBOL_1;
IotEventsPutMessageAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.IotEventsPutMessageAction", version: "2.105.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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