"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisPutRecordAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const role_1 = require("./private/role");
/**
 * The action to put the record from an MQTT message to the Kinesis Data stream.
 */
class KinesisPutRecordAction {
    /**
     * @param stream The Kinesis Data stream to which to put records.
     * @param props Optional properties to not use default
     */
    constructor(stream, props) {
        this.stream = stream;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_KinesisPutRecordActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, KinesisPutRecordAction);
            }
            throw error;
        }
        this.partitionKey = props.partitionKey;
        this.role = props.role;
    }
    /**
     * @internal
     */
    _bind(rule) {
        const role = this.role ?? (0, role_1.singletonActionRole)(rule);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['kinesis:PutRecord'],
            resources: [this.stream.streamArn],
        }));
        return {
            configuration: {
                kinesis: {
                    streamName: this.stream.streamName,
                    partitionKey: this.partitionKey || undefined,
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
exports.KinesisPutRecordAction = KinesisPutRecordAction;
_a = JSII_RTTI_SYMBOL_1;
KinesisPutRecordAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.KinesisPutRecordAction", version: "2.105.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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