"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.singletonActionRole = void 0;
const iam = require("aws-cdk-lib/aws-iam");
const core_1 = require("aws-cdk-lib/core");
/**
 * Obtain the Role for the TopicRule
 *
 * If a role already exists, it will be returned. This ensures that if a rule have multiple
 * actions, they will share a role.
 * @internal
 */
function singletonActionRole(scope) {
    const id = 'TopicRuleActionRole';
    const existing = scope.node.tryFindChild(id);
    if (existing) {
        return existing;
    }
    ;
    const role = new iam.Role(scope, id, {
        roleName: core_1.PhysicalName.GENERATE_IF_NEEDED,
        assumedBy: new iam.ServicePrincipal('iot.amazonaws.com'),
    });
    return role;
}
exports.singletonActionRole = singletonActionRole;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicm9sZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInJvbGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsMkNBQTJDO0FBQzNDLDJDQUFnRDtBQUdoRDs7Ozs7O0dBTUc7QUFDSCxTQUFnQixtQkFBbUIsQ0FBQyxLQUFpQjtJQUNuRCxNQUFNLEVBQUUsR0FBRyxxQkFBcUIsQ0FBQztJQUNqQyxNQUFNLFFBQVEsR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxFQUFFLENBQWMsQ0FBQztJQUMxRCxJQUFJLFFBQVEsRUFBRTtRQUNaLE9BQU8sUUFBUSxDQUFDO0tBQ2pCO0lBQUEsQ0FBQztJQUVGLE1BQU0sSUFBSSxHQUFHLElBQUksR0FBRyxDQUFDLElBQUksQ0FBQyxLQUFrQixFQUFFLEVBQUUsRUFBRTtRQUNoRCxRQUFRLEVBQUUsbUJBQVksQ0FBQyxrQkFBa0I7UUFDekMsU0FBUyxFQUFFLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG1CQUFtQixDQUFDO0tBQ3pELENBQUMsQ0FBQztJQUNILE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQVpELGtEQVlDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgaWFtIGZyb20gJ2F3cy1jZGstbGliL2F3cy1pYW0nO1xuaW1wb3J0IHsgUGh5c2ljYWxOYW1lIH0gZnJvbSAnYXdzLWNkay1saWIvY29yZSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QsIElDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcblxuLyoqXG4gKiBPYnRhaW4gdGhlIFJvbGUgZm9yIHRoZSBUb3BpY1J1bGVcbiAqXG4gKiBJZiBhIHJvbGUgYWxyZWFkeSBleGlzdHMsIGl0IHdpbGwgYmUgcmV0dXJuZWQuIFRoaXMgZW5zdXJlcyB0aGF0IGlmIGEgcnVsZSBoYXZlIG11bHRpcGxlXG4gKiBhY3Rpb25zLCB0aGV5IHdpbGwgc2hhcmUgYSByb2xlLlxuICogQGludGVybmFsXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBzaW5nbGV0b25BY3Rpb25Sb2xlKHNjb3BlOiBJQ29uc3RydWN0KTogaWFtLklSb2xlIHtcbiAgY29uc3QgaWQgPSAnVG9waWNSdWxlQWN0aW9uUm9sZSc7XG4gIGNvbnN0IGV4aXN0aW5nID0gc2NvcGUubm9kZS50cnlGaW5kQ2hpbGQoaWQpIGFzIGlhbS5JUm9sZTtcbiAgaWYgKGV4aXN0aW5nKSB7XG4gICAgcmV0dXJuIGV4aXN0aW5nO1xuICB9O1xuXG4gIGNvbnN0IHJvbGUgPSBuZXcgaWFtLlJvbGUoc2NvcGUgYXMgQ29uc3RydWN0LCBpZCwge1xuICAgIHJvbGVOYW1lOiBQaHlzaWNhbE5hbWUuR0VORVJBVEVfSUZfTkVFREVELFxuICAgIGFzc3VtZWRCeTogbmV3IGlhbS5TZXJ2aWNlUHJpbmNpcGFsKCdpb3QuYW1hem9uYXdzLmNvbScpLFxuICB9KTtcbiAgcmV0dXJuIHJvbGU7XG59XG4iXX0=