"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsTopicAction = exports.SnsActionMessageFormat = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const role_1 = require("./private/role");
/**
 * SNS topic action message format options.
 */
var SnsActionMessageFormat;
(function (SnsActionMessageFormat) {
    /**
     * RAW message format.
     */
    SnsActionMessageFormat["RAW"] = "RAW";
    /**
     * JSON message format.
     */
    SnsActionMessageFormat["JSON"] = "JSON";
})(SnsActionMessageFormat || (exports.SnsActionMessageFormat = SnsActionMessageFormat = {}));
/**
 * The action to write the data from an MQTT message to an Amazon SNS topic.
 *
 * @see https://docs.aws.amazon.com/iot/latest/developerguide/sns-rule-action.html
 */
class SnsTopicAction {
    /**
     * @param topic The Amazon SNS topic to publish data on. Must not be a FIFO topic.
     * @param props Properties to configure the action.
     */
    constructor(topic, props = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_SnsTopicActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SnsTopicAction);
            }
            throw error;
        }
        if (topic.fifo) {
            throw Error('IoT Rule actions cannot be used with FIFO SNS Topics, please pass a non-FIFO Topic instead');
        }
        this.topic = topic;
        this.role = props.role;
        this.messageFormat = props.messageFormat;
    }
    /**
     * @internal
     */
    _bind(rule) {
        const role = this.role ?? (0, role_1.singletonActionRole)(rule);
        this.topic.grantPublish(role);
        return {
            configuration: {
                sns: {
                    targetArn: this.topic.topicArn,
                    roleArn: role.roleArn,
                    messageFormat: this.messageFormat,
                },
            },
        };
    }
}
exports.SnsTopicAction = SnsTopicAction;
_a = JSII_RTTI_SYMBOL_1;
SnsTopicAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.SnsTopicAction", version: "2.105.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic25zLXRvcGljLWFjdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInNucy10b3BpYy1hY3Rpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBSUEseUNBQXFEO0FBRXJEOztHQUVHO0FBQ0gsSUFBWSxzQkFVWDtBQVZELFdBQVksc0JBQXNCO0lBQ2hDOztPQUVHO0lBQ0gscUNBQVcsQ0FBQTtJQUVYOztPQUVHO0lBQ0gsdUNBQWEsQ0FBQTtBQUNmLENBQUMsRUFWVyxzQkFBc0Isc0NBQXRCLHNCQUFzQixRQVVqQztBQWlCRDs7OztHQUlHO0FBQ0gsTUFBYSxjQUFjO0lBS3pCOzs7T0FHRztJQUNILFlBQVksS0FBaUIsRUFBRSxRQUE2QixFQUFFOzs7Ozs7K0NBVG5ELGNBQWM7Ozs7UUFVdkIsSUFBSSxLQUFLLENBQUMsSUFBSSxFQUFFO1lBQ2QsTUFBTSxLQUFLLENBQUMsNEZBQTRGLENBQUMsQ0FBQztTQUMzRztRQUVELElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO1FBQ25CLElBQUksQ0FBQyxJQUFJLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQztRQUN2QixJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQyxhQUFhLENBQUM7S0FDMUM7SUFFRDs7T0FFRztJQUNJLEtBQUssQ0FBQyxJQUFvQjtRQUMvQixNQUFNLElBQUksR0FBRyxJQUFJLENBQUMsSUFBSSxJQUFJLElBQUEsMEJBQW1CLEVBQUMsSUFBSSxDQUFDLENBQUM7UUFDcEQsSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLENBQUM7UUFFOUIsT0FBTztZQUNMLGFBQWEsRUFBRTtnQkFDYixHQUFHLEVBQUU7b0JBQ0gsU0FBUyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUTtvQkFDOUIsT0FBTyxFQUFFLElBQUksQ0FBQyxPQUFPO29CQUNyQixhQUFhLEVBQUUsSUFBSSxDQUFDLGFBQWE7aUJBQ2xDO2FBQ0Y7U0FDRixDQUFDO0tBQ0g7O0FBbkNILHdDQW9DQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGlhbSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtaWFtJztcbmltcG9ydCAqIGFzIGlvdCBmcm9tICdAYXdzLWNkay9hd3MtaW90LWFscGhhJztcbmltcG9ydCAqIGFzIHNucyBmcm9tICdhd3MtY2RrLWxpYi9hd3Mtc25zJztcbmltcG9ydCB7IENvbW1vbkFjdGlvblByb3BzIH0gZnJvbSAnLic7XG5pbXBvcnQgeyBzaW5nbGV0b25BY3Rpb25Sb2xlIH0gZnJvbSAnLi9wcml2YXRlL3JvbGUnO1xuXG4vKipcbiAqIFNOUyB0b3BpYyBhY3Rpb24gbWVzc2FnZSBmb3JtYXQgb3B0aW9ucy5cbiAqL1xuZXhwb3J0IGVudW0gU25zQWN0aW9uTWVzc2FnZUZvcm1hdCB7XG4gIC8qKlxuICAgKiBSQVcgbWVzc2FnZSBmb3JtYXQuXG4gICAqL1xuICBSQVcgPSAnUkFXJyxcblxuICAvKipcbiAgICogSlNPTiBtZXNzYWdlIGZvcm1hdC5cbiAgICovXG4gIEpTT04gPSAnSlNPTidcbn1cblxuLyoqXG4gKiBDb25maWd1cmF0aW9uIG9wdGlvbnMgZm9yIHRoZSBTTlMgdG9waWMgYWN0aW9uLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIFNuc1RvcGljQWN0aW9uUHJvcHMgZXh0ZW5kcyBDb21tb25BY3Rpb25Qcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgbWVzc2FnZSBmb3JtYXQgb2YgdGhlIG1lc3NhZ2UgdG8gcHVibGlzaC5cbiAgICpcbiAgICogU05TIHVzZXMgdGhpcyBzZXR0aW5nIHRvIGRldGVybWluZSBpZiB0aGUgcGF5bG9hZCBzaG91bGQgYmUgcGFyc2VkIGFuZCByZWxldmFudCBwbGF0Zm9ybS1zcGVjaWZpYyBiaXRzIG9mIHRoZSBwYXlsb2FkIHNob3VsZCBiZSBleHRyYWN0ZWQuXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Nucy9sYXRlc3QvZGcvc25zLW1lc3NhZ2UtYW5kLWpzb24tZm9ybWF0cy5odG1sXG4gICAqXG4gICAqIEBkZWZhdWx0IFNuc0FjdGlvbk1lc3NhZ2VGb3JtYXQuUkFXXG4gICAqL1xuICByZWFkb25seSBtZXNzYWdlRm9ybWF0PzogU25zQWN0aW9uTWVzc2FnZUZvcm1hdDtcbn1cblxuLyoqXG4gKiBUaGUgYWN0aW9uIHRvIHdyaXRlIHRoZSBkYXRhIGZyb20gYW4gTVFUVCBtZXNzYWdlIHRvIGFuIEFtYXpvbiBTTlMgdG9waWMuXG4gKlxuICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9kZXZlbG9wZXJndWlkZS9zbnMtcnVsZS1hY3Rpb24uaHRtbFxuICovXG5leHBvcnQgY2xhc3MgU25zVG9waWNBY3Rpb24gaW1wbGVtZW50cyBpb3QuSUFjdGlvbiB7XG4gIHByaXZhdGUgcmVhZG9ubHkgcm9sZT86IGlhbS5JUm9sZTtcbiAgcHJpdmF0ZSByZWFkb25seSB0b3BpYzogc25zLklUb3BpYztcbiAgcHJpdmF0ZSByZWFkb25seSBtZXNzYWdlRm9ybWF0PzogU25zQWN0aW9uTWVzc2FnZUZvcm1hdDtcblxuICAvKipcbiAgICogQHBhcmFtIHRvcGljIFRoZSBBbWF6b24gU05TIHRvcGljIHRvIHB1Ymxpc2ggZGF0YSBvbi4gTXVzdCBub3QgYmUgYSBGSUZPIHRvcGljLlxuICAgKiBAcGFyYW0gcHJvcHMgUHJvcGVydGllcyB0byBjb25maWd1cmUgdGhlIGFjdGlvbi5cbiAgICovXG4gIGNvbnN0cnVjdG9yKHRvcGljOiBzbnMuSVRvcGljLCBwcm9wczogU25zVG9waWNBY3Rpb25Qcm9wcyA9IHt9KSB7XG4gICAgaWYgKHRvcGljLmZpZm8pIHtcbiAgICAgIHRocm93IEVycm9yKCdJb1QgUnVsZSBhY3Rpb25zIGNhbm5vdCBiZSB1c2VkIHdpdGggRklGTyBTTlMgVG9waWNzLCBwbGVhc2UgcGFzcyBhIG5vbi1GSUZPIFRvcGljIGluc3RlYWQnKTtcbiAgICB9XG5cbiAgICB0aGlzLnRvcGljID0gdG9waWM7XG4gICAgdGhpcy5yb2xlID0gcHJvcHMucm9sZTtcbiAgICB0aGlzLm1lc3NhZ2VGb3JtYXQgPSBwcm9wcy5tZXNzYWdlRm9ybWF0O1xuICB9XG5cbiAgLyoqXG4gICAqIEBpbnRlcm5hbFxuICAgKi9cbiAgcHVibGljIF9iaW5kKHJ1bGU6IGlvdC5JVG9waWNSdWxlKTogaW90LkFjdGlvbkNvbmZpZyB7XG4gICAgY29uc3Qgcm9sZSA9IHRoaXMucm9sZSA/PyBzaW5nbGV0b25BY3Rpb25Sb2xlKHJ1bGUpO1xuICAgIHRoaXMudG9waWMuZ3JhbnRQdWJsaXNoKHJvbGUpO1xuXG4gICAgcmV0dXJuIHtcbiAgICAgIGNvbmZpZ3VyYXRpb246IHtcbiAgICAgICAgc25zOiB7XG4gICAgICAgICAgdGFyZ2V0QXJuOiB0aGlzLnRvcGljLnRvcGljQXJuLFxuICAgICAgICAgIHJvbGVBcm46IHJvbGUucm9sZUFybixcbiAgICAgICAgICBtZXNzYWdlRm9ybWF0OiB0aGlzLm1lc3NhZ2VGb3JtYXQsXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgIH07XG4gIH1cbn1cbiJdfQ==