"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StepFunctionsStateMachineAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const role_1 = require("./private/role");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * The action to put the record from an MQTT message to the Step Functions State Machine.
 */
class StepFunctionsStateMachineAction {
    /**
     * @param stateMachine The Step Functions Start Machine which shoud be executed.
     * @param props Optional properties to not use default
     */
    constructor(stateMachine, props) {
        this.stateMachine = stateMachine;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_StepFunctionsStateMachineActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, StepFunctionsStateMachineAction);
            }
            throw error;
        }
        this.executionNamePrefix = props?.executionNamePrefix;
        this.role = props?.role;
    }
    /**
     * @internal
     */
    _bind(rule) {
        const role = this.role ?? (0, role_1.singletonActionRole)(rule);
        const stateMachineName = aws_cdk_lib_1.Stack.of(this.stateMachine).splitArn(this.stateMachine.stateMachineArn, aws_cdk_lib_1.ArnFormat.COLON_RESOURCE_NAME).resourceName;
        if (!stateMachineName) {
            throw new Error(`No state machine name found in ARN: '${this.stateMachine.stateMachineArn}'`);
        }
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['states:StartExecution'],
            resources: [this.stateMachine.stateMachineArn],
        }));
        return {
            configuration: {
                stepFunctions: {
                    stateMachineName,
                    executionNamePrefix: this.executionNamePrefix,
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
exports.StepFunctionsStateMachineAction = StepFunctionsStateMachineAction;
_a = JSII_RTTI_SYMBOL_1;
StepFunctionsStateMachineAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.StepFunctionsStateMachineAction", version: "2.105.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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