"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationCostProfiler = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [application-cost-profiler](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapplicationcostprofilerservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class ApplicationCostProfiler extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [application-cost-profiler](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapplicationcostprofilerservice.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'application-cost-profiler';
        this.accessLevelList = {
            Write: [
                'DeleteReportDefinition',
                'ImportApplicationUsage',
                'PutReportDefinition',
                'UpdateReportDefinition'
            ],
            Read: [
                'GetReportDefinition',
                'ListReportDefinitions'
            ]
        };
    }
    /**
     * Grants permission to delete the configuration with specific Application Cost Profiler Report thereby effectively disabling report generation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-cost-profiler/latest/APIReference/API_DeleteReportDefinition.html
     */
    toDeleteReportDefinition() {
        return this.to('DeleteReportDefinition');
    }
    /**
     * Grants permission to fetch the configuration with specific Application Cost Profiler Report request
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-cost-profiler/latest/APIReference/API_GetReportDefinition.html
     */
    toGetReportDefinition() {
        return this.to('GetReportDefinition');
    }
    /**
     * Grants permission to import the application usage from S3
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-cost-profiler/latest/APIReference/API_ImportApplicationUsage.html
     */
    toImportApplicationUsage() {
        return this.to('ImportApplicationUsage');
    }
    /**
     * Grants permission to get a list of the different Application Cost Profiler Report configurations they have created
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-cost-profiler/latest/APIReference/API_ListReportDefinitions.html
     */
    toListReportDefinitions() {
        return this.to('ListReportDefinitions');
    }
    /**
     * Grants permission to create Application Cost Profiler Report configurations
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-cost-profiler/latest/APIReference/API_PutReportDefinition.html
     */
    toPutReportDefinition() {
        return this.to('PutReportDefinition');
    }
    /**
     * Grants permission to update an existing Application Cost Profiler Report configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-cost-profiler/latest/APIReference/API_UpdateReportDefinition.html
     */
    toUpdateReportDefinition() {
        return this.to('UpdateReportDefinition');
    }
}
exports.ApplicationCostProfiler = ApplicationCostProfiler;
_a = JSII_RTTI_SYMBOL_1;
ApplicationCostProfiler[_a] = { fqn: "cdk-iam-floyd.ApplicationCostProfiler", version: "0.374.0" };
//# sourceMappingURL=data:application/json;base64,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