"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoscalingPlans = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [autoscaling-plans](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsautoscaling.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class AutoscalingPlans extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [autoscaling-plans](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsautoscaling.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'autoscaling-plans';
        this.accessLevelList = {
            Write: [
                'CreateScalingPlan',
                'DeleteScalingPlan',
                'UpdateScalingPlan'
            ],
            Read: [
                'DescribeScalingPlanResources',
                'DescribeScalingPlans',
                'GetScalingPlanResourceForecastData'
            ]
        };
    }
    /**
     * Creates a scaling plan.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_CreateScalingPlan.html
     */
    toCreateScalingPlan() {
        return this.to('CreateScalingPlan');
    }
    /**
     * Deletes the specified scaling plan.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_DeleteScalingPlan.html
     */
    toDeleteScalingPlan() {
        return this.to('DeleteScalingPlan');
    }
    /**
     * Describes the scalable resources in the specified scaling plan.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_DescribeScalingPlanResources.html
     */
    toDescribeScalingPlanResources() {
        return this.to('DescribeScalingPlanResources');
    }
    /**
     * Describes the specified scaling plans or all of your scaling plans.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_DescribeScalingPlans.html
     */
    toDescribeScalingPlans() {
        return this.to('DescribeScalingPlans');
    }
    /**
     * Retrieves the forecast data for a scalable resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_GetScalingPlanResourceForecastData.html
     */
    toGetScalingPlanResourceForecastData() {
        return this.to('GetScalingPlanResourceForecastData');
    }
    /**
     * Updates a scaling plan.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_UpdateScalingPlan.html
     */
    toUpdateScalingPlan() {
        return this.to('UpdateScalingPlan');
    }
}
exports.AutoscalingPlans = AutoscalingPlans;
_a = JSII_RTTI_SYMBOL_1;
AutoscalingPlans[_a] = { fqn: "cdk-iam-floyd.AutoscalingPlans", version: "0.374.0" };
//# sourceMappingURL=data:application/json;base64,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