"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsPortal = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [aws-portal](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbilling.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class AwsPortal extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [aws-portal](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbilling.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'aws-portal';
        this.accessLevelList = {
            Write: [
                'ModifyAccount',
                'ModifyBilling',
                'ModifyPaymentMethods'
            ],
            Read: [
                'ViewAccount',
                'ViewBilling',
                'ViewPaymentMethods',
                'ViewUsage'
            ]
        };
    }
    /**
     * Allow or deny IAM users permission to modify Account Settings.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions
     */
    toModifyAccount() {
        return this.to('ModifyAccount');
    }
    /**
     * Allow or deny IAM users permission to modify billing settings.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions
     */
    toModifyBilling() {
        return this.to('ModifyBilling');
    }
    /**
     * Allow or deny IAM users permission to modify payment methods.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions
     */
    toModifyPaymentMethods() {
        return this.to('ModifyPaymentMethods');
    }
    /**
     * Allow or deny IAM users permission to view account settings.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions
     */
    toViewAccount() {
        return this.to('ViewAccount');
    }
    /**
     * Allow or deny IAM users permission to view billing pages in the console.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions
     */
    toViewBilling() {
        return this.to('ViewBilling');
    }
    /**
     * Allow or deny IAM users permission to view payment methods.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions
     */
    toViewPaymentMethods() {
        return this.to('ViewPaymentMethods');
    }
    /**
     * Allow or deny IAM users permission to view AWS usage reports.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions
     */
    toViewUsage() {
        return this.to('ViewUsage');
    }
}
exports.AwsPortal = AwsPortal;
_a = JSII_RTTI_SYMBOL_1;
AwsPortal[_a] = { fqn: "cdk-iam-floyd.AwsPortal", version: "0.374.0" };
//# sourceMappingURL=data:application/json;base64,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